/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.date;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConverterNotFoundException;
import net.sinodawn.framework.utils.DateTimeUtils;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;

public interface JSR310ToStringGenericConverter<S extends Temporal> extends Converter<S, String> {
   default Class<S> getSourceType() {
      return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
   }

   default Class<String> getTargetType() {
      return String.class;
   }

   default String convert(S source) {
      if (source == null) {
         return null;
      } else {
         Class<S> sourceType = this.getSourceType();
         if (LocalDateTime.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalDateTime((LocalDateTime)source);
         } else if (LocalDate.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalDate((LocalDate)source);
         } else if (LocalTime.class.equals(sourceType)) {
            return DateTimeUtils.formatLocalTime((LocalTime)source);
         } else {
            throw new ConverterNotFoundException(sourceType, this.getTargetType());
         }
      }
   }

   public static enum LocalTimeToStringConverter implements JSR310ToStringGenericConverter<LocalTime> {
      INSTANCE;
   }

   public static enum LocalDateToStringConverter implements JSR310ToStringGenericConverter<LocalDate> {
      INSTANCE;
   }

   public static enum LocalDateTimeToStringConverter implements JSR310ToStringGenericConverter<LocalDateTime> {
      INSTANCE;
   }
}
