/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.date;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.ConverterFactory;
import net.sinodawn.framework.utils.ConvertUtils;
import java.time.temporal.Temporal;

public enum JSR310ToJSR310ConverterFactory implements ConverterFactory<Temporal, Temporal> {
   INSTANCE;

   public <T extends Temporal> Converter<Temporal, T> getConverter(Class<T> targetType) {
      return new JSR310ToJSR310Converter(targetType);
   }

   private class JSR310ToJSR310Converter<T extends Temporal> implements Converter<Temporal, T> {
      private final Class<T> jsr310Type;

      public JSR310ToJSR310Converter(Class<T> jsr310Type) {
         this.jsr310Type = jsr310Type;
      }

      public Class<Temporal> getSourceType() {
         return Temporal.class;
      }

      public Class<T> getTargetType() {
         return this.jsr310Type;
      }

      public T convert(Temporal source) {
         if (source == null) {
            return null;
         } else {
            long l = ConvertUtils.convert(source, Long.TYPE);
            return ConvertUtils.convert(l, this.getTargetType());
         }
      }
   }
}
