/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.date;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.utils.DateTimeUtils;
import java.lang.reflect.ParameterizedType;
import java.sql.Time;
import java.util.Date;

public interface DateToStringConverterFactory<S extends Date> extends Converter<S, String> {
   default Class<S> getSourceType() {
      return (Class)((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
   }

   default Class<String> getTargetType() {
      return String.class;
   }

   default String convert(S source) {
      Class<S> sourceType = this.getSourceType();
      return Time.class.equals(sourceType) ? DateTimeUtils.formatTime(source) : DateTimeUtils.formatDateTime(source);
   }

   public static enum TimeToStringConverter implements DateToStringConverterFactory<Time> {
      INSTANCE;
   }

   public static enum DateToStringConverter implements DateToStringConverterFactory<Date> {
      INSTANCE;
   }
}
