/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.array;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.exception.TypeMismatchException;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import java.lang.reflect.Array;

public interface PrimitiveToWrapperArrayConverter<S, T> extends Converter<S, T> {
   default T convert(S source) {
      if (source == null) {
         return null;
      } else {
         Class<?> primitiveType = ArrayUtils.getArrayType(this.getSourceType());
         Class<?> wrapperType = ArrayUtils.getArrayType(this.getTargetType());
         if (ClassUtils.getWrapperType(primitiveType) != wrapperType) {
            throw new TypeMismatchException(wrapperType, ClassUtils.getWrapperType(primitiveType));
         } else {
            int size = Array.getLength(source);
            T result = (T) Array.newInstance(wrapperType, size);

            for(int i = 0; i < size; ++i) {
               Array.set(result, i, Array.get(source, i));
            }

            return result;
         }
      }
   }

   public static enum PrimitiveToWrapperLongArrayConverter implements PrimitiveToWrapperArrayConverter<long[], Long[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperFloatArrayConverter implements PrimitiveToWrapperArrayConverter<float[], Float[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperDoubleArrayConverter implements PrimitiveToWrapperArrayConverter<double[], Double[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperIntegerArrayConverter implements PrimitiveToWrapperArrayConverter<int[], Integer[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperShortArrayConverter implements PrimitiveToWrapperArrayConverter<short[], Short[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperCharacterArrayConverter implements PrimitiveToWrapperArrayConverter<char[], Character[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperByteArrayConverter implements PrimitiveToWrapperArrayConverter<byte[], Byte[]> {
      INSTANCE;
   }

   public static enum PrimitiveToWrapperBooleanArrayConverter implements PrimitiveToWrapperArrayConverter<boolean[], Boolean[]> {
      INSTANCE;
   }
}
