/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.array;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;

public enum PrimitiveCharacterArrayToClobConverter implements Converter<char[], Clob> {
   INSTANCE;

   public Clob convert(char[] source) {
      if (source == null) {
         return null;
      } else {
         try {
            return new SerialClob(source);
         } catch (SQLException var3) {
            throw new ConvertFailedException(char[].class, Clob.class, var3);
         }
      }
   }
}
