/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter.array;

import net.sinodawn.framework.converter.Converter;
import net.sinodawn.framework.converter.exception.ConvertFailedException;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;

public enum PrimitiveByteArrayToBlobConverter implements Converter<byte[], Blob> {
   INSTANCE;

   public Blob convert(byte[] source) {
      if (source == null) {
         return null;
      } else {
         try {
            return new SerialBlob(source);
         } catch (SQLException var3) {
            throw new ConvertFailedException(byte[].class, Blob.class, var3);
         }
      }
   }
}
