/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.converter;

import net.sinodawn.framework.converter.exception.ConverterNotFoundException;

import java.lang.reflect.ParameterizedType;
import java.util.Arrays;

@SuppressWarnings({"unchecked", "rawtypes", "unused"})
public interface Convertable<S, T> {
    default Class<S> getSourceType() {
        return (Class)((ParameterizedType) Arrays.stream(this.getClass().getGenericInterfaces())
                .findFirst().orElseThrow(ConverterNotFoundException::new)).getActualTypeArguments()[0];
    }

    default Class<T> getTargetType() {
        return (Class)((ParameterizedType) Arrays.stream(this.getClass().getGenericInterfaces())
                .findFirst().orElseThrow(ConverterNotFoundException::new)).getActualTypeArguments()[1];
    }

    default boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.getSourceType().isAssignableFrom(sourceType) && this.getTargetType().isAssignableFrom(targetType);
    }
}
