/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context.filter;

import net.sinodawn.framework.context.LocalContextHelper;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ContextServletRequestFilter implements Filter {
   public void init(FilterConfig filterConfig) throws ServletException {
   }

   public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
      try {
         LocalContextHelper.setHttpServletRequest((HttpServletRequest)request);
         LocalContextHelper.setHttpServletResponse((HttpServletResponse)response);
         chain.doFilter(request, response);
      } finally {
         LocalContextHelper.removeHttpServletRequest();
         LocalContextHelper.removeHttpServletResponse();
      }

   }

   public void destroy() {
   }
}
