/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context.aspect;

import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.ServletUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletResponse;

@Aspect
@Component
@Order(Integer.MAX_VALUE)
public class SinoResourceAspect {
   @Around("within(net.sinodawn..resource..*)")
   public Object doAspectResource(ProceedingJoinPoint pjp) throws Throwable {
      boolean var11 = false;

      Object var2;
      try {
         var11 = true;
         var2 = pjp.proceed();
         var11 = false;
      } finally {
         if (var11) {
            RequestMapping requestMapping = ReflectionUtils.getAnnotation(pjp.getTarget().getClass(), RequestMapping.class);
            if (requestMapping != null) {
               String[] paths = requestMapping.value();
               if (!ArrayUtils.isEmpty(paths)) {
                  HttpServletResponse response = ServletUtils.getCurrentResponse();
                  if (response != null) {
                     response.setHeader("SINO-INSTANT-SAVE-PATH", paths[0] + "/instant");
                  }
               }
            }

         }
      }

      RequestMapping requestMapping = ReflectionUtils.getAnnotation(pjp.getTarget().getClass(), RequestMapping.class);
      if (requestMapping != null) {
         String[] paths = requestMapping.value();
         if (!ArrayUtils.isEmpty(paths)) {
            HttpServletResponse response = ServletUtils.getCurrentResponse();
            if (response != null) {
               response.setHeader("SINO-INSTANT-SAVE-PATH", paths[0] + "/instant");
            }
         }
      }

      return var2;
   }
}
