/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context.aspect;

import net.sinodawn.framework.context.SinoAopContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(Integer.MIN_VALUE)
public class SinoContextAspect {
   @Around("(within(net.sinodawn..service..*)||within(net.sinodawn..schedule..*)||within(net.sinodawn..dao..*))&&!@annotation(net.sinodawn.framework.aspect.annotation.IgnoreAop)")
   public Object doAspect(ProceedingJoinPoint pjp) throws Throwable {
      boolean init = SinoAopContext.initCache();
      Object old = SinoAopContext.currentProxy();

      Object var4;
      try {
         SinoAopContext.setCurrentProxy(pjp.getThis());
         var4 = pjp.proceed();
      } finally {
         SinoAopContext.setCurrentProxy(old);
         if (init) {
            SinoAopContext.clearCache();
         }

      }

      return var4;
   }
}
