/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context;

import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;

import java.lang.annotation.Annotation;
import java.util.Map;

public class SinoBeanContext {
   private final Map<String, GenericService<?, ?>> TABLE_AWARE_SERVICE_CONTAINER = new CaseInsensitiveLinkedMap();
   private final Map<String, GenericService<?, ?>> RESTFULAPI_AWARE_SERVICE_CONTAINER = new CaseInsensitiveLinkedMap();
//   private final Map<String, GenericCloudResource<?, ?>> TABLE_AWARE_CLIENT_CONTAINER = new CaseInsensitiveLinkedMap();
   private static SinoBeanContext context;

   private SinoBeanContext() {
   }

   public static void init() {
      if (context == null) {
         Class var0 = SinoBeanContext.class;
         synchronized(SinoBeanContext.class) {
            if (context == null) {
               context = new SinoBeanContext();
               context.extranct(Repository.class);
               context.extranct(Service.class);
               context.extranct(Component.class);
               context.extranct(RequestMapping.class);
//               context.extranct(FeignClient.class);
            }
         }
      }

   }

//   public static <T extends GenericCloudResource<?, ?>> T getFeignClientByTable(String table) {
//      return context != null ? (GenericCloudResource)context.TABLE_AWARE_CLIENT_CONTAINER.get(table) : null;
//   }

   public static <T extends GenericService<?, ?>> T getServiceByTable(String table) {
      return context != null ? (T) context.TABLE_AWARE_SERVICE_CONTAINER.get(table) : null;
   }

   public static <T extends GenericService<?, ?>> T getServiceByRESTfulAPI(String restAPI) {
      return context != null ? (T) context.RESTFULAPI_AWARE_SERVICE_CONTAINER.get(restAPI) : null;
   }

   private void extranct(Class<? extends Annotation> annotationType) {
      ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
      Map<String, Object> map = applicationContext.getBeansWithAnnotation(annotationType);
      map.forEach((k, v) -> {
         Class<?> clazz = ClassUtils.getRawType(v.getClass());
         if (GenericService.class.isAssignableFrom(clazz)) {
            GenericService<?, ?> service = (GenericService)v;
            if (service.getDao() == null) {
               return;
            }

            String table = service.getDao().getTable();
            if (!StringUtils.isEmpty(table)) {
               if (!this.TABLE_AWARE_SERVICE_CONTAINER.containsKey(table)) {
                  this.TABLE_AWARE_SERVICE_CONTAINER.put(table, service);
               } else {
                  GenericService<?, ?> oldService = (GenericService)this.TABLE_AWARE_SERVICE_CONTAINER.get(table);
                  Class<?> oldClazzx = ClassUtils.getRawType(oldService.getClass());
                  if (clazz.isAssignableFrom(oldClazzx)) {
                     this.TABLE_AWARE_SERVICE_CONTAINER.put(table, service);
                  }
               }
            }
         } else if (GenericResource.class.isAssignableFrom(clazz)) {
            RequestMapping requestMapping = (RequestMapping)ReflectionUtils.getAnnotation(clazz, RequestMapping.class);
            GenericResource<?, ?, ?> resource = (GenericResource)v;
            if (requestMapping != null) {
               String[] var17 = requestMapping.value();
               int var19 = var17.length;

               for(int var9 = 0; var9 < var19; ++var9) {
                  String value = var17[var9];
                  this.RESTFULAPI_AWARE_SERVICE_CONTAINER.put(value, resource.getService());
               }
            }
//         } else if (GenericCloudResource.class.isAssignableFrom(clazz)) {
//            GenericCloudResource<?, ?> genericCloudResource = (GenericCloudResource)v;
//            Class<?> persistableClass = ResolvableType.forClass(genericCloudResource.getClass()).as(GenericCloudResource.class).getGeneric(new int[]{0}).resolve();
//            String tablex = PersistableMetadataHelper.getTableName(persistableClass);
//            if (FeignClient.class.equals(annotationType)) {
//               if (!this.TABLE_AWARE_CLIENT_CONTAINER.containsKey(tablex)) {
//                  this.TABLE_AWARE_CLIENT_CONTAINER.put(tablex, genericCloudResource);
//               } else {
//                  GenericCloudResource<?, ?> oldGenericCloudResource = (GenericCloudResource)this.TABLE_AWARE_CLIENT_CONTAINER.get(tablex);
//                  Class<?> oldClazz = ClassUtils.getRawType(oldGenericCloudResource.getClass());
//                  if (clazz.isAssignableFrom(oldClazz)) {
//                     this.TABLE_AWARE_CLIENT_CONTAINER.put(tablex, genericCloudResource);
//                  }
//               }
//            } else if (RequestMapping.class.equals(annotationType)) {
//               RequestMapping requestMappingx = (RequestMapping)ReflectionUtils.getAnnotation(clazz, RequestMapping.class);
//               String[] var23 = requestMappingx.value();
//               int var24 = var23.length;
//
//               for(int var11 = 0; var11 < var24; ++var11) {
//                  String valuex = var23[var11];
//                  this.RESTFULAPI_AWARE_SERVICE_CONTAINER.put(valuex, this.TABLE_AWARE_SERVICE_CONTAINER.get(tablex));
//               }
//            }
         }

      });
   }
}
