/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context;

import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.security.bean.LoginUser;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
public class LocalContextHelper {
   private static final ThreadLocal<Boolean> SELECT_COUNT_ONLY_FLAG = new ThreadLocal();
   private static final ThreadLocal<Boolean> SELECT_DATA_ONLY_FLAG = new ThreadLocal();
   private static final ThreadLocal<HttpServletRequest> SERVLET_REQUEST_CONTAIER = new ThreadLocal();
   private static final ThreadLocal<HttpServletResponse> SERVLET_RESPONSE_CONTAIER = new ThreadLocal();
   private static CoreUserService userService;

   @Autowired(
      required = true
   )
   @Lazy
   public void setCoreUserService(CoreUserService userService) {
      LocalContextHelper.userService = userService;
   }

   public static void setUserLogin(LoginUser loginUser) {
      if (!loginUser.getUsername().equals(getLoginUserId())) {
         SecurityContextHolder.getContext().setAuthentication(new AbstractAuthenticationToken(null) {
            private static final long serialVersionUID = -6852867025889280418L;

            public Object getCredentials() {
               return null;
            }

            public Object getPrincipal() {
               return loginUser;
            }

            public boolean isAuthenticated() {
               return true;
            }
         });
      }

   }

   public static void removeUserLogin() {
      SecurityContextHolder.getContext().setAuthentication(null);
   }

   public static boolean isUserLogin() {
      return getLoginAuthentication() != null;
   }

   public static boolean isAdminLogin() {
      return isUserLogin() ? "sysAdmin".equals(getLoginUser().getUserType()) : false;
   }

   public static String getLoginUserId() {
      return getLoginUser().getId();
   }

   public static String getLoginUserName() {
      return getLoginUser().getUserName();
   }

   public static String getLoginOrgId() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? null : ((LoginUser)authentication.getPrincipal()).getOrgId();
   }

   public static String getLoginOrgName() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? null : ((LoginUser)authentication.getPrincipal()).getOrgName();
   }

   public static Long getLoginRoleId() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? null : ((LoginUser)authentication.getPrincipal()).getRoleId();
   }

   public static String getLoginRoleName() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? null : ((LoginUser)authentication.getPrincipal()).getRoleName();
   }

   public static CoreUserBean getLoginUser() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? new CoreUserBean() : userService.selectById(authentication.getName());
   }

   public static LoginUser getLoginPrincipal() {
      Authentication authentication = getLoginAuthentication();
      return authentication == null ? null : (LoginUser)authentication.getPrincipal();
   }

   public static boolean isSelectCountOnly() {
      return SELECT_COUNT_ONLY_FLAG.get() != null && SELECT_COUNT_ONLY_FLAG.get();
   }

   public static void setSelectCountOnly() {
      SELECT_COUNT_ONLY_FLAG.set(true);
   }

   public static void removeSelectCountOnly() {
      SELECT_COUNT_ONLY_FLAG.remove();
   }

   public static boolean isSelectDataOnly() {
      return SELECT_DATA_ONLY_FLAG.get() != null && (Boolean)SELECT_DATA_ONLY_FLAG.get();
   }

   public static void setSelectDataOnly() {
      SELECT_DATA_ONLY_FLAG.set(true);
   }

   public static void removeSelectDataOnly() {
      SELECT_DATA_ONLY_FLAG.remove();
   }

   public static void setHttpServletRequest(HttpServletRequest request) {
      SERVLET_REQUEST_CONTAIER.set(request);
   }

   public static HttpServletRequest getHttpServletRequest() {
      return SERVLET_REQUEST_CONTAIER.get();
   }

   public static void removeHttpServletRequest() {
      SERVLET_REQUEST_CONTAIER.remove();
   }

   public static void setHttpServletResponse(HttpServletResponse response) {
      SERVLET_RESPONSE_CONTAIER.set(response);
   }

   public static HttpServletResponse getHttpServletResponse() {
      return SERVLET_RESPONSE_CONTAIER.get();
   }

   public static void removeHttpServletResponse() {
      SERVLET_RESPONSE_CONTAIER.remove();
   }

   private static Authentication getLoginAuthentication() {
      SecurityContext sc = SecurityContextHolder.getContext();
      Authentication authentication = sc.getAuthentication();
      if (authentication == null) {
         String userToken = AuthenticationHelper.getLoginUserToken();
         if (!StringUtils.isEmpty(userToken)) {
            authentication = AuthenticationHelper.getCacheAuthentication(userToken);
         }
      }

      if (authentication == null || !StringUtils.isEmpty(authentication.getName()) && !"anonymousUser".equals(authentication.getName())) {
         if (authentication != null) {
            sc.setAuthentication(authentication);
         }

         return authentication;
      } else {
         return null;
      }
   }
}
