/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.context;

import net.sinodawn.framework.exception.NotUniqueException;
import net.sinodawn.framework.id.SinoIdHelper;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.module.sys.constant.bean.CoreConstantBean;
import net.sinodawn.module.sys.constant.service.CoreConstantService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressWarnings({"unused", "rawtypes"})
@Component
public class ApplicationContextHelper implements ApplicationContextAware {

    private static ApplicationContext applicationContext;
    private static CoreConstantService constantService;
//    private static CoreSequenceService sequenceService;
    private static CoreTableService tableService;
    private static SqlSessionTemplate sqlSessionTemplate;


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHelper.applicationContext = applicationContext;
    }

    // TODO
    public static String getAppId() {
        return "439324902109242";
    };

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return getApplicationContext().getEnvironment();
    }

    public static <T> T getBean(Class<T> clazz) {
        return getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name) {
        Class<T> sinoClass = ClassUtils.getSinoClass(name);
        if (sinoClass == null) {
            return null;
        } else {
            Collection<T> collection = getApplicationContext().getBeansOfType(sinoClass).values();
            if (collection.size() > 1) {
                throw new NotUniqueException(name);
            } else {
                return collection.isEmpty() ? null : collection.iterator().next();
            }
        }
    }

    public static SqlSessionTemplate getMybatisSqlSessionTemplate() {
        if (sqlSessionTemplate == null) {
            Class var0 = ApplicationContextHelper.class;
            synchronized(ApplicationContextHelper.class) {
                if (sqlSessionTemplate == null) {
                    sqlSessionTemplate = getApplicationContext().getBean(SqlSessionTemplate.class);
                }
            }
        }

        return sqlSessionTemplate;
    }

    public static <T> T getBeanIfPresent(String name) {
        return getApplicationContext().containsBean(name) ? getBean(name) : null;
    }

    public static Long getNextIdentity() {
        return SinoIdHelper.nextId();
    }

    public static List<Long> getNextIdentityList(int qty) {
        List<Long> idList = new ArrayList<>();

        for(int i = 0; i < qty; ++i) {
            idList.add(SinoIdHelper.nextId());
        }

        return idList;
    }

    public static List<Long> getNextOrderNoList(int qty) {
        return getNextIdentityList(qty);
    }

    public static Long getNextOrderNo() {
        return getNextIdentity();
    }

    public static <T extends GenericService<?, ?>> T getServiceByTable(String table) {
        return SinoBeanContext.getServiceByTable(table);
    }

    public static boolean isProfileActivated(String profile) {
        return ArrayUtils.contains(getApplicationContext().getEnvironment().getActiveProfiles(), profile);
    }


    public static String getConstantValue(String id) {
        return getConstantValue(id, "");
    }

    public static String getConstantValue(String id, String defaultValue) {
        CoreConstantBean constant = getCoreConstantService().selectByIdIfPresent(id);
        return constant == null ? defaultValue : constant.getConstantValue();
    }

    public static <ID extends Serializable> List<CoreParentTableInstanceDTO> getAncientTableInstanceList(String table, List<ID> idList) {
        if (tableService == null) {
            Class var2 = ApplicationContextHelper.class;
            synchronized(ApplicationContextHelper.class) {
                if (tableService == null) {
                    tableService = getApplicationContext().getBean(CoreTableService.class);
                }
            }
        }

        return tableService.selectAncientTableInstanceList(table, idList);
    }


    private static CoreConstantService getCoreConstantService() {
        if (constantService == null) {
            Class var0 = ApplicationContextHelper.class;
            synchronized(ApplicationContextHelper.class) {
                if (constantService == null) {
                    constantService = getApplicationContext().getBean(CoreConstantService.class);
                }
            }
        }

        return constantService;
    }
}
