/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.redis.keygen;

import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.utils.ArrayUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

@Component
public class SinoPrependLoginUserRoleIdKeyGenerator implements KeyGenerator {
   public Object generate(Object target, Method method, Object... params) {
      if (!ArrayUtils.isEmpty(params)) {
         Object param = params[0];
         if (param != null && (Number.class.isAssignableFrom(param.getClass()) || String.class.isAssignableFrom(param.getClass()))) {
            return LocalContextHelper.getLoginUserId() + (LocalContextHelper.getLoginRoleId() == null ? "" : LocalContextHelper.getLoginRoleId()) + "." + (String)ConvertUtils.convert(param, String.class);
         }
      }

      return LocalContextHelper.getLoginUserId() + (LocalContextHelper.getLoginRoleId() == null ? "" : LocalContextHelper.getLoginRoleId());
   }
}
