/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.redis.keygen;

import net.sinodawn.framework.cache.redis.annotation.SinoCacheEvict;
import net.sinodawn.framework.cache.redis.annotation.SinoCacheable;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

@Component
public class SinoKeyGenerator implements KeyGenerator {
   public Object generate(Object target, Method method, Object... params) {
      String constKey;
      SinoCacheable sinoCacheable = method.getAnnotation(SinoCacheable.class);
      if (sinoCacheable == null) {
         SinoCacheEvict sinoCacheEvict = method.getAnnotation(SinoCacheEvict.class);
         constKey = sinoCacheEvict.constKey();
      } else {
         constKey = sinoCacheable.constKey();
      }

      return StringUtils.isEmpty(constKey) ? ConvertUtils.convert(params[0], String.class) : constKey;
   }
}
