/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.redis.keygen;

import net.sinodawn.framework.utils.ConvertUtils;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

@Component
public class SinoConcatParamsKeyGenerator implements KeyGenerator {
   public Object generate(Object target, Method method, Object... params) {
      StringBuilder sb = new StringBuilder();
      Object[] var5 = params;
      int var6 = params.length;

      for(int var7 = 0; var7 < var6; ++var7) {
         Object param = var5[var7];
         if (param != null && !Number.class.isAssignableFrom(param.getClass()) && !String.class.isAssignableFrom(param.getClass())) {
            break;
         }

         if (sb.length() > 0) {
            sb.append(".");
         }

         sb.append((String)ConvertUtils.convert(param, String.class));
      }

      return sb.toString();
   }
}
