/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.redis.annotation;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
@CacheEvict
public @interface SinoCacheEvict {
   @AliasFor("cacheNames")
   String[] value() default {};

   @AliasFor("value")
   String[] cacheNames() default {};

   String constKey() default "";

   String keyGenerator() default "sinoKeyGenerator";
}
