/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.redis;

import net.sinodawn.framework.context.ApplicationContextHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

@SuppressWarnings({"unchecked", "unused", "rawtypes"})
@Component
public class RedisHelper {
    private static final String KEY_LINK_STRS = "::";
    private static RedisTemplate redisTemplate;

    public RedisHelper() {
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisHelper.redisTemplate = redisTemplate;
    }

    public static RedisTemplate<String, Object> getRedisTemplate() {
        if (redisTemplate == null) {
            redisTemplate = ApplicationContextHelper.getBean(RedisTemplate.class);
        }

        return redisTemplate;
    }

    public static <T> T get(String name, String key) {
        return (T) getRedisTemplate().opsForValue().get(getRedisKey(name, key));
    }

    public static <T> void put(String name, String key, T value) {
        getRedisTemplate().opsForValue().set(getRedisKey(name, key), value);
    }

    public static <T> boolean putIfAbsent(String name, String key, T value, int timeoutSeconds) {
        return !Boolean.FALSE.equals(getRedisTemplate().opsForValue().setIfAbsent(getRedisKey(name, key), value, timeoutSeconds, TimeUnit.SECONDS));
    }

    public static <T> void put(String name, String key, T value, int timeoutSeconds) {
        getRedisTemplate().opsForValue().set(getRedisKey(name, key), value, timeoutSeconds, TimeUnit.SECONDS);
    }

    public static void evict(String name, String key) {
        getRedisTemplate().opsForValue().getOperations().delete(getRedisKey(name, key));
    }

    public static void evict(String name) {
        RedisOperations<String, Object> redisOperations = getRedisTemplate().opsForValue().getOperations();
        redisOperations.delete(Objects.requireNonNull(redisOperations.keys(name + "::" + "*")));
    }

    public static void expire(String name, String key, int seconds) {
        getRedisTemplate().opsForValue().getOperations().expire(getRedisKey(name, key), seconds, TimeUnit.SECONDS);
    }

    private static String getRedisKey(String cacheName, String cacheKey) {
        return cacheName + "::" + cacheKey;
    }
}
