/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.cache.memory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SuppressWarnings({"unused", "unchecked"})
public class MemoryCacheManager {
    private static final ConcurrentMap<String, Object> CACHE = new ConcurrentHashMap<>();

    public MemoryCacheManager() {
    }

    public static void put(String key, Object value) {
        CACHE.put(key, value);
    }

    public static <T> T get(String key) {
        return (T) CACHE.get(key);
    }

    public static boolean isPresent(String key) {
        return CACHE.containsKey(key);
    }

    public static void remove(String key) {
        CACHE.remove(key);
    }
}
