/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.audit.aspect;

import net.sinodawn.framework.audit.AuditLogHelper;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnBean(
   name = {"auditLogListener"}
)
@Order(Integer.MAX_VALUE)
public class AuditLogAspect {
   public static final String REQUEST_HEADER_COMMENT_KEY = "auditTrailComment";
   public static final String REQUEST_HEADER_SIGNATURE_KEY = "auditSignature";
   public static final String REQUEST_HEADER_AUDIT_ACTIVITY_KEY = "auditActivity";

   @Around("@annotation(audit)")
   public Object auditService(ProceedingJoinPoint pjp, Audit audit) throws Throwable {
      boolean init = SinoAopContext.getCache("AUDIT_KEY") == null;
      if (init) {
         SinoAopContext.putCache("AUDIT_KEY", "1");
         SinoAopContext.putCache("AUDIT_EVENT_KEY", new ArrayList());
      }

      Object var5;
      try {
         HttpServletRequest request = ServletUtils.getCurrentRequest();
         if (request != null) {
            if (SinoAopContext.getCache("AUDIT_COMMENT_KEY") == null) {
               if (StringUtils.isEmpty(request.getHeader("auditTrailComment"))) {
                  SinoAopContext.putCache("AUDIT_COMMENT_KEY", request.getHeader("auditTrailComment"));
               } else {
                  SinoAopContext.putCache("AUDIT_COMMENT_KEY", URLDecoder.decode(request.getHeader("auditTrailComment"), "utf-8"));
               }
            }

            if (SinoAopContext.getCache("AUDIT_SIGNATURE_KEY") == null) {
               if (StringUtils.isEmpty(request.getHeader("auditSignature"))) {
                  SinoAopContext.putCache("AUDIT_SIGNATURE_KEY", request.getHeader("auditSignature"));
               } else {
                  SinoAopContext.putCache("AUDIT_SIGNATURE_KEY", URLDecoder.decode(request.getHeader("auditSignature"), "utf-8"));
               }
            }
         }

         if (SinoAopContext.getCache("AUDIT_ACTIVITY_KEY") == null) {
            if (request != null && !StringUtils.isEmpty(request.getHeader("auditActivity"))) {
               SinoAopContext.putCache("AUDIT_ACTIVITY_KEY", URLDecoder.decode(request.getHeader("auditActivity"), "utf-8"));
            } else {
               SinoAopContext.putCache("AUDIT_ACTIVITY_KEY", audit.value());
            }
         }

         var5 = pjp.proceed();
      } finally {
         if (init) {
            AuditLogHelper.flush();
            SinoAopContext.removeCache("AUDIT_KEY");
            SinoAopContext.removeCache("AUDIT_EVENT_KEY");
            SinoAopContext.removeCache("AUDIT_ACTIVITY_KEY");
         }

      }

      return var5;
   }
}
