/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.audit;

import net.sinodawn.framework.audit.event.AuditLogNotificationEvent;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.SinoAopContext;
import net.sinodawn.framework.data.CaseInsensitiveLinkedMap;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.BeanUtils;
import java.util.Arrays;
import java.util.List;

public class AuditLogHelper {
   public static final String AUDIT_KEY = "AUDIT_KEY";
   public static final String AUDIT_ACTIVITY_KEY = "AUDIT_ACTIVITY_KEY";
   public static final String AUDIT_COMMENT_KEY = "AUDIT_COMMENT_KEY";
   public static final String AUDIT_SIGNATURE_KEY = "AUDIT_SIGNATURE_KEY";
   public static final String AUDIT_EVENT_KEY = "AUDIT_EVENT_KEY";
   public static final List<String> IGNORE_TABLE_LIST = Arrays.asList("T_CORE_AUDIT_LOG", "T_CORE_AUDIT_LOG_ACTIVITY", "T_CORE_AUDIT_LOG_COLUMN", "T_CORE_LOG", "T_CORE_ESB_LOG", "T_CORE_EXPORT_LOG", "T_CORE_LOGIN_LOG");

   public static <ID> void insertAuditLog(String table, Persistable<ID> oldItem, Persistable<ID> newItem) {
      insertAuditLog(table, new CaseInsensitiveLinkedMap(BeanUtils.deeplyToMap(oldItem)), new CaseInsensitiveLinkedMap(BeanUtils.deeplyToMap(newItem)));
   }

   public static void insertAuditLog(String table, CaseInsensitiveLinkedMap<Object> oldValueMap, CaseInsensitiveLinkedMap<Object> newValueMap) {
      if (!IGNORE_TABLE_LIST.contains(table.toUpperCase())) {
         AuditLogNotificationEvent event = new AuditLogNotificationEvent(table, (String)SinoAopContext.getCache("AUDIT_ACTIVITY_KEY"), (String)SinoAopContext.getCache("AUDIT_COMMENT_KEY"), (String)SinoAopContext.getCache("AUDIT_SIGNATURE_KEY"), LocalContextHelper.getLoginUserId(), oldValueMap, newValueMap);
         List<AuditLogNotificationEvent> eventList = (List)SinoAopContext.getCache("AUDIT_EVENT_KEY");
         AuditLogNotificationEvent matchEvent = (AuditLogNotificationEvent)eventList.stream().filter((e) -> {
            return e.getSource().equals(event.getSource()) && e.getId().equals(event.getId());
         }).findFirst().orElse(null);
         if (matchEvent == null) {
            eventList.add(event);
         } else {
            matchEvent.setNewValueMap(event.getNewValueMap());
         }

      }
   }

   public static void flush() {
      List<AuditLogNotificationEvent> eventList = (List)SinoAopContext.getCache("AUDIT_EVENT_KEY");
      eventList.forEach((e) -> {
         ApplicationContextHelper.getApplicationContext().publishEvent(e);
      });
   }

   public static boolean auditable(AuditDatabaseOperation auditDatabaseOperation) {
      return SinoAopContext.getCache("AUDIT_KEY") == null ? false : (Boolean)ApplicationContextHelper.getEnvironment().getProperty(auditDatabaseOperation.getPropertyKey(), Boolean.class);
   }
}
