/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.at.annotation;

public enum AuditTrailType {
   INSERT("SINO.AT.INSERT"),
   IMPORT("SINO.AT.IMPORT"),
   UPDATE("SINO.AT.UPDATE"),
   SWAP("SINO.AT.SWAP"),
   DELETE("SINO.AT.DELETE"),
   ACTIVATE("SINO.AT.ACTIVATE"),
   DEACTIVATE("SINO.AT.DEACTIVATE"),
   SUSPEND("SINO.AT.SUSPEND"),
   UNSUSPEND("SINO.AT.UNSUSPEND"),
   PROCESS_START("SINO.AT.PROCESS_START"),
   PROCESS_WITHDRAW("SINO.AT.PROCESS_WITHDRAW"),
   PROCESS_COMPLETE("SINO.AT.PROCESS_COMPLETE"),
   PROCESS_TRANSFER("SINO.AT.PROCESS_TRANSFER"),
   PROCESS_END("SINO.AT.PROCESS_END"),
   PROCESS_TRANSITION("SINO.AT.PROCESS_TRANSITION"),
   PROCESS_DELEGATE("SINO.AT.PROCESS_DELEGATE"),
   PROCESS_REASSIGNMENT("SINO.AT.PROCESS_REASSIGNMENT"),
   PROCESS_COUNTERSIGN("SINO.AT.PROCESS_COUNTERSIGN"),
   PROCESS_TRIGGER("SINO.AT.PROCESS_TRIGGER"),
   PROCESS_REJECT("SINO.AT.PROCESS_REJECT"),
   PROCESS_UNDO("SINO.AT.PROCESS_UNDO"),
   SCHEDULE("SINO.AT.SCHEDULE"),
   CUSTOMIZE(null);

   private String name;

   private AuditTrailType(String name) {
      this.name = name;
   }

   public String getName() {
      return this.name;
   }
}
