/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.framework.at;

import net.sinodawn.framework.audit.AuditDatabaseOperation;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigLineBean;
import net.sinodawn.module.sys.at.service.CoreAuditTrailConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditTrailHelper {
   private static CoreAuditTrailConfigService configService;

   @Autowired
   public void setCoreAuditTrailConfigService(CoreAuditTrailConfigService configService) {
      AuditTrailHelper.configService = configService;
   }

   public static boolean auditTrailable(String table, AuditDatabaseOperation auditDatabaseOperation) {
      return !(Boolean)ApplicationContextHelper.getEnvironment().getProperty(auditDatabaseOperation.getPropertyKey(), Boolean.class) ? false : configService.auditTrailable(table);
   }

   public static boolean auditTrailableColumn(String table, String column) {
      List<CoreAuditTrailConfigLineBean> configLineList = configService.selectAuditTrailableLineList(table);
      return configLineList.stream().anyMatch((l) -> {
         return l.getColumnId().equalsIgnoreCase(column);
      });
   }

   public static boolean auditTrail() {
      return ApplicationContextHelper.getEnvironment().acceptsProfiles((p) -> {
         return p.test("audit-trail");
      });
   }
}
