/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.boot;

import net.sinodawn.framework.restful.resolver.string.ToJsonStringResolver;
import net.sinodawn.framework.restful.resolver.wrapper.ToRestJsonWrapperResolver;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import java.util.List;

@Configuration
@ComponentScan(
    useDefaultFilters = false,
    basePackages = {"net.sinodawn"},
    includeFilters = {@ComponentScan.Filter(
        type = FilterType.ANNOTATION,
        value = {Controller.class}
    ), @ComponentScan.Filter(
        type = FilterType.ANNOTATION,
        value = {RestController.class}
    )},
    excludeFilters = {@ComponentScan.Filter(
        type = FilterType.ASPECTJ,
        pattern = {"net.sinodawn.test..*"}
    )}
)
public class SinoApplicationMvcConfiguration extends WebMvcConfigurationSupport {
    @Override
    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new ToRestJsonWrapperResolver());
        argumentResolvers.add(new ToJsonStringResolver());
        super.addArgumentResolvers(argumentResolvers);
    }
}
