/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.simonvt.menudrawer.samples.ActionBarSherlockSample;
import net.simonvt.menudrawer.samples.BottomDrawerSample;
import net.simonvt.menudrawer.samples.BottomOverlaySample;
import net.simonvt.menudrawer.samples.FragmentSample;
import net.simonvt.menudrawer.samples.LayoutSample;
import net.simonvt.menudrawer.samples.LeftDrawerSample;
import net.simonvt.menudrawer.samples.LeftOverlaySample;
import net.simonvt.menudrawer.samples.ListActivitySample;
import net.simonvt.menudrawer.samples.RightDrawerSample;
import net.simonvt.menudrawer.samples.RightOverlaySample;
import net.simonvt.menudrawer.samples.StaticDrawerSample;
import net.simonvt.menudrawer.samples.TopDrawerSample;
import net.simonvt.menudrawer.samples.TopOverlaySample;
import net.simonvt.menudrawer.samples.ViewPagerSample;
import net.simonvt.menudrawer.samples.WindowSample;

public class SamplesActivity
extends ListActivity {
    private SamplesAdapter mAdapter;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAdapter = new SamplesAdapter();
        this.mAdapter.addHeader("Sliding drawer");
        this.mAdapter.addSample("Left drawer", "Only the content area is dragged.", LeftDrawerSample.class);
        this.mAdapter.addSample("Right drawer", "The menu is positioned to the right of the content", RightDrawerSample.class);
        this.mAdapter.addSample("Top drawer", "The menu is positioned above the content", TopDrawerSample.class);
        this.mAdapter.addSample("Bottom drawer", "The menu is positioned below the content", BottomDrawerSample.class);
        this.mAdapter.addSample("ListActivity sample", "Shows how to use the drawer with a ListActivity.", ListActivitySample.class);
        this.mAdapter.addSample("Window sample", "The entire window is dragged.", WindowSample.class);
        this.mAdapter.addSample("ViewPager", "A left drawer that can only be dragged open when the ViewPager is on the first page", ViewPagerSample.class);
        this.mAdapter.addSample("Layout xml", "The drawer and its menu and content is defined in XML", LayoutSample.class);
        this.mAdapter.addSample("Fragments", "Sample that uses fragments as the content", FragmentSample.class);
        this.mAdapter.addSample("ActionBarSherlock sample", "Showcases the drawer used with ActionBarSherlock.", ActionBarSherlockSample.class);
        this.mAdapter.addHeader("Static drawer");
        this.mAdapter.addSample("Static drawer", "The drawer is always visible", StaticDrawerSample.class);
        this.mAdapter.addHeader("Overlay drawer");
        this.mAdapter.addSample("Left overlay", "The drawer can be dragged in from the left.", LeftOverlaySample.class);
        this.mAdapter.addSample("Top overlay", "The drawer can be dragged in from the top.", TopOverlaySample.class);
        this.mAdapter.addSample("Right overlay", "The drawer can be dragged in from the right.", RightOverlaySample.class);
        this.mAdapter.addSample("Bottom overlay", "The drawer can be dragged in from the bottom.", BottomOverlaySample.class);
        this.setListAdapter((ListAdapter)this.mAdapter);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        SampleItem sample = (SampleItem)this.mAdapter.getItem(position);
        Intent i = new Intent((Context)this, sample.mClazz);
        this.startActivity(i);
    }

    public class SamplesAdapter
    extends BaseAdapter {
        private List<Object> mItems = new ArrayList<Object>();

        public void addHeader(String title) {
            this.mItems.add(new Header(title));
        }

        public void addSample(String title, String summary, Class clazz) {
            this.mItems.add(new SampleItem(title, summary, clazz));
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            return this.getItem(position) instanceof Header ? 0 : 1;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (this.getItemViewType(position) == 0) {
                TextView v = (TextView)convertView;
                if (v == null) {
                    v = (TextView)SamplesActivity.this.getLayoutInflater().inflate(2130903071, parent, false);
                }
                v.setText((CharSequence)((Header)this.getItem((int)position)).mTitle);
                return v;
            }
            SampleItem sample = (SampleItem)this.getItem(position);
            View v = convertView;
            if (v == null) {
                v = SamplesActivity.this.getLayoutInflater().inflate(2130903070, parent, false);
            }
            ((TextView)v.findViewById(2130968645)).setText((CharSequence)sample.mTitle);
            ((TextView)v.findViewById(2130968646)).setText((CharSequence)sample.mSummary);
            return v;
        }
    }

    private static class SampleItem {
        String mTitle;
        String mSummary;
        Class mClazz;

        public SampleItem(String title, String summary, Class clazz) {
            this.mTitle = title;
            this.mSummary = summary;
            this.mClazz = clazz;
        }
    }

    private static class Header {
        String mTitle;

        public Header(String title) {
            this.mTitle = title;
        }
    }
}

