/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.SeekBar;
import android.widget.TextView;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.samples.BaseListSample;
import net.simonvt.menudrawer.samples.Item;

public class LeftDrawerSample
extends BaseListSample {
    private static final String STATE_CONTENT_TEXT = "net.simonvt.menudrawer.samples.LeftDrawerSample.contentText";
    private String mContentText;
    private TextView mContentTextView;

    @Override
    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mContentText = inState.getString(STATE_CONTENT_TEXT);
        }
        this.mMenuDrawer.setContentView(2130903062);
        this.mMenuDrawer.setTouchMode(2);
        this.mMenuDrawer.setSlideDrawable(2130837618);
        this.mMenuDrawer.setDrawerIndicatorEnabled(true);
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mContentTextView = (TextView)this.findViewById(2130968638);
        this.mContentTextView.setText((CharSequence)this.mContentText);
        this.mMenuDrawer.setOnInterceptMoveEventListener(new MenuDrawer.OnInterceptMoveEventListener(){

            @Override
            public boolean isViewDraggable(View v, int dx, int x, int y) {
                return v instanceof SeekBar;
            }
        });
    }

    @Override
    protected void onMenuItemClicked(int position, Item item) {
        this.mContentTextView.setText((CharSequence)item.mTitle);
        this.mMenuDrawer.closeMenu();
    }

    @Override
    protected int getDragMode() {
        return 0;
    }

    @Override
    protected Position getDrawerPosition() {
        return Position.LEFT;
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_CONTENT_TEXT, this.mContentText);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }
}

