/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import net.simonvt.menudrawer.BuildLayerFrameLayout;
import net.simonvt.menudrawer.ColorDrawable;
import net.simonvt.menudrawer.FloatScroller;
import net.simonvt.menudrawer.NoClickThroughFrameLayout;
import net.simonvt.menudrawer.OverlayDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.R;
import net.simonvt.menudrawer.SlideDrawable;
import net.simonvt.menudrawer.SlidingDrawer;
import net.simonvt.menudrawer.SmoothInterpolator;
import net.simonvt.menudrawer.StaticDrawer;
import net.simonvt.menudrawer.ViewHelper;
import net.simonvt.menudrawer.compat.ActionBarHelper;

public abstract class MenuDrawer
extends ViewGroup {
    private static final String TAG = "MenuDrawer";
    private static final boolean DEBUG = false;
    protected static final int ANIMATION_DELAY = 16;
    private static final int DEFAULT_DRAG_BEZEL_DP = 24;
    private static final int DEFAULT_DROP_SHADOW_DP = 6;
    public static final int MENU_DRAG_CONTENT = 0;
    public static final int MENU_DRAG_WINDOW = 1;
    public static final int TOUCH_MODE_NONE = 0;
    public static final int TOUCH_MODE_BEZEL = 1;
    public static final int TOUCH_MODE_FULLSCREEN = 2;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_CLOSING = 1;
    public static final int STATE_DRAGGING = 2;
    public static final int STATE_OPENING = 4;
    public static final int STATE_OPEN = 8;
    static final boolean USE_TRANSLATIONS = Build.VERSION.SDK_INT >= 14;
    static final int INDICATOR_ANIM_DURATION = 800;
    private static final int DEFAULT_ANIMATION_DURATION = 600;
    protected static final Interpolator SMOOTH_INTERPOLATOR = new SmoothInterpolator();
    protected static final Interpolator INDICATOR_INTERPOLATOR = new AccelerateInterpolator();
    protected Drawable mMenuOverlay;
    protected boolean mDropShadowEnabled;
    protected int mDropShadowColor;
    protected Drawable mDropShadowDrawable;
    protected int mDropShadowSize;
    protected Bitmap mActiveIndicator;
    protected View mActiveView;
    protected int mActivePosition;
    private boolean mAllowIndicatorAnimation;
    protected final Rect mActiveRect = new Rect();
    private final Rect mTempRect = new Rect();
    private View mMenuView;
    protected BuildLayerFrameLayout mMenuContainer;
    protected BuildLayerFrameLayout mContentContainer;
    protected int mMenuSize;
    protected boolean mMenuVisible;
    private int mDragMode = 0;
    protected int mDrawerState = 0;
    protected int mTouchBezelSize;
    protected int mTouchSize;
    private OnDrawerStateChangeListener mOnDrawerStateChangeListener;
    protected int mTouchMode = 1;
    protected boolean mHardwareLayersEnabled = true;
    private Activity mActivity;
    private FloatScroller mIndicatorScroller;
    private Runnable mIndicatorRunnable = new Runnable(){

        @Override
        public void run() {
            MenuDrawer.this.animateIndicatorInvalidate();
        }
    };
    protected int mIndicatorStartPos;
    protected float mIndicatorOffset;
    protected boolean mIndicatorAnimating;
    protected Bundle mState;
    protected int mMaxAnimationDuration = 600;
    protected OnInterceptMoveEventListener mOnInterceptMoveEventListener;
    protected SlideDrawable mSlideDrawable;
    protected Drawable mThemeUpIndicator;
    protected boolean mDrawerIndicatorEnabled;
    private ActionBarHelper mActionBarHelper;
    private int mCurrentUpContentDesc;
    private int mDrawerOpenContentDesc;
    private int mDrawerClosedContentDesc;
    protected Position mPosition;
    private final Rect mIndicatorClipRect = new Rect();
    protected boolean mIsStatic;
    protected final Rect mDropShadowRect = new Rect();
    protected float mOffsetPixels;
    protected boolean mDrawOverlay;
    private ViewTreeObserver.OnScrollChangedListener mScrollListener = new ViewTreeObserver.OnScrollChangedListener(){

        public void onScrollChanged() {
            if (MenuDrawer.this.mActiveView != null && MenuDrawer.this.isViewDescendant(MenuDrawer.this.mActiveView)) {
                MenuDrawer.this.mActiveView.getDrawingRect(MenuDrawer.this.mTempRect);
                MenuDrawer.this.offsetDescendantRectToMyCoords(MenuDrawer.this.mActiveView, MenuDrawer.this.mTempRect);
                if (((MenuDrawer)MenuDrawer.this).mTempRect.left != MenuDrawer.this.mActiveRect.left || ((MenuDrawer)MenuDrawer.this).mTempRect.top != MenuDrawer.this.mActiveRect.top || ((MenuDrawer)MenuDrawer.this).mTempRect.right != MenuDrawer.this.mActiveRect.right || ((MenuDrawer)MenuDrawer.this).mTempRect.bottom != MenuDrawer.this.mActiveRect.bottom) {
                    MenuDrawer.this.invalidate();
                }
            }
        }
    };

    public static MenuDrawer attach(Activity activity) {
        return MenuDrawer.attach(activity, Type.BEHIND);
    }

    public static MenuDrawer attach(Activity activity, Type type) {
        return MenuDrawer.attach(activity, type, Position.LEFT);
    }

    public static MenuDrawer attach(Activity activity, Position position) {
        return MenuDrawer.attach(activity, Type.BEHIND, position);
    }

    public static MenuDrawer attach(Activity activity, Type type, Position position) {
        return MenuDrawer.attach(activity, type, position, 0);
    }

    public static MenuDrawer attach(Activity activity, Type type, Position position, int dragMode) {
        MenuDrawer menuDrawer = MenuDrawer.createMenuDrawer(activity, dragMode, position, type);
        menuDrawer.setId(R.id.md__drawer);
        switch (dragMode) {
            case 0: {
                MenuDrawer.attachToContent(activity, menuDrawer);
                break;
            }
            case 1: {
                MenuDrawer.attachToDecor(activity, menuDrawer);
                break;
            }
            default: {
                throw new RuntimeException("Unknown menu mode: " + dragMode);
            }
        }
        return menuDrawer;
    }

    private static MenuDrawer createMenuDrawer(Activity activity, int dragMode, Position position, Type type) {
        MenuDrawer drawer;
        if (type == Type.STATIC) {
            drawer = new StaticDrawer((Context)activity);
        } else if (type == Type.OVERLAY) {
            drawer = new OverlayDrawer(activity, dragMode);
            if (position == Position.LEFT) {
                drawer.setupUpIndicator(activity);
            }
        } else {
            drawer = new SlidingDrawer(activity, dragMode);
            if (position == Position.LEFT) {
                drawer.setupUpIndicator(activity);
            }
        }
        drawer.mDragMode = dragMode;
        drawer.mPosition = position;
        return drawer;
    }

    private static void attachToContent(Activity activity, MenuDrawer menuDrawer) {
        ViewGroup content = (ViewGroup)activity.findViewById(0x1020002);
        content.removeAllViews();
        content.addView((View)menuDrawer, -1, -1);
    }

    private static void attachToDecor(Activity activity, MenuDrawer menuDrawer) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decorView.getChildAt(0);
        decorView.removeAllViews();
        decorView.addView((View)menuDrawer, -1, -1);
        menuDrawer.mContentContainer.addView((View)decorChild, decorChild.getLayoutParams());
    }

    MenuDrawer(Activity activity, int dragMode) {
        this((Context)activity);
        this.mActivity = activity;
        this.mDragMode = dragMode;
    }

    public MenuDrawer(Context context) {
        this(context, null);
    }

    public MenuDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.menuDrawerStyle);
    }

    public MenuDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initDrawer(context, attrs, defStyle);
    }

    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        this.setWillNotDraw(false);
        this.setFocusable(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuDrawer, R.attr.menuDrawerStyle, R.style.Widget_MenuDrawer);
        Drawable contentBackground = a.getDrawable(0);
        Drawable menuBackground = a.getDrawable(1);
        this.mMenuSize = a.getDimensionPixelSize(2, this.dpToPx(240));
        int indicatorResId = a.getResourceId(3, 0);
        if (indicatorResId != 0) {
            this.mActiveIndicator = BitmapFactory.decodeResource((Resources)this.getResources(), (int)indicatorResId);
        }
        this.mDropShadowEnabled = a.getBoolean(4, true);
        this.mDropShadowDrawable = a.getDrawable(7);
        if (this.mDropShadowDrawable == null) {
            this.mDropShadowColor = a.getColor(6, -16777216);
        }
        this.mDropShadowSize = a.getDimensionPixelSize(5, this.dpToPx(6));
        this.mTouchBezelSize = a.getDimensionPixelSize(8, this.dpToPx(24));
        this.mAllowIndicatorAnimation = a.getBoolean(9, false);
        this.mMaxAnimationDuration = a.getInt(10, 600);
        int slideDrawableResId = a.getResourceId(11, -1);
        if (slideDrawableResId != -1) {
            this.setSlideDrawable(slideDrawableResId);
        }
        this.mDrawerOpenContentDesc = a.getResourceId(12, 0);
        this.mDrawerClosedContentDesc = a.getResourceId(13, 0);
        this.mDrawOverlay = a.getBoolean(14, true);
        int position = a.getInt(15, 0);
        this.mPosition = Position.fromValue(position);
        a.recycle();
        this.mMenuContainer = new NoClickThroughFrameLayout(context);
        this.mMenuContainer.setId(R.id.md__menu);
        this.mMenuContainer.setBackgroundDrawable(menuBackground);
        this.mContentContainer = new NoClickThroughFrameLayout(context);
        this.mContentContainer.setId(R.id.md__content);
        this.mContentContainer.setBackgroundDrawable(contentBackground);
        this.mMenuOverlay = new ColorDrawable(-16777216);
        this.mIndicatorScroller = new FloatScroller(SMOOTH_INTERPOLATOR);
    }

    protected void onFinishInflate() {
        View content;
        super.onFinishInflate();
        View menu = this.findViewById(R.id.mdMenu);
        if (menu != null) {
            this.removeView(menu);
            this.setMenuView(menu);
        }
        if ((content = this.findViewById(R.id.mdContent)) != null) {
            this.removeView(content);
            this.setContentView(content);
        }
        if (this.getChildCount() > 2) {
            throw new IllegalStateException("Menu and content view added in xml must have id's @id/mdMenu and @id/mdContent");
        }
    }

    protected int dpToPx(int dp) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }

    protected boolean isViewDescendant(View v) {
        for (ViewParent parent = v.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnScrollChangedListener(this.mScrollListener);
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnScrollChangedListener(this.mScrollListener);
        super.onDetachedFromWindow();
    }

    private boolean shouldDrawIndicator() {
        return this.mActiveView != null && this.mActiveIndicator != null && this.isViewDescendant(this.mActiveView);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int offsetPixels = (int)this.mOffsetPixels;
        if (this.mDrawOverlay && offsetPixels != 0) {
            this.drawOverlay(canvas);
        }
        if (this.mDropShadowEnabled && (offsetPixels != 0 || this.mIsStatic)) {
            this.drawDropShadow(canvas);
        }
        if (this.shouldDrawIndicator() && offsetPixels != 0) {
            this.drawIndicator(canvas);
        }
    }

    protected abstract void drawOverlay(Canvas var1);

    private void drawDropShadow(Canvas canvas) {
        if (this.mDropShadowDrawable == null) {
            this.setDropShadowColor(this.mDropShadowColor);
        }
        this.updateDropShadowRect();
        this.mDropShadowDrawable.setBounds(this.mDropShadowRect);
        this.mDropShadowDrawable.draw(canvas);
    }

    protected void updateDropShadowRect() {
        switch (this.mPosition) {
            case LEFT: {
                this.mDropShadowRect.top = 0;
                this.mDropShadowRect.bottom = this.getHeight();
                this.mDropShadowRect.right = ViewHelper.getLeft((View)this.mContentContainer);
                this.mDropShadowRect.left = this.mDropShadowRect.right - this.mDropShadowSize;
                break;
            }
            case TOP: {
                this.mDropShadowRect.left = 0;
                this.mDropShadowRect.right = this.getWidth();
                this.mDropShadowRect.bottom = ViewHelper.getTop((View)this.mContentContainer);
                this.mDropShadowRect.top = this.mDropShadowRect.bottom - this.mDropShadowSize;
                break;
            }
            case RIGHT: {
                this.mDropShadowRect.top = 0;
                this.mDropShadowRect.bottom = this.getHeight();
                this.mDropShadowRect.left = ViewHelper.getRight((View)this.mContentContainer);
                this.mDropShadowRect.right = this.mDropShadowRect.left + this.mDropShadowSize;
                break;
            }
            case BOTTOM: {
                this.mDropShadowRect.left = 0;
                this.mDropShadowRect.right = this.getWidth();
                this.mDropShadowRect.top = ViewHelper.getBottom((View)this.mContentContainer);
                this.mDropShadowRect.bottom = this.mDropShadowRect.top + this.mDropShadowSize;
            }
        }
    }

    private void drawIndicator(Canvas canvas) {
        int pos;
        Integer position = (Integer)this.mActiveView.getTag(R.id.mdActiveViewPosition);
        int n = pos = position == null ? 0 : position;
        if (pos == this.mActivePosition) {
            this.updateIndicatorClipRect();
            canvas.save();
            canvas.clipRect(this.mIndicatorClipRect);
            int drawLeft = 0;
            int drawTop = 0;
            switch (this.mPosition) {
                case LEFT: 
                case TOP: {
                    drawLeft = this.mIndicatorClipRect.left;
                    drawTop = this.mIndicatorClipRect.top;
                    break;
                }
                case RIGHT: {
                    drawLeft = this.mIndicatorClipRect.right - this.mActiveIndicator.getWidth();
                    drawTop = this.mIndicatorClipRect.top;
                    break;
                }
                case BOTTOM: {
                    drawLeft = this.mIndicatorClipRect.left;
                    drawTop = this.mIndicatorClipRect.bottom - this.mActiveIndicator.getHeight();
                }
            }
            canvas.drawBitmap(this.mActiveIndicator, (float)drawLeft, (float)drawTop, null);
            canvas.restore();
        }
    }

    protected void updateIndicatorClipRect() {
        this.mActiveView.getDrawingRect(this.mActiveRect);
        this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
        float openRatio = this.mIsStatic ? 1.0f : Math.abs(this.mOffsetPixels) / (float)this.mMenuSize;
        float interpolatedRatio = 1.0f - INDICATOR_INTERPOLATOR.getInterpolation(1.0f - openRatio);
        int indicatorWidth = this.mActiveIndicator.getWidth();
        int indicatorHeight = this.mActiveIndicator.getHeight();
        int interpolatedWidth = (int)((float)indicatorWidth * interpolatedRatio);
        int interpolatedHeight = (int)((float)indicatorHeight * interpolatedRatio);
        int startPos = this.mIndicatorStartPos;
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        switch (this.mPosition) {
            case LEFT: 
            case RIGHT: {
                int finalTop = this.mActiveRect.top + (this.mActiveRect.height() - indicatorHeight) / 2;
                top = this.mIndicatorAnimating ? (int)((float)startPos + (float)(finalTop - startPos) * this.mIndicatorOffset) : finalTop;
                bottom = top + indicatorHeight;
                break;
            }
            case TOP: 
            case BOTTOM: {
                int finalLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                left = this.mIndicatorAnimating ? (int)((float)startPos + (float)(finalLeft - startPos) * this.mIndicatorOffset) : finalLeft;
                right = left + indicatorWidth;
            }
        }
        switch (this.mPosition) {
            case LEFT: {
                right = ViewHelper.getLeft((View)this.mContentContainer);
                left = right - interpolatedWidth;
                break;
            }
            case TOP: {
                bottom = ViewHelper.getTop((View)this.mContentContainer);
                top = bottom - interpolatedHeight;
                break;
            }
            case RIGHT: {
                left = ViewHelper.getRight((View)this.mContentContainer);
                right = left + interpolatedWidth;
                break;
            }
            case BOTTOM: {
                top = ViewHelper.getBottom((View)this.mContentContainer);
                bottom = top + interpolatedHeight;
            }
        }
        this.mIndicatorClipRect.left = left;
        this.mIndicatorClipRect.top = top;
        this.mIndicatorClipRect.right = right;
        this.mIndicatorClipRect.bottom = bottom;
    }

    public void toggleMenu() {
        this.toggleMenu(true);
    }

    public abstract void toggleMenu(boolean var1);

    public void openMenu() {
        this.openMenu(true);
    }

    public abstract void openMenu(boolean var1);

    public void closeMenu() {
        this.closeMenu(true);
    }

    public abstract void closeMenu(boolean var1);

    public abstract boolean isMenuVisible();

    public abstract void setMenuSize(int var1);

    public int getMenuSize() {
        return this.mMenuSize;
    }

    public void setActiveView(View v) {
        this.setActiveView(v, 0);
    }

    public void setActiveView(View v, int position) {
        View oldView = this.mActiveView;
        this.mActiveView = v;
        this.mActivePosition = position;
        if (this.mAllowIndicatorAnimation && oldView != null) {
            this.startAnimatingIndicator();
        }
        this.invalidate();
    }

    public void setAllowIndicatorAnimation(boolean animate) {
        if (animate != this.mAllowIndicatorAnimation) {
            this.mAllowIndicatorAnimation = animate;
            this.completeAnimatingIndicator();
        }
    }

    public boolean getAllowIndicatorAnimation() {
        return this.mAllowIndicatorAnimation;
    }

    private void startAnimatingIndicator() {
        this.mIndicatorStartPos = this.getIndicatorStartPos();
        this.mIndicatorAnimating = true;
        this.mIndicatorScroller.startScroll(0.0f, 1.0f, 800);
        this.animateIndicatorInvalidate();
    }

    private int getIndicatorStartPos() {
        switch (this.mPosition) {
            case TOP: {
                return this.mIndicatorClipRect.left;
            }
            case RIGHT: {
                return this.mIndicatorClipRect.top;
            }
            case BOTTOM: {
                return this.mIndicatorClipRect.left;
            }
        }
        return this.mIndicatorClipRect.top;
    }

    protected void updateTouchAreaSize() {
        this.mTouchSize = this.mTouchMode == 1 ? this.mTouchBezelSize : (this.mTouchMode == 2 ? this.getMeasuredWidth() : 0);
    }

    private void animateIndicatorInvalidate() {
        if (this.mIndicatorScroller.computeScrollOffset()) {
            this.mIndicatorOffset = this.mIndicatorScroller.getCurr();
            this.invalidate();
            if (!this.mIndicatorScroller.isFinished()) {
                this.postOnAnimation(this.mIndicatorRunnable);
                return;
            }
        }
        this.completeAnimatingIndicator();
    }

    private void completeAnimatingIndicator() {
        this.mIndicatorOffset = 1.0f;
        this.mIndicatorAnimating = false;
        this.invalidate();
    }

    public abstract void setOffsetMenuEnabled(boolean var1);

    public abstract boolean getOffsetMenuEnabled();

    public int getDrawerState() {
        return this.mDrawerState;
    }

    public void setOnDrawerStateChangeListener(OnDrawerStateChangeListener listener) {
        this.mOnDrawerStateChangeListener = listener;
    }

    public void setOnInterceptMoveEventListener(OnInterceptMoveEventListener listener) {
        this.mOnInterceptMoveEventListener = listener;
    }

    public void setDropShadowEnabled(boolean enabled) {
        this.mDropShadowEnabled = enabled;
        this.invalidate();
    }

    protected GradientDrawable.Orientation getDropShadowOrientation() {
        switch (this.mPosition) {
            case TOP: {
                return GradientDrawable.Orientation.BOTTOM_TOP;
            }
            case RIGHT: {
                return GradientDrawable.Orientation.LEFT_RIGHT;
            }
            case BOTTOM: {
                return GradientDrawable.Orientation.TOP_BOTTOM;
            }
        }
        return GradientDrawable.Orientation.RIGHT_LEFT;
    }

    public void setDropShadowColor(int color2) {
        GradientDrawable.Orientation orientation = this.getDropShadowOrientation();
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(orientation, new int[]{color2, endColor});
        this.invalidate();
    }

    public void setDropShadow(Drawable drawable2) {
        this.mDropShadowDrawable = drawable2;
        this.invalidate();
    }

    public void setDropShadow(int resId) {
        this.setDropShadow(this.getResources().getDrawable(resId));
    }

    public Drawable getDropShadow() {
        return this.mDropShadowDrawable;
    }

    public void setDropShadowSize(int size) {
        this.mDropShadowSize = size;
        this.invalidate();
    }

    public abstract void peekDrawer();

    public abstract void peekDrawer(long var1);

    public abstract void peekDrawer(long var1, long var3);

    public abstract void setHardwareLayerEnabled(boolean var1);

    public void setMaxAnimationDuration(int duration) {
        this.mMaxAnimationDuration = duration;
    }

    public void setDrawOverlay(boolean drawOverlay) {
        this.mDrawOverlay = drawOverlay;
    }

    public boolean getDrawOverlay() {
        return this.mDrawOverlay;
    }

    protected void updateUpContentDescription() {
        int upContentDesc;
        int n = upContentDesc = this.isMenuVisible() ? this.mDrawerOpenContentDesc : this.mDrawerClosedContentDesc;
        if (this.mDrawerIndicatorEnabled && this.mActionBarHelper != null && upContentDesc != this.mCurrentUpContentDesc) {
            this.mCurrentUpContentDesc = upContentDesc;
            this.mActionBarHelper.setActionBarDescription(upContentDesc);
        }
    }

    public void setSlideDrawable(int drawableRes) {
        this.setSlideDrawable(this.getResources().getDrawable(drawableRes));
    }

    public void setSlideDrawable(Drawable drawable2) {
        this.mSlideDrawable = new SlideDrawable(drawable2);
        if (this.mActionBarHelper != null) {
            this.mActionBarHelper.setDisplayShowHomeAsUpEnabled(true);
            if (this.mDrawerIndicatorEnabled) {
                this.mActionBarHelper.setActionBarUpIndicator(this.mSlideDrawable, this.isMenuVisible() ? this.mDrawerOpenContentDesc : this.mDrawerClosedContentDesc);
            }
        }
    }

    public void setupUpIndicator(Activity activity) {
        if (this.mActionBarHelper == null) {
            this.mActionBarHelper = new ActionBarHelper(activity);
            this.mThemeUpIndicator = this.mActionBarHelper.getThemeUpIndicator();
            if (this.mDrawerIndicatorEnabled) {
                this.mActionBarHelper.setActionBarUpIndicator(this.mSlideDrawable, this.isMenuVisible() ? this.mDrawerOpenContentDesc : this.mDrawerClosedContentDesc);
            }
        }
    }

    public void setDrawerIndicatorEnabled(boolean enabled) {
        if (this.mActionBarHelper == null) {
            throw new IllegalStateException("setupUpIndicator(Activity) has not been called");
        }
        this.mDrawerIndicatorEnabled = enabled;
        if (enabled) {
            this.mActionBarHelper.setActionBarUpIndicator(this.mSlideDrawable, this.isMenuVisible() ? this.mDrawerOpenContentDesc : this.mDrawerClosedContentDesc);
        } else {
            this.mActionBarHelper.setActionBarUpIndicator(this.mThemeUpIndicator, 0);
        }
    }

    public boolean isDrawerIndicatorEnabled() {
        return this.mDrawerIndicatorEnabled;
    }

    public ViewGroup getMenuContainer() {
        return this.mMenuContainer;
    }

    public ViewGroup getContentContainer() {
        if (this.mDragMode == 0) {
            return this.mContentContainer;
        }
        return (ViewGroup)this.findViewById(0x1020002);
    }

    public void setMenuView(int layoutResId) {
        this.mMenuContainer.removeAllViews();
        this.mMenuView = LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this.mMenuContainer, false);
        this.mMenuContainer.addView(this.mMenuView);
    }

    public void setMenuView(View view) {
        this.setMenuView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setMenuView(View view, ViewGroup.LayoutParams params) {
        this.mMenuView = view;
        this.mMenuContainer.removeAllViews();
        this.mMenuContainer.addView(view, params);
    }

    public View getMenuView() {
        return this.mMenuView;
    }

    public void setContentView(int layoutResId) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this.mContentContainer, true);
                break;
            }
            case 1: {
                this.mActivity.setContentView(layoutResId);
            }
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                this.mContentContainer.addView(view, params);
                break;
            }
            case 1: {
                this.mActivity.setContentView(view, params);
            }
        }
    }

    protected void setDrawerState(int state) {
        if (state != this.mDrawerState) {
            int oldState = this.mDrawerState;
            this.mDrawerState = state;
            if (this.mOnDrawerStateChangeListener != null) {
                this.mOnDrawerStateChangeListener.onDrawerStateChange(oldState, state);
            }
        }
    }

    protected void logDrawerState(int state) {
        switch (state) {
            case 0: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSED");
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSING");
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_DRAGGING");
                break;
            }
            case 4: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPENING");
                break;
            }
            case 8: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPEN");
                break;
            }
            default: {
                Log.d((String)TAG, (String)("[DrawerState] Unknown: " + state));
            }
        }
    }

    public abstract int getTouchMode();

    public abstract void setTouchMode(int var1);

    public abstract void setTouchBezelSize(int var1);

    public abstract int getTouchBezelSize();

    public void postOnAnimation(Runnable action) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.postOnAnimation(action);
        } else {
            this.postDelayed(action, 16L);
        }
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (this.mDragMode == 1) {
            this.mMenuContainer.setPadding(0, insets.top, 0, 0);
        }
        return super.fitSystemWindows(insets);
    }

    protected void dispatchOnDrawerSlide(float openRatio, int offsetPixels) {
        if (this.mOnDrawerStateChangeListener != null) {
            this.mOnDrawerStateChangeListener.onDrawerSlide(openRatio, offsetPixels);
        }
    }

    public final Parcelable saveState() {
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.saveState(this.mState);
        return this.mState;
    }

    void saveState(Bundle state) {
    }

    public void restoreState(Parcelable in) {
        this.mState = (Bundle)in;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.saveState(this.mState);
        state.mState = this.mState;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.restoreState((Parcelable)savedState.mState);
    }

    static class SavedState
    extends View.BaseSavedState {
        Bundle mState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.mState = in.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.mState);
        }
    }

    public static enum Type {
        BEHIND,
        STATIC,
        OVERLAY;

    }

    public static interface OnInterceptMoveEventListener {
        public boolean isViewDraggable(View var1, int var2, int var3, int var4);
    }

    public static interface OnDrawerStateChangeListener {
        public void onDrawerStateChange(int var1, int var2);

        public void onDrawerSlide(float var1, int var2);
    }
}

