/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.ArrayList;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.samples.BaseListSample;
import net.simonvt.menudrawer.samples.Item;

public class ViewPagerSample
extends BaseListSample {
    private PagerAdapter mPagerAdapter;
    private ViewPager mViewPager;
    private int mPagerOffsetPixels;
    private int mPagerPosition;

    @Override
    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        this.mMenuDrawer.setContentView(2130903067);
        this.mMenuDrawer.setSlideDrawable(2130837618);
        this.mMenuDrawer.setDrawerIndicatorEnabled(true);
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mMenuDrawer.setTouchMode(2);
        this.mMenuDrawer.setOnInterceptMoveEventListener(new MenuDrawer.OnInterceptMoveEventListener(){

            @Override
            public boolean isViewDraggable(View v, int dx, int x, int y) {
                if (v == ViewPagerSample.this.mViewPager) {
                    return ViewPagerSample.this.mPagerPosition != 0 || ViewPagerSample.this.mPagerOffsetPixels != 0 || dx < 0;
                }
                return false;
            }
        });
        this.mViewPager = (ViewPager)this.findViewById(2130968643);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                ViewPagerSample.this.mPagerPosition = position;
                ViewPagerSample.this.mPagerOffsetPixels = positionOffsetPixels;
            }
        });
        this.mPagerAdapter = new PagerAdapter(this);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mViewPager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
    }

    @Override
    protected void onMenuItemClicked(int position, Item item) {
        this.mMenuDrawer.closeMenu();
    }

    @Override
    protected int getDragMode() {
        return 0;
    }

    @Override
    protected Position getDrawerPosition() {
        return Position.LEFT;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }

    public static class TextViewFragment
    extends Fragment {
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            FrameLayout frameLayout = new FrameLayout((Context)this.getActivity());
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            TextView tv = new TextView((Context)this.getActivity());
            tv.setText((CharSequence)"This is an example of a Fragment in a View Pager");
            frameLayout.addView((View)tv);
            return frameLayout;
        }
    }

    public static class PagerAdapter
    extends FragmentPagerAdapter {
        private final Context mContext;
        private final ArrayList<TabInfo> mTabs = new ArrayList();

        public PagerAdapter(FragmentActivity activity) {
            super(activity.getSupportFragmentManager());
            this.mContext = activity;
        }

        public int getCount() {
            return this.mTabs.size();
        }

        public Fragment getItem(int position) {
            TabInfo info = this.mTabs.get(position);
            return Fragment.instantiate((Context)this.mContext, (String)info.mClss.getName(), (Bundle)info.mArgs);
        }

        public void addTab(Class<?> clss, Bundle args) {
            TabInfo info = new TabInfo(clss, args);
            this.mTabs.add(info);
            this.notifyDataSetChanged();
        }

        static final class TabInfo {
            private final Class<?> mClss;
            private final Bundle mArgs;

            TabInfo(Class<?> aClass, Bundle args) {
                this.mClss = aClass;
                this.mArgs = args;
            }
        }
    }
}

