/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.List;
import net.simonvt.menudrawer.samples.Category;
import net.simonvt.menudrawer.samples.Item;

public class MenuAdapter
extends BaseAdapter {
    private Context mContext;
    private List<Object> mItems;
    private MenuListener mListener;
    private int mActivePosition = -1;

    public MenuAdapter(Context context, List<Object> items) {
        this.mContext = context;
        this.mItems = items;
    }

    public void setListener(MenuListener listener) {
        this.mListener = listener;
    }

    public void setActivePosition(int activePosition) {
        this.mActivePosition = activePosition;
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return this.getItem(position) instanceof Item ? 0 : 1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public boolean isEnabled(int position) {
        return this.getItem(position) instanceof Item;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        Object item = this.getItem(position);
        if (item instanceof Category) {
            if (v == null) {
                v = LayoutInflater.from((Context)this.mContext).inflate(2130903074, parent, false);
            }
            ((TextView)v).setText((CharSequence)((Category)item).mTitle);
        } else {
            if (v == null) {
                v = LayoutInflater.from((Context)this.mContext).inflate(2130903075, parent, false);
            }
            TextView tv = (TextView)v;
            tv.setText((CharSequence)((Item)item).mTitle);
            tv.setCompoundDrawablesWithIntrinsicBounds(((Item)item).mIconRes, 0, 0, 0);
        }
        v.setTag(2130968601, (Object)position);
        if (position == this.mActivePosition) {
            this.mListener.onActiveViewChanged(v);
        }
        return v;
    }

    public static interface MenuListener {
        public void onActiveViewChanged(View var1);
    }
}

