/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.compat;

import android.app.ActionBar;
import android.app.Activity;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.reflect.Method;

final class ActionBarHelperNative {
    private static final String TAG = "ActionBarHelperNative";
    private static final int[] THEME_ATTRS = new int[]{16843531};

    private ActionBarHelperNative() {
    }

    public static void setActionBarUpIndicator(Object info, Activity activity, Drawable drawable2, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.setHomeAsUpIndicator != null) {
            try {
                ActionBar actionBar = activity.getActionBar();
                sii.setHomeAsUpIndicator.invoke((Object)actionBar, drawable2);
                sii.setHomeActionContentDescription.invoke((Object)actionBar, contentDescRes);
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Couldn't set home-as-up indicator via JB-MR2 API", (Throwable)t);
            }
        } else if (sii.upIndicatorView != null) {
            sii.upIndicatorView.setImageDrawable(drawable2);
        } else {
            Log.e((String)TAG, (String)"Couldn't set home-as-up indicator");
        }
    }

    public static void setActionBarDescription(Object info, Activity activity, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.setHomeAsUpIndicator != null) {
            try {
                ActionBar actionBar = activity.getActionBar();
                sii.setHomeActionContentDescription.invoke((Object)actionBar, contentDescRes);
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Couldn't set content description via JB-MR2 API", (Throwable)t);
            }
        }
    }

    public static Drawable getThemeUpIndicator(Object info, Activity activity) {
        TypedArray a = activity.obtainStyledAttributes(THEME_ATTRS);
        Drawable result = a.getDrawable(0);
        a.recycle();
        return result;
    }

    public static Object getIndicatorInfo(Activity activity) {
        return new SetIndicatorInfo(activity);
    }

    public static void setDisplayHomeAsUpEnabled(Activity activity, boolean b) {
        ActionBar actionBar = activity.getActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(b);
        }
    }

    private static class SetIndicatorInfo {
        public Method setHomeAsUpIndicator;
        public Method setHomeActionContentDescription;
        public ImageView upIndicatorView;

        SetIndicatorInfo(Activity activity) {
            try {
                this.setHomeAsUpIndicator = ActionBar.class.getDeclaredMethod("setHomeAsUpIndicator", Drawable.class);
                this.setHomeActionContentDescription = ActionBar.class.getDeclaredMethod("setHomeActionContentDescription", Integer.TYPE);
                return;
            }
            catch (Throwable t) {
                View up;
                View home = activity.findViewById(16908332);
                if (home == null) {
                    return;
                }
                ViewGroup parent = (ViewGroup)home.getParent();
                int childCount = parent.getChildCount();
                if (childCount != 2) {
                    return;
                }
                View first = parent.getChildAt(0);
                View second = parent.getChildAt(1);
                View view = up = first.getId() == 16908332 ? second : first;
                if (up instanceof ImageView) {
                    this.upIndicatorView = (ImageView)up;
                }
                return;
            }
        }
    }
}

