/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.samples.Category;
import net.simonvt.menudrawer.samples.Item;
import net.simonvt.menudrawer.samples.MenuAdapter;

public abstract class BaseListSample
extends FragmentActivity
implements MenuAdapter.MenuListener {
    private static final String STATE_ACTIVE_POSITION = "net.simonvt.menudrawer.samples.LeftDrawerSample.activePosition";
    protected MenuDrawer mMenuDrawer;
    protected MenuAdapter mAdapter;
    protected ListView mList;
    private int mActivePosition = 0;
    private AdapterView.OnItemClickListener mItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            BaseListSample.this.mActivePosition = position;
            BaseListSample.this.mMenuDrawer.setActiveView(view, position);
            BaseListSample.this.mAdapter.setActivePosition(position);
            BaseListSample.this.onMenuItemClicked(position, (Item)BaseListSample.this.mAdapter.getItem(position));
        }
    };

    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mActivePosition = inState.getInt(STATE_ACTIVE_POSITION);
        }
        this.mMenuDrawer = MenuDrawer.attach((Activity)this, MenuDrawer.Type.BEHIND, this.getDrawerPosition(), this.getDragMode());
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new Item("Item 1", 2130837616));
        items.add(new Item("Item 2", 2130837617));
        items.add(new Category("Cat 1"));
        items.add(new Item("Item 3", 2130837616));
        items.add(new Item("Item 4", 2130837617));
        items.add(new Category("Cat 2"));
        items.add(new Item("Item 5", 2130837616));
        items.add(new Item("Item 6", 2130837617));
        items.add(new Category("Cat 3"));
        items.add(new Item("Item 7", 2130837616));
        items.add(new Item("Item 8", 2130837617));
        items.add(new Category("Cat 4"));
        items.add(new Item("Item 9", 2130837616));
        items.add(new Item("Item 10", 2130837617));
        this.mList = new ListView((Context)this);
        this.mAdapter = new MenuAdapter((Context)this, items);
        this.mAdapter.setListener(this);
        this.mAdapter.setActivePosition(this.mActivePosition);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mList.setOnItemClickListener(this.mItemClickListener);
        this.mMenuDrawer.setMenuView((View)this.mList);
    }

    protected abstract void onMenuItemClicked(int var1, Item var2);

    protected abstract int getDragMode();

    protected abstract Position getDrawerPosition();

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_ACTIVE_POSITION, this.mActivePosition);
    }

    @Override
    public void onActiveViewChanged(View v) {
        this.mMenuDrawer.setActiveView(v, this.mActivePosition);
    }
}

