/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.compat;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.reflect.Method;

final class ActionBarHelperSherlock {
    private static final String TAG = "ActionBarHelperSherlock";

    private ActionBarHelperSherlock() {
    }

    public static void setActionBarUpIndicator(Object info, Activity activity, Drawable drawable2, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            sii.mUpIndicatorView.setImageDrawable(drawable2);
            String contentDescription = contentDescRes == 0 ? null : activity.getString(contentDescRes);
            sii.mUpIndicatorView.setContentDescription((CharSequence)contentDescription);
        }
    }

    public static void setActionBarDescription(Object info, Activity activity, int contentDescRes) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            String contentDescription = contentDescRes == 0 ? null : activity.getString(contentDescRes);
            sii.mUpIndicatorView.setContentDescription((CharSequence)contentDescription);
        }
    }

    public static Drawable getThemeUpIndicator(Object info) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mUpIndicatorView != null) {
            return sii.mUpIndicatorView.getDrawable();
        }
        return null;
    }

    public static Object getIndicatorInfo(Activity activity) {
        return new SetIndicatorInfo(activity);
    }

    public static void setDisplayHomeAsUpEnabled(Object info, boolean enabled) {
        SetIndicatorInfo sii = (SetIndicatorInfo)info;
        if (sii.mHomeAsUpEnabled != null) {
            try {
                sii.mHomeAsUpEnabled.invoke(sii.mActionBar, enabled);
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Unable to call setHomeAsUpEnabled", (Throwable)t);
            }
        }
    }

    private static class SetIndicatorInfo {
        public ImageView mUpIndicatorView;
        public Object mActionBar;
        public Method mHomeAsUpEnabled;

        SetIndicatorInfo(Activity activity) {
            try {
                String appPackage = activity.getPackageName();
                int homeId = activity.getResources().getIdentifier("abs__home", "id", appPackage);
                View v = activity.findViewById(homeId);
                ViewGroup parent = (ViewGroup)v.getParent();
                int upId = activity.getResources().getIdentifier("abs__up", "id", appPackage);
                this.mUpIndicatorView = (ImageView)parent.findViewById(upId);
                Class<?> sherlockActivity = activity.getClass();
                Method getActionBar = sherlockActivity.getMethod("getSupportActionBar", new Class[0]);
                this.mActionBar = getActionBar.invoke((Object)activity, null);
                Class<?> supportActionBar = this.mActionBar.getClass();
                this.mHomeAsUpEnabled = supportActionBar.getMethod("setDisplayHomeAsUpEnabled", Boolean.TYPE);
            }
            catch (Throwable t) {
                Log.e((String)ActionBarHelperSherlock.TAG, (String)"Unable to init SetIndicatorInfo for ABS", (Throwable)t);
            }
        }
    }
}

