/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import net.simonvt.menudrawer.DraggableDrawer;
import net.simonvt.menudrawer.ViewHelper;

public class OverlayDrawer
extends DraggableDrawer {
    private static final String TAG = "OverlayDrawer";
    private int mPeekSize;
    private Runnable mRevealRunnable = new Runnable(){

        @Override
        public void run() {
            int animateTo = 0;
            switch (OverlayDrawer.this.mPosition) {
                case RIGHT: 
                case BOTTOM: {
                    animateTo = -OverlayDrawer.this.mPeekSize;
                    break;
                }
                default: {
                    animateTo = OverlayDrawer.this.mPeekSize;
                }
            }
            OverlayDrawer.this.animateOffsetTo(animateTo, 250);
        }
    };

    OverlayDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public OverlayDrawer(Context context) {
        super(context);
    }

    public OverlayDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public OverlayDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        super.addView((View)this.mContentContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        if (USE_TRANSLATIONS) {
            this.mContentContainer.setLayerType(0, null);
        }
        this.mContentContainer.setHardwareLayersEnabled(false);
        super.addView((View)this.mMenuContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        this.mPeekSize = this.dpToPx(20);
    }

    @Override
    protected void drawOverlay(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int offsetPixels = (int)this.mOffsetPixels;
        float openRatio = Math.abs(this.mOffsetPixels) / (float)this.mMenuSize;
        switch (this.mPosition) {
            case LEFT: {
                this.mMenuOverlay.setBounds(offsetPixels, 0, width, height);
                break;
            }
            case RIGHT: {
                this.mMenuOverlay.setBounds(0, 0, width + offsetPixels, height);
                break;
            }
            case TOP: {
                this.mMenuOverlay.setBounds(0, offsetPixels, width, height);
                break;
            }
            case BOTTOM: {
                this.mMenuOverlay.setBounds(0, 0, width, height + offsetPixels);
            }
        }
        this.mMenuOverlay.setAlpha((int)(185.0f * openRatio));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    public void openMenu(boolean animate) {
        int animateTo = 0;
        switch (this.mPosition) {
            case LEFT: 
            case TOP: {
                animateTo = this.mMenuSize;
                break;
            }
            case RIGHT: 
            case BOTTOM: {
                animateTo = -this.mMenuSize;
            }
        }
        this.animateOffsetTo(animateTo, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            switch (this.mPosition) {
                case LEFT: {
                    this.mMenuContainer.setTranslationX(offsetPixels - this.mMenuSize);
                    break;
                }
                case TOP: {
                    this.mMenuContainer.setTranslationY(offsetPixels - this.mMenuSize);
                    break;
                }
                case RIGHT: {
                    this.mMenuContainer.setTranslationX(offsetPixels + this.mMenuSize);
                    break;
                }
                case BOTTOM: {
                    this.mMenuContainer.setTranslationY(offsetPixels + this.mMenuSize);
                }
            }
        } else {
            switch (this.mPosition) {
                case TOP: {
                    this.mMenuContainer.offsetTopAndBottom(offsetPixels - this.mMenuContainer.getBottom());
                    break;
                }
                case BOTTOM: {
                    this.mMenuContainer.offsetTopAndBottom(offsetPixels - (this.mMenuContainer.getTop() - this.getHeight()));
                    break;
                }
                case LEFT: {
                    this.mMenuContainer.offsetLeftAndRight(offsetPixels - this.mMenuContainer.getRight());
                    break;
                }
                case RIGHT: {
                    this.mMenuContainer.offsetLeftAndRight(offsetPixels - (this.mMenuContainer.getLeft() - this.getWidth()));
                }
            }
        }
        this.invalidate();
    }

    @Override
    protected void initPeekScroller() {
        switch (this.mPosition) {
            case RIGHT: 
            case BOTTOM: {
                int dx = -this.mPeekSize;
                this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
                break;
            }
            default: {
                int dx = this.mPeekSize;
                this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
                break;
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onOffsetPixelsChanged((int)this.mOffsetPixels);
    }

    @Override
    protected GradientDrawable.Orientation getDropShadowOrientation() {
        switch (this.mPosition) {
            case TOP: {
                return GradientDrawable.Orientation.TOP_BOTTOM;
            }
            case RIGHT: {
                return GradientDrawable.Orientation.RIGHT_LEFT;
            }
            case BOTTOM: {
                return GradientDrawable.Orientation.BOTTOM_TOP;
            }
        }
        return GradientDrawable.Orientation.LEFT_RIGHT;
    }

    @Override
    protected void updateDropShadowRect() {
        float openRatio = Math.abs(this.mOffsetPixels) / (float)this.mMenuSize;
        int dropShadowSize = (int)((float)this.mDropShadowSize * openRatio);
        switch (this.mPosition) {
            case LEFT: {
                this.mDropShadowRect.top = 0;
                this.mDropShadowRect.bottom = this.getHeight();
                this.mDropShadowRect.left = ViewHelper.getRight((View)this.mMenuContainer);
                this.mDropShadowRect.right = this.mDropShadowRect.left + dropShadowSize;
                break;
            }
            case TOP: {
                this.mDropShadowRect.left = 0;
                this.mDropShadowRect.right = this.getWidth();
                this.mDropShadowRect.top = ViewHelper.getBottom((View)this.mMenuContainer);
                this.mDropShadowRect.bottom = this.mDropShadowRect.top + dropShadowSize;
                break;
            }
            case RIGHT: {
                this.mDropShadowRect.top = 0;
                this.mDropShadowRect.bottom = this.getHeight();
                this.mDropShadowRect.right = ViewHelper.getLeft((View)this.mMenuContainer);
                this.mDropShadowRect.left = this.mDropShadowRect.right - dropShadowSize;
                break;
            }
            case BOTTOM: {
                this.mDropShadowRect.left = 0;
                this.mDropShadowRect.right = this.getWidth();
                this.mDropShadowRect.bottom = ViewHelper.getTop((View)this.mMenuContainer);
                this.mDropShadowRect.top = this.mDropShadowRect.bottom - dropShadowSize;
            }
        }
    }

    @Override
    protected void startLayerTranslation() {
        if (USE_TRANSLATIONS && this.mHardwareLayersEnabled && !this.mLayerTypeHardware) {
            this.mLayerTypeHardware = true;
            this.mMenuContainer.setLayerType(2, null);
        }
    }

    @Override
    protected void stopLayerTranslation() {
        if (this.mLayerTypeHardware) {
            this.mLayerTypeHardware = false;
            this.mMenuContainer.setLayerType(0, null);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        this.mContentContainer.layout(0, 0, width, height);
        if (USE_TRANSLATIONS) {
            switch (this.mPosition) {
                case LEFT: {
                    this.mMenuContainer.layout(0, 0, this.mMenuSize, height);
                    break;
                }
                case RIGHT: {
                    this.mMenuContainer.layout(width - this.mMenuSize, 0, width, height);
                    break;
                }
                case TOP: {
                    this.mMenuContainer.layout(0, 0, width, this.mMenuSize);
                    break;
                }
                case BOTTOM: {
                    this.mMenuContainer.layout(0, height - this.mMenuSize, width, height);
                }
            }
        } else {
            int offsetPixels = (int)this.mOffsetPixels;
            int menuSize = this.mMenuSize;
            switch (this.mPosition) {
                case LEFT: {
                    this.mMenuContainer.layout(-menuSize + offsetPixels, 0, offsetPixels, height);
                    break;
                }
                case RIGHT: {
                    this.mMenuContainer.layout(width + offsetPixels, 0, width + menuSize + offsetPixels, height);
                    break;
                }
                case TOP: {
                    this.mMenuContainer.layout(0, -menuSize + offsetPixels, width, offsetPixels);
                    break;
                }
                case BOTTOM: {
                    this.mMenuContainer.layout(0, height + offsetPixels, width, height + menuSize + offsetPixels);
                }
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int menuHeightMeasureSpec;
        int menuWidthMeasureSpec;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mOffsetPixels == -1.0f) {
            this.openMenu(false);
        }
        switch (this.mPosition) {
            case BOTTOM: 
            case TOP: {
                menuWidthMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
                menuHeightMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)this.mMenuSize);
                break;
            }
            default: {
                menuWidthMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)this.mMenuSize);
                menuHeightMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
            }
        }
        this.mMenuContainer.measure(menuWidthMeasureSpec, menuHeightMeasureSpec);
        int contentWidthMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int contentHeightMeasureSpec = OverlayDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
        this.mContentContainer.measure(contentWidthMeasureSpec, contentHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.updateTouchAreaSize();
    }

    private boolean isContentTouch(int x, int y) {
        boolean contentTouch = false;
        switch (this.mPosition) {
            case LEFT: {
                contentTouch = ViewHelper.getRight((View)this.mMenuContainer) < x;
                break;
            }
            case RIGHT: {
                contentTouch = ViewHelper.getLeft((View)this.mMenuContainer) > x;
                break;
            }
            case TOP: {
                contentTouch = ViewHelper.getBottom((View)this.mMenuContainer) < y;
                break;
            }
            case BOTTOM: {
                contentTouch = ViewHelper.getTop((View)this.mMenuContainer) > y;
            }
        }
        return contentTouch;
    }

    protected boolean onDownAllowDrag(int x, int y) {
        switch (this.mPosition) {
            case LEFT: {
                return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionX <= this.mOffsetPixels;
            }
            case RIGHT: {
                int width = this.getWidth();
                int initialMotionX = (int)this.mInitialMotionX;
                return !this.mMenuVisible && initialMotionX >= width - this.mTouchSize || this.mMenuVisible && (float)initialMotionX >= (float)width + this.mOffsetPixels;
            }
            case TOP: {
                return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionY <= this.mOffsetPixels;
            }
            case BOTTOM: {
                int height = this.getHeight();
                return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) || this.mMenuVisible && this.mInitialMotionY >= (float)height + this.mOffsetPixels;
            }
        }
        return false;
    }

    protected boolean onMoveAllowDrag(int x, int y, float dx, float dy) {
        if (this.mMenuVisible && this.mTouchMode == 2) {
            return true;
        }
        switch (this.mPosition) {
            case LEFT: {
                return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize && dx > 0.0f || this.mMenuVisible && (float)x <= this.mOffsetPixels || Math.abs(this.mOffsetPixels) <= (float)this.mPeekSize && this.mMenuVisible;
            }
            case RIGHT: {
                int width = this.getWidth();
                return !this.mMenuVisible && this.mInitialMotionX >= (float)(width - this.mTouchSize) && dx < 0.0f || this.mMenuVisible && (float)x >= (float)width - this.mOffsetPixels || Math.abs(this.mOffsetPixels) <= (float)this.mPeekSize && this.mMenuVisible;
            }
            case TOP: {
                return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize && dy > 0.0f || this.mMenuVisible && (float)x <= this.mOffsetPixels || Math.abs(this.mOffsetPixels) <= (float)this.mPeekSize && this.mMenuVisible;
            }
            case BOTTOM: {
                int height = this.getHeight();
                return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) && dy < 0.0f || this.mMenuVisible && (float)x >= (float)height - this.mOffsetPixels || Math.abs(this.mOffsetPixels) <= (float)this.mPeekSize && this.mMenuVisible;
            }
        }
        return false;
    }

    protected void onMoveEvent(float dx, float dy) {
        switch (this.mPosition) {
            case LEFT: {
                this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dx, 0.0f), (float)this.mMenuSize));
                break;
            }
            case RIGHT: {
                this.setOffsetPixels(Math.max(Math.min(this.mOffsetPixels + dx, 0.0f), (float)(-this.mMenuSize)));
                break;
            }
            case TOP: {
                this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dy, 0.0f), (float)this.mMenuSize));
                break;
            }
            case BOTTOM: {
                this.setOffsetPixels(Math.max(Math.min(this.mOffsetPixels + dy, 0.0f), (float)(-this.mMenuSize)));
            }
        }
    }

    protected void onUpEvent(int x, int y) {
        int offsetPixels = (int)this.mOffsetPixels;
        switch (this.mPosition) {
            case LEFT: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getXVelocity(this.mVelocityTracker);
                    this.mLastMotionX = x;
                    this.animateOffsetTo(initialVelocity > 0 ? this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible) break;
                this.closeMenu();
                break;
            }
            case TOP: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getYVelocity(this.mVelocityTracker);
                    this.mLastMotionY = y;
                    this.animateOffsetTo(initialVelocity > 0 ? this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible) break;
                this.closeMenu();
                break;
            }
            case RIGHT: {
                int width = this.getWidth();
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getXVelocity(this.mVelocityTracker);
                    this.mLastMotionX = x;
                    this.animateOffsetTo(initialVelocity > 0 ? 0 : -this.mMenuSize, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible) break;
                this.closeMenu();
                break;
            }
            case BOTTOM: {
                if (this.mIsDragging) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
                    int initialVelocity = (int)this.getYVelocity(this.mVelocityTracker);
                    this.mLastMotionY = y;
                    this.animateOffsetTo(initialVelocity < 0 ? -this.mMenuSize : 0, initialVelocity, true);
                    break;
                }
                if (!this.mMenuVisible) break;
                this.closeMenu();
            }
        }
    }

    protected boolean checkTouchSlop(float dx, float dy) {
        switch (this.mPosition) {
            case BOTTOM: 
            case TOP: {
                return Math.abs(dy) > (float)this.mTouchSlop && Math.abs(dy) > Math.abs(dx);
            }
        }
        return Math.abs(dx) > (float)this.mTouchSlop && Math.abs(dx) > Math.abs(dy);
    }

    @Override
    protected void stopAnimation() {
        super.stopAnimation();
        this.removeCallbacks(this.mRevealRunnable);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 1 || action == 3) {
            this.mActivePointerId = -1;
            this.mIsDragging = false;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            if (Math.abs(this.mOffsetPixels) > (float)(this.mMenuSize / 2)) {
                this.openMenu();
            } else {
                this.closeMenu();
            }
            return false;
        }
        if (action == 0 && this.mMenuVisible && this.isCloseEnough()) {
            this.setOffsetPixels(0.0f);
            this.stopAnimation();
            this.endPeek();
            this.setDrawerState(0);
            this.mIsDragging = false;
        }
        if (this.mMenuVisible) {
            int y;
            int x;
            int index = 0;
            if (this.mActivePointerId != -1) {
                index = ev.findPointerIndex(this.mActivePointerId);
                int n = index = index == -1 ? 0 : index;
            }
            if (this.isContentTouch(x = (int)ev.getX(index), y = (int)ev.getY(index))) {
                return true;
            }
        }
        if (!this.mMenuVisible && !this.mIsDragging && this.mTouchMode == 0) {
            return false;
        }
        if (action != 0 && this.mIsDragging) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag((int)this.mLastMotionX, (int)this.mLastMotionY);
                this.mActivePointerId = ev.getPointerId(0);
                if (!allowDrag) break;
                this.setDrawerState(this.mMenuVisible ? 8 : 0);
                this.stopAnimation();
                this.endPeek();
                if (!this.mMenuVisible) {
                    this.postDelayed(this.mRevealRunnable, 160L);
                }
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float y;
                float dy;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    this.mIsDragging = false;
                    this.mActivePointerId = -1;
                    this.endDrag();
                    this.closeMenu(true);
                    return false;
                }
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastMotionX;
                if (!this.checkTouchSlop(dx, dy = (y = ev.getY(pointerIndex)) - this.mLastMotionY)) break;
                if (this.mOnInterceptMoveEventListener != null && (this.mTouchMode == 2 || this.mMenuVisible) && this.canChildrenScroll((int)dx, (int)dy, (int)x, (int)y)) {
                    this.endDrag();
                    this.requestDisallowInterceptTouchEvent(true);
                    return false;
                }
                boolean allowDrag = this.onMoveAllowDrag((int)x, (int)y, dx, dy);
                if (!allowDrag) break;
                this.endPeek();
                this.stopAnimation();
                this.setDrawerState(2);
                this.mIsDragging = true;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                break;
            }
            case 6: {
                this.onPointerUp(ev);
                this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
                this.mLastMotionY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mMenuVisible && !this.mIsDragging && this.mTouchMode == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag((int)this.mLastMotionX, (int)this.mLastMotionY);
                this.mActivePointerId = ev.getPointerId(0);
                if (!allowDrag) break;
                this.stopAnimation();
                this.endPeek();
                if (!this.mMenuVisible) {
                    this.peekDrawer(160L, 0L);
                }
                this.startLayerTranslation();
                break;
            }
            case 2: {
                float y;
                float dy;
                float x;
                float dx;
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    this.mIsDragging = false;
                    this.mActivePointerId = -1;
                    this.endDrag();
                    this.closeMenu(true);
                    return false;
                }
                if (!this.mIsDragging && this.checkTouchSlop(dx = (x = ev.getX(pointerIndex)) - this.mLastMotionX, dy = (y = ev.getY(pointerIndex)) - this.mLastMotionY)) {
                    boolean allowDrag = this.onMoveAllowDrag((int)x, (int)y, dx, dy);
                    if (allowDrag) {
                        this.endPeek();
                        this.stopAnimation();
                        this.setDrawerState(2);
                        this.mIsDragging = true;
                        this.mLastMotionX = x;
                        this.mLastMotionY = y;
                    } else {
                        this.mInitialMotionX = x;
                        this.mInitialMotionY = y;
                    }
                }
                if (!this.mIsDragging) break;
                this.startLayerTranslation();
                x = ev.getX(pointerIndex);
                dx = x - this.mLastMotionX;
                y = ev.getY(pointerIndex);
                dy = y - this.mLastMotionY;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.onMoveEvent(dx, dy);
                break;
            }
            case 1: 
            case 3: {
                int index = ev.findPointerIndex(this.mActivePointerId);
                index = index == -1 ? 0 : index;
                int x = (int)ev.getX(index);
                int y = (int)ev.getY(index);
                this.onUpEvent(x, y);
                this.mActivePointerId = -1;
                this.mIsDragging = false;
                break;
            }
            case 5: {
                int index = (ev.getAction() & 0xFF00) >> 8;
                this.mLastMotionX = ev.getX(index);
                this.mLastMotionY = ev.getY(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onPointerUp(ev);
                this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
                this.mLastMotionY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        return true;
    }

    private void onPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }
}

