/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.samples.Category;
import net.simonvt.menudrawer.samples.Item;
import net.simonvt.menudrawer.samples.MenuAdapter;

public class StaticDrawerSample
extends Activity
implements MenuAdapter.MenuListener {
    private static final String STATE_ACTIVE_POSITION = "net.simonvt.menudrawer.samples.LeftDrawerSample.activePosition";
    private static final String STATE_CONTENT_TEXT = "net.simonvt.menudrawer.samples.LeftDrawerSample.contentText";
    private MenuDrawer mMenuDrawer;
    private MenuAdapter mAdapter;
    private ListView mList;
    private int mActivePosition = -1;
    private String mContentText;
    private TextView mContentTextView;
    private AdapterView.OnItemClickListener mItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            StaticDrawerSample.this.mActivePosition = position;
            StaticDrawerSample.this.mMenuDrawer.setActiveView(view, position);
            StaticDrawerSample.this.mContentTextView.setText(((TextView)view).getText());
        }
    };

    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mActivePosition = inState.getInt(STATE_ACTIVE_POSITION);
            this.mContentText = inState.getString(STATE_CONTENT_TEXT);
        }
        this.mMenuDrawer = MenuDrawer.attach(this, MenuDrawer.Type.STATIC, Position.LEFT, 0);
        this.mMenuDrawer.setContentView(2130903062);
        this.mMenuDrawer.setAllowIndicatorAnimation(true);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new Item("Item 1", 2130837616));
        items.add(new Item("Item 2", 2130837617));
        items.add(new Category("Cat 1"));
        items.add(new Item("Item 3", 2130837616));
        items.add(new Item("Item 4", 2130837617));
        items.add(new Category("Cat 2"));
        items.add(new Item("Item 5", 2130837616));
        items.add(new Item("Item 6", 2130837617));
        this.mList = new ListView((Context)this);
        this.mAdapter = new MenuAdapter((Context)this, items);
        this.mAdapter.setListener(this);
        this.mAdapter.setActivePosition(this.mActivePosition);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mList.setOnItemClickListener(this.mItemClickListener);
        this.mMenuDrawer.setMenuView((View)this.mList);
        this.mContentTextView = (TextView)this.findViewById(2130968638);
        this.mContentTextView.setText((CharSequence)this.mContentText);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_ACTIVE_POSITION, this.mActivePosition);
        outState.putString(STATE_CONTENT_TEXT, this.mContentText);
    }

    @Override
    public void onActiveViewChanged(View v) {
        this.mMenuDrawer.setActiveView(v, this.mActivePosition);
    }
}

