/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.samples.BaseListSample;
import net.simonvt.menudrawer.samples.Item;

public class FragmentSample
extends BaseListSample {
    private static final String STATE_CURRENT_FRAGMENT = "net.simonvt.menudrawer.samples.FragmentSample";
    private FragmentManager mFragmentManager;
    private FragmentTransaction mFragmentTransaction;
    private String mCurrentFragmentTag;

    @Override
    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        this.mFragmentManager = this.getSupportFragmentManager();
        if (inState != null) {
            this.mCurrentFragmentTag = inState.getString(STATE_CURRENT_FRAGMENT);
        } else {
            this.mCurrentFragmentTag = ((Item)this.mAdapter.getItem((int)0)).mTitle;
            this.attachFragment(this.mMenuDrawer.getContentContainer().getId(), this.getFragment(this.mCurrentFragmentTag), this.mCurrentFragmentTag);
            this.commitTransactions();
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mMenuDrawer.setOnDrawerStateChangeListener(new MenuDrawer.OnDrawerStateChangeListener(){

            @Override
            public void onDrawerStateChange(int oldState, int newState) {
                if (newState == 0) {
                    FragmentSample.this.commitTransactions();
                }
            }

            @Override
            public void onDrawerSlide(float openRatio, int offsetPixels) {
            }
        });
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_CURRENT_FRAGMENT, this.mCurrentFragmentTag);
    }

    @Override
    protected void onMenuItemClicked(int position, Item item) {
        if (this.mCurrentFragmentTag != null) {
            this.detachFragment(this.getFragment(this.mCurrentFragmentTag));
        }
        this.attachFragment(this.mMenuDrawer.getContentContainer().getId(), this.getFragment(item.mTitle), item.mTitle);
        this.mCurrentFragmentTag = item.mTitle;
        this.mMenuDrawer.closeMenu();
    }

    @Override
    protected int getDragMode() {
        return 1;
    }

    @Override
    protected Position getDrawerPosition() {
        return Position.LEFT;
    }

    protected FragmentTransaction ensureTransaction() {
        if (this.mFragmentTransaction == null) {
            this.mFragmentTransaction = this.mFragmentManager.beginTransaction();
            this.mFragmentTransaction.setTransition(4099);
        }
        return this.mFragmentTransaction;
    }

    private Fragment getFragment(String tag) {
        Fragment f = this.mFragmentManager.findFragmentByTag(tag);
        if (f == null) {
            f = SampleFragment.newInstance(tag);
        }
        return f;
    }

    protected void attachFragment(int layout2, Fragment f, String tag) {
        if (f != null) {
            if (f.isDetached()) {
                this.ensureTransaction();
                this.mFragmentTransaction.attach(f);
            } else if (!f.isAdded()) {
                this.ensureTransaction();
                this.mFragmentTransaction.add(layout2, f, tag);
            }
        }
    }

    protected void detachFragment(Fragment f) {
        if (f != null && !f.isDetached()) {
            this.ensureTransaction();
            this.mFragmentTransaction.detach(f);
        }
    }

    protected void commitTransactions() {
        if (this.mFragmentTransaction != null && !this.mFragmentTransaction.isEmpty()) {
            this.mFragmentTransaction.commit();
            this.mFragmentTransaction = null;
        }
    }

    public static class SampleFragment
    extends Fragment {
        private static final String ARG_TEXT = "net.simonvt.menudrawer.samples.SampleFragment.text";

        public static SampleFragment newInstance(String text) {
            SampleFragment f = new SampleFragment();
            Bundle args = new Bundle();
            args.putString(ARG_TEXT, text);
            f.setArguments(args);
            return f;
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            View v = inflater.inflate(2130903069, container, false);
            ((TextView)v.findViewById(2130968644)).setText((CharSequence)this.getArguments().getString(ARG_TEXT));
            return v;
        }
    }
}

