/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.compat;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Method;
import net.simonvt.menudrawer.compat.ActionBarHelperNative;
import net.simonvt.menudrawer.compat.ActionBarHelperSherlock;

public final class ActionBarHelper {
    private static final String TAG = "ActionBarHelper";
    private Activity mActivity;
    private Object mIndicatorInfo;
    private boolean mUsesSherlock;

    public ActionBarHelper(Activity activity) {
        this.mActivity = activity;
        try {
            Class<?> clazz = activity.getClass();
            Method m = clazz.getMethod("getSupportActionBar", new Class[0]);
            this.mUsesSherlock = true;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Activity " + activity.getClass().getSimpleName() + " does not use ActionBarSherlock"), (Throwable)e);
        }
        this.mIndicatorInfo = this.getIndicatorInfo();
    }

    private Object getIndicatorInfo() {
        if (this.mUsesSherlock && Build.VERSION.SDK_INT < 14) {
            return ActionBarHelperSherlock.getIndicatorInfo(this.mActivity);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return ActionBarHelperNative.getIndicatorInfo(this.mActivity);
        }
        return null;
    }

    public void setActionBarUpIndicator(Drawable drawable2, int contentDesc) {
        if (this.mUsesSherlock && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperSherlock.setActionBarUpIndicator(this.mIndicatorInfo, this.mActivity, drawable2, contentDesc);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setActionBarUpIndicator(this.mIndicatorInfo, this.mActivity, drawable2, contentDesc);
        }
    }

    public void setActionBarDescription(int contentDesc) {
        if (this.mUsesSherlock && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperSherlock.setActionBarDescription(this.mIndicatorInfo, this.mActivity, contentDesc);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setActionBarDescription(this.mIndicatorInfo, this.mActivity, contentDesc);
        }
    }

    public Drawable getThemeUpIndicator() {
        if (this.mUsesSherlock && Build.VERSION.SDK_INT < 14) {
            return ActionBarHelperSherlock.getThemeUpIndicator(this.mIndicatorInfo);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return ActionBarHelperNative.getThemeUpIndicator(this.mIndicatorInfo, this.mActivity);
        }
        return null;
    }

    public void setDisplayShowHomeAsUpEnabled(boolean enabled) {
        if (this.mUsesSherlock && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperSherlock.setDisplayHomeAsUpEnabled(this.mIndicatorInfo, enabled);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setDisplayHomeAsUpEnabled(this.mActivity, enabled);
        }
    }
}

