/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import net.simonvt.menudrawer.MenuDrawer;

public class StaticDrawer
extends MenuDrawer {
    public StaticDrawer(Context context) {
        super(context);
    }

    public StaticDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StaticDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        super.addView((View)this.mMenuContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        super.addView((View)this.mContentContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        this.mIsStatic = true;
    }

    @Override
    protected void drawOverlay(Canvas canvas) {
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        switch (this.mPosition) {
            case LEFT: {
                this.mMenuContainer.layout(0, 0, this.mMenuSize, height);
                this.mContentContainer.layout(this.mMenuSize, 0, width, height);
                break;
            }
            case RIGHT: {
                this.mMenuContainer.layout(width - this.mMenuSize, 0, width, height);
                this.mContentContainer.layout(0, 0, width - this.mMenuSize, height);
                break;
            }
            case TOP: {
                this.mMenuContainer.layout(0, 0, width, this.mMenuSize);
                this.mContentContainer.layout(0, this.mMenuSize, width, height);
                break;
            }
            case BOTTOM: {
                this.mMenuContainer.layout(0, height - this.mMenuSize, width, height);
                this.mContentContainer.layout(0, 0, width, height - this.mMenuSize);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mMenuSizeSet) {
            this.mMenuSize = (int)((float)height * 0.25f);
        }
        switch (this.mPosition) {
            case LEFT: 
            case RIGHT: {
                int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                int menuWidth = this.mMenuSize;
                int menuWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)menuWidth, (int)0x40000000);
                int contentWidth = width - menuWidth;
                int contentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)contentWidth, (int)0x40000000);
                this.mContentContainer.measure(contentWidthMeasureSpec, childHeightMeasureSpec);
                this.mMenuContainer.measure(menuWidthMeasureSpec, childHeightMeasureSpec);
                break;
            }
            case TOP: 
            case BOTTOM: {
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                int menuHeight = this.mMenuSize;
                int menuHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)menuHeight, (int)0x40000000);
                int contentHeight = height - menuHeight;
                int contentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)contentHeight, (int)0x40000000);
                this.mContentContainer.measure(childWidthMeasureSpec, contentHeightMeasureSpec);
                this.mMenuContainer.measure(childWidthMeasureSpec, menuHeightMeasureSpec);
                break;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void toggleMenu(boolean animate) {
    }

    @Override
    public void openMenu(boolean animate) {
    }

    @Override
    public void closeMenu(boolean animate) {
    }

    @Override
    public boolean isMenuVisible() {
        return true;
    }

    @Override
    public void setMenuSize(int size) {
        this.mMenuSize = size;
        this.mMenuSizeSet = true;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setOffsetMenuEnabled(boolean offsetMenu) {
    }

    @Override
    public boolean getOffsetMenuEnabled() {
        return false;
    }

    @Override
    public void peekDrawer() {
    }

    @Override
    public void peekDrawer(long delay) {
    }

    @Override
    public void peekDrawer(long startDelay, long delay) {
    }

    @Override
    public void setHardwareLayerEnabled(boolean enabled) {
    }

    @Override
    public int getTouchMode() {
        return 0;
    }

    @Override
    public void setTouchMode(int mode) {
    }

    @Override
    public void setTouchBezelSize(int size) {
    }

    @Override
    public int getTouchBezelSize() {
        return 0;
    }

    @Override
    public void setSlideDrawable(int drawableRes) {
    }

    @Override
    public void setSlideDrawable(Drawable drawable2) {
    }

    @Override
    public void setupUpIndicator(Activity activity) {
    }

    @Override
    public void setDrawerIndicatorEnabled(boolean enabled) {
    }

    @Override
    public boolean isDrawerIndicatorEnabled() {
        return false;
    }
}

