/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.actionbarsherlock.ActionBarSherlock;
import com.actionbarsherlock.R;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.app.ActionBarImpl;
import com.actionbarsherlock.internal.view.StandaloneActionMode;
import com.actionbarsherlock.internal.view.menu.ActionMenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.widget.ActionBarContainer;
import com.actionbarsherlock.internal.widget.ActionBarContextView;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.actionbarsherlock.internal.widget.IcsProgressBar;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.view.Window;
import java.util.ArrayList;
import java.util.HashMap;

@ActionBarSherlock.Implementation(api=7)
public class ActionBarSherlockCompat
extends ActionBarSherlock
implements MenuBuilder.Callback,
Window.Callback,
MenuPresenter.Callback,
MenuItem.OnMenuItemClickListener {
    protected static final int DEFAULT_FEATURES = 0;
    private static final String PANELS_TAG = "sherlock:Panels";
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet = false;
    private MenuBuilder mMenu;
    protected HashMap<android.view.MenuItem, MenuItemImpl> mNativeItemMap;
    private ViewGroup mDecor;
    private ViewGroup mContentParent;
    private boolean mIsTitleReady = false;
    private boolean mIsDestroyed = false;
    private boolean mClosingActionMenu;
    private boolean mMenuIsPrepared;
    private boolean mMenuRefreshContent;
    private Bundle mMenuFrozenActionViewState;
    private ActionBarImpl aActionBar;
    private ActionBarView wActionBar;
    private int mFeatures = 0;
    private int mUiOptions = 0;
    private IcsProgressBar mCircularProgressBar;
    private IcsProgressBar mHorizontalProgressBar;
    private ActionMode mActionMode;
    private ActionBarContextView mActionModeView;

    public ActionBarSherlockCompat(Activity activity, int flags) {
        super(activity, flags);
    }

    @Override
    public ActionBar getActionBar() {
        Log.d((String)"ActionBarSherlock", (String)"[getActionBar]");
        this.initActionBar();
        return this.aActionBar;
    }

    private void initActionBar() {
        Log.d((String)"ActionBarSherlock", (String)"[initActionBar]");
        if (this.mDecor == null) {
            this.installDecor();
        }
        if (this.aActionBar != null || !this.hasFeature(8) || this.hasFeature(1) || this.mActivity.isChild()) {
            return;
        }
        this.aActionBar = new ActionBarImpl(this.mActivity, this.mFeatures);
        if (!this.mIsDelegate) {
            this.wActionBar.setWindowTitle(this.mActivity.getTitle());
        }
    }

    @Override
    protected Context getThemedContext() {
        return this.aActionBar.getThemedContext();
    }

    @Override
    public void setTitle(CharSequence title) {
        Log.d((String)"ActionBarSherlock", (String)("[setTitle] title: " + title));
        this.dispatchTitleChanged(title, 0);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback) {
        Log.d((String)"ActionBarSherlock", (String)("[startActionMode] callback: " + callback));
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapper wrappedCallback = new ActionModeCallbackWrapper(callback);
        ActionMode mode = null;
        this.initActionBar();
        if (this.aActionBar != null) {
            mode = this.aActionBar.startActionMode(wrappedCallback);
        }
        if (mode != null) {
            this.mActionMode = mode;
        } else {
            ViewStub stub;
            if (this.mActionModeView == null && (stub = (ViewStub)this.mDecor.findViewById(2130968624)) != null) {
                this.mActionModeView = (ActionBarContextView)stub.inflate();
            }
            if (this.mActionModeView != null) {
                this.mActionModeView.killMode();
                mode = new StandaloneActionMode((Context)this.mActivity, this.mActionModeView, wrappedCallback, true);
                if (callback.onCreateActionMode(mode, mode.getMenu())) {
                    mode.invalidate();
                    this.mActionModeView.initForMode(mode);
                    this.mActionModeView.setVisibility(0);
                    this.mActionMode = mode;
                    this.mActionModeView.sendAccessibilityEvent(32);
                } else {
                    this.mActionMode = null;
                }
            }
        }
        if (this.mActionMode != null && this.mActivity instanceof ActionBarSherlock.OnActionModeStartedListener) {
            ((ActionBarSherlock.OnActionModeStartedListener)this.mActivity).onActionModeStarted(this.mActionMode);
        }
        return this.mActionMode;
    }

    @Override
    public void dispatchConfigurationChanged(Configuration newConfig) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchConfigurationChanged] newConfig: " + newConfig));
        if (this.aActionBar != null) {
            this.aActionBar.onConfigurationChanged(newConfig);
        }
    }

    @Override
    public void dispatchPostResume() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchPostResume]");
        if (this.aActionBar != null) {
            this.aActionBar.setShowHideAnimationEnabled(true);
        }
    }

    @Override
    public void dispatchPause() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchPause]");
        if (this.wActionBar != null && this.wActionBar.isOverflowMenuShowing()) {
            this.wActionBar.hideOverflowMenu();
        }
    }

    @Override
    public void dispatchStop() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchStop]");
        if (this.aActionBar != null) {
            this.aActionBar.setShowHideAnimationEnabled(false);
        }
    }

    @Override
    public void dispatchInvalidateOptionsMenu() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchInvalidateOptionsMenu]");
        Bundle savedActionViewStates = null;
        if (this.mMenu != null) {
            savedActionViewStates = new Bundle();
            this.mMenu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                this.mMenuFrozenActionViewState = savedActionViewStates;
            }
            this.mMenu.stopDispatchingItemsChanged();
            this.mMenu.clear();
        }
        this.mMenuRefreshContent = true;
        if (this.wActionBar != null) {
            this.mMenuIsPrepared = false;
            this.preparePanel();
        }
    }

    @Override
    public boolean dispatchOpenOptionsMenu() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchOpenOptionsMenu]");
        if (!this.isReservingOverflow()) {
            return false;
        }
        return this.wActionBar.showOverflowMenu();
    }

    @Override
    public boolean dispatchCloseOptionsMenu() {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchCloseOptionsMenu]");
        if (!this.isReservingOverflow()) {
            return false;
        }
        if (this.wActionBar != null) {
            return this.wActionBar.hideOverflowMenu();
        }
        return false;
    }

    @Override
    public void dispatchPostCreate(Bundle savedInstanceState) {
        Log.d((String)"ActionBarSherlock", (String)"[dispatchOnPostCreate]");
        if (this.mIsDelegate) {
            this.mIsTitleReady = true;
        }
        if (this.mDecor == null) {
            this.initActionBar();
        }
    }

    @Override
    public boolean dispatchCreateOptionsMenu(Menu menu) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchCreateOptionsMenu] android.view.Menu: " + menu));
        Log.d((String)"ActionBarSherlock", (String)"[dispatchCreateOptionsMenu] returning true");
        return true;
    }

    @Override
    public boolean dispatchPrepareOptionsMenu(Menu menu) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchPrepareOptionsMenu] android.view.Menu: " + menu));
        if (this.mActionMode != null) {
            return false;
        }
        this.mMenuIsPrepared = false;
        if (!this.preparePanel()) {
            return false;
        }
        if (this.isReservingOverflow()) {
            return false;
        }
        if (this.mNativeItemMap == null) {
            this.mNativeItemMap = new HashMap();
        } else {
            this.mNativeItemMap.clear();
        }
        if (this.mMenu == null) {
            return false;
        }
        boolean result = this.mMenu.bindNativeOverflow(menu, this, this.mNativeItemMap);
        Log.d((String)"ActionBarSherlock", (String)("[dispatchPrepareOptionsMenu] returning " + result));
        return result;
    }

    @Override
    public boolean dispatchOptionsItemSelected(android.view.MenuItem item) {
        throw new IllegalStateException("Native callback invoked. Create a test case and report!");
    }

    @Override
    public boolean dispatchMenuOpened(int featureId, Menu menu) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchMenuOpened] featureId: " + featureId + ", menu: " + menu));
        if (featureId == 8 || featureId == 0) {
            if (this.aActionBar != null) {
                this.aActionBar.dispatchMenuVisibilityChanged(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispatchPanelClosed(int featureId, Menu menu) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchPanelClosed] featureId: " + featureId + ", menu: " + menu));
        if ((featureId == 8 || featureId == 0) && this.aActionBar != null) {
            this.aActionBar.dispatchMenuVisibilityChanged(false);
        }
    }

    @Override
    public void dispatchTitleChanged(CharSequence title, int color2) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchTitleChanged] title: " + title + ", color: " + color2));
        if ((!this.mIsDelegate || this.mIsTitleReady) && this.wActionBar != null) {
            this.wActionBar.setWindowTitle(title);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Log.d((String)"ActionBarSherlock", (String)("[dispatchKeyEvent] event: " + event));
        int keyCode = event.getKeyCode();
        if (keyCode == 4) {
            int action = event.getAction();
            if (this.mActionMode != null) {
                if (action == 1) {
                    this.mActionMode.finish();
                }
                Log.d((String)"ActionBarSherlock", (String)"[dispatchKeyEvent] returning true");
                return true;
            }
            if (this.wActionBar != null && this.wActionBar.hasExpandedActionView()) {
                if (action == 1) {
                    this.wActionBar.collapseActionView();
                }
                Log.d((String)"ActionBarSherlock", (String)"[dispatchKeyEvent] returning true");
                return true;
            }
        }
        Log.d((String)"ActionBarSherlock", (String)"[dispatchKeyEvent] returning false");
        return false;
    }

    @Override
    public void dispatchDestroy() {
        this.mIsDestroyed = true;
    }

    @Override
    public void dispatchSaveInstanceState(Bundle outState) {
        if (this.mMenu != null) {
            this.mMenuFrozenActionViewState = new Bundle();
            this.mMenu.saveActionViewStates(this.mMenuFrozenActionViewState);
        }
        outState.putParcelable(PANELS_TAG, (Parcelable)this.mMenuFrozenActionViewState);
    }

    @Override
    public void dispatchRestoreInstanceState(Bundle savedInstanceState) {
        this.mMenuFrozenActionViewState = (Bundle)savedInstanceState.getParcelable(PANELS_TAG);
    }

    private boolean preparePanel() {
        if (this.mMenuIsPrepared) {
            return true;
        }
        if (this.mMenu == null || this.mMenuRefreshContent) {
            if (!(this.mMenu != null || this.initializePanelMenu() && this.mMenu != null)) {
                return false;
            }
            if (this.wActionBar != null) {
                this.wActionBar.setMenu(this.mMenu, this);
            }
            this.mMenu.stopDispatchingItemsChanged();
            if (!this.callbackCreateOptionsMenu(this.mMenu)) {
                this.mMenu = null;
                if (this.wActionBar != null) {
                    this.wActionBar.setMenu(null, this);
                }
                return false;
            }
            this.mMenuRefreshContent = false;
        }
        this.mMenu.stopDispatchingItemsChanged();
        if (this.mMenuFrozenActionViewState != null) {
            this.mMenu.restoreActionViewStates(this.mMenuFrozenActionViewState);
            this.mMenuFrozenActionViewState = null;
        }
        if (!this.callbackPrepareOptionsMenu(this.mMenu)) {
            if (this.wActionBar != null) {
                this.wActionBar.setMenu(null, this);
            }
            this.mMenu.startDispatchingItemsChanged();
            return false;
        }
        KeyCharacterMap kmap = KeyCharacterMap.load((int)-1);
        this.mMenu.setQwertyMode(kmap.getKeyboardType() != 1);
        this.mMenu.startDispatchingItemsChanged();
        this.mMenuIsPrepared = true;
        return true;
    }

    @Override
    public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
        return this.callbackOptionsItemSelected(item);
    }

    @Override
    public void onMenuModeChange(MenuBuilder menu) {
        this.reopenMenu(true);
    }

    private void reopenMenu(boolean toggleMenuMode) {
        if (this.wActionBar != null && this.wActionBar.isOverflowReserved()) {
            if (!this.wActionBar.isOverflowMenuShowing() || !toggleMenuMode) {
                if (this.wActionBar.getVisibility() == 0 && this.callbackPrepareOptionsMenu(this.mMenu)) {
                    this.wActionBar.showOverflowMenu();
                }
            } else {
                this.wActionBar.hideOverflowMenu();
            }
            return;
        }
    }

    private boolean initializePanelMenu() {
        Activity context = this.mActivity;
        if (this.wActionBar != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme currentTheme = context.getTheme();
            currentTheme.resolveAttribute(2130771980, outValue, true);
            int targetThemeRes = outValue.resourceId;
            if (targetThemeRes != 0) {
                context = new ContextThemeWrapper((Context)context, targetThemeRes);
            }
        }
        this.mMenu = new MenuBuilder((Context)context);
        this.mMenu.setCallback(this);
        return true;
    }

    void checkCloseActionMenu(com.actionbarsherlock.view.Menu menu) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.wActionBar.dismissPopupMenus();
        this.mClosingActionMenu = false;
    }

    @Override
    public boolean onOpenSubMenu(MenuBuilder subMenu) {
        return true;
    }

    @Override
    public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        this.checkCloseActionMenu(menu);
    }

    public boolean onMenuItemClick(android.view.MenuItem item) {
        Log.d((String)"ActionBarSherlock", (String)("[mNativeItemListener.onMenuItemClick] item: " + item));
        MenuItemImpl sherlockItem = this.mNativeItemMap.get(item);
        if (sherlockItem != null) {
            sherlockItem.invoke();
        } else {
            Log.e((String)"ActionBarSherlock", (String)("Options item \"" + item + "\" not found in mapping"));
        }
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        return this.callbackOptionsItemSelected(item);
    }

    @Override
    public void setProgressBarVisibility(boolean visible) {
        Log.d((String)"ActionBarSherlock", (String)("[setProgressBarVisibility] visible: " + visible));
        this.setFeatureInt(2, visible ? -1 : -2);
    }

    @Override
    public void setProgressBarIndeterminateVisibility(boolean visible) {
        Log.d((String)"ActionBarSherlock", (String)("[setProgressBarIndeterminateVisibility] visible: " + visible));
        this.setFeatureInt(5, visible ? -1 : -2);
    }

    @Override
    public void setProgressBarIndeterminate(boolean indeterminate) {
        Log.d((String)"ActionBarSherlock", (String)("[setProgressBarIndeterminate] indeterminate: " + indeterminate));
        this.setFeatureInt(2, indeterminate ? -3 : -4);
    }

    @Override
    public void setProgress(int progress) {
        Log.d((String)"ActionBarSherlock", (String)("[setProgress] progress: " + progress));
        this.setFeatureInt(2, progress + 0);
    }

    @Override
    public void setSecondaryProgress(int secondaryProgress) {
        Log.d((String)"ActionBarSherlock", (String)("[setSecondaryProgress] secondaryProgress: " + secondaryProgress));
        this.setFeatureInt(2, secondaryProgress + 20000);
    }

    private void setFeatureInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    private void updateInt(int featureId, int value, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        this.onIntChanged(featureId, value);
    }

    private void onIntChanged(int featureId, int value) {
        if (featureId == 2 || featureId == 5) {
            this.updateProgressBars(value);
        }
    }

    private void updateProgressBars(int value) {
        IcsProgressBar circularProgressBar = this.getCircularProgressBar(true);
        IcsProgressBar horizontalProgressBar = this.getHorizontalProgressBar(true);
        int features = this.mFeatures;
        if (value == -1) {
            if ((features & 4) != 0) {
                int level = horizontalProgressBar.getProgress();
                int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                horizontalProgressBar.setVisibility(visibility);
            }
            if ((features & 0x20) != 0) {
                circularProgressBar.setVisibility(0);
            }
        } else if (value == -2) {
            if ((features & 4) != 0) {
                horizontalProgressBar.setVisibility(8);
            }
            if ((features & 0x20) != 0) {
                circularProgressBar.setVisibility(8);
            }
        } else if (value == -3) {
            horizontalProgressBar.setIndeterminate(true);
        } else if (value == -4) {
            horizontalProgressBar.setIndeterminate(false);
        } else if (0 <= value && value <= 10000) {
            horizontalProgressBar.setProgress(value - 0);
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        } else if (20000 <= value && value <= 30000) {
            horizontalProgressBar.setSecondaryProgress(value - 20000);
            this.showProgressBars(horizontalProgressBar, circularProgressBar);
        }
    }

    private void showProgressBars(IcsProgressBar horizontalProgressBar, IcsProgressBar spinnyProgressBar) {
        int features = this.mFeatures;
        if ((features & 0x20) != 0 && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if ((features & 4) != 0 && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private void hideProgressBars(IcsProgressBar horizontalProgressBar, IcsProgressBar spinnyProgressBar) {
        int features = this.mFeatures;
        Animation anim = AnimationUtils.loadAnimation((Context)this.mActivity, (int)0x10A0001);
        anim.setDuration(1000L);
        if ((features & 0x20) != 0 && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.startAnimation(anim);
            spinnyProgressBar.setVisibility(4);
        }
        if ((features & 4) != 0 && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.startAnimation(anim);
            horizontalProgressBar.setVisibility(4);
        }
    }

    private IcsProgressBar getCircularProgressBar(boolean shouldInstallDecor) {
        if (this.mCircularProgressBar != null) {
            return this.mCircularProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mCircularProgressBar = (IcsProgressBar)this.mDecor.findViewById(2130968590);
        if (this.mCircularProgressBar != null) {
            this.mCircularProgressBar.setVisibility(4);
        }
        return this.mCircularProgressBar;
    }

    private IcsProgressBar getHorizontalProgressBar(boolean shouldInstallDecor) {
        if (this.mHorizontalProgressBar != null) {
            return this.mHorizontalProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mHorizontalProgressBar = (IcsProgressBar)this.mDecor.findViewById(2130968591);
        if (this.mHorizontalProgressBar != null) {
            this.mHorizontalProgressBar.setVisibility(4);
        }
        return this.mHorizontalProgressBar;
    }

    private int getFeatures() {
        Log.d((String)"ActionBarSherlock", (String)("[getFeatures] returning " + this.mFeatures));
        return this.mFeatures;
    }

    @Override
    public boolean hasFeature(int featureId) {
        Log.d((String)"ActionBarSherlock", (String)("[hasFeature] featureId: " + featureId));
        boolean result = (this.mFeatures & 1 << featureId) != 0;
        Log.d((String)"ActionBarSherlock", (String)("[hasFeature] returning " + result));
        return result;
    }

    @Override
    public boolean requestFeature(int featureId) {
        Log.d((String)"ActionBarSherlock", (String)("[requestFeature] featureId: " + featureId));
        if (this.mContentParent != null) {
            throw new AndroidRuntimeException("requestFeature() must be called before adding content");
        }
        switch (featureId) {
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.mFeatures |= 1 << featureId;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setUiOptions(int uiOptions) {
        Log.d((String)"ActionBarSherlock", (String)("[setUiOptions] uiOptions: " + uiOptions));
        this.mUiOptions = uiOptions;
    }

    @Override
    public void setUiOptions(int uiOptions, int mask) {
        Log.d((String)"ActionBarSherlock", (String)("[setUiOptions] uiOptions: " + uiOptions + ", mask: " + mask));
        this.mUiOptions = this.mUiOptions & ~mask | uiOptions & mask;
    }

    @Override
    public void setContentView(int layoutResId) {
        Log.d((String)"ActionBarSherlock", (String)("[setContentView] layoutResId: " + layoutResId));
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.mActivity.getLayoutInflater().inflate(layoutResId, this.mContentParent);
        Window.Callback callback = this.mActivity.getWindow().getCallback();
        if (callback != null) {
            callback.onContentChanged();
        }
        this.initActionBar();
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        Log.d((String)"ActionBarSherlock", (String)("[setContentView] view: " + view + ", params: " + params));
        if (this.mContentParent == null) {
            this.installDecor();
        } else {
            this.mContentParent.removeAllViews();
        }
        this.mContentParent.addView(view, params);
        Window.Callback callback = this.mActivity.getWindow().getCallback();
        if (callback != null) {
            callback.onContentChanged();
        }
        this.initActionBar();
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams params) {
        Log.d((String)"ActionBarSherlock", (String)("[addContentView] view: " + view + ", params: " + params));
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mContentParent.addView(view, params);
        this.initActionBar();
    }

    private void installDecor() {
        Log.d((String)"ActionBarSherlock", (String)"[installDecor]");
        if (this.mDecor == null) {
            this.mDecor = (ViewGroup)this.mActivity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (this.mContentParent == null) {
            ArrayList<View> views = null;
            if (this.mDecor.getChildCount() > 0) {
                views = new ArrayList<View>(1);
                int children = this.mDecor.getChildCount();
                for (int i = 0; i < children; ++i) {
                    View child = this.mDecor.getChildAt(0);
                    this.mDecor.removeView(child);
                    views.add(child);
                }
            }
            this.mContentParent = this.generateLayout();
            if (views != null) {
                for (View child : views) {
                    this.mContentParent.addView(child);
                }
            }
            this.wActionBar = (ActionBarView)this.mDecor.findViewById(2130968620);
            if (this.wActionBar != null) {
                int uiOptions;
                this.wActionBar.setWindowCallback(this);
                if (this.wActionBar.getTitle() == null) {
                    this.wActionBar.setWindowTitle(this.mActivity.getTitle());
                }
                if (this.hasFeature(2)) {
                    this.wActionBar.initProgress();
                }
                if (this.hasFeature(5)) {
                    this.wActionBar.initIndeterminateProgress();
                }
                if ((uiOptions = ActionBarSherlockCompat.loadUiOptionsFromManifest(this.mActivity)) != 0) {
                    this.mUiOptions = uiOptions;
                }
                boolean splitActionBar = false;
                boolean splitWhenNarrow = (this.mUiOptions & 1) != 0;
                splitActionBar = splitWhenNarrow ? ResourcesCompat.getResources_getBoolean((Context)this.mActivity, 2131034113) : this.mActivity.getTheme().obtainStyledAttributes(R.styleable.SherlockTheme).getBoolean(62, false);
                ActionBarContainer splitView = (ActionBarContainer)this.mDecor.findViewById(2130968623);
                if (splitView != null) {
                    this.wActionBar.setSplitView(splitView);
                    this.wActionBar.setSplitActionBar(splitActionBar);
                    this.wActionBar.setSplitWhenNarrow(splitWhenNarrow);
                    this.mActionModeView = (ActionBarContextView)this.mDecor.findViewById(2130968621);
                    this.mActionModeView.setSplitView(splitView);
                    this.mActionModeView.setSplitActionBar(splitActionBar);
                    this.mActionModeView.setSplitWhenNarrow(splitWhenNarrow);
                } else if (splitActionBar) {
                    Log.e((String)"ActionBarSherlock", (String)"Requested split action bar with incompatible window decor! Ignoring request.");
                }
                this.mDecor.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!ActionBarSherlockCompat.this.mIsDestroyed && !ActionBarSherlockCompat.this.mActivity.isFinishing() && ActionBarSherlockCompat.this.mMenu == null) {
                            ActionBarSherlockCompat.this.dispatchInvalidateOptionsMenu();
                        }
                    }
                });
            }
        }
    }

    private ViewGroup generateLayout() {
        IcsProgressBar progress;
        Log.d((String)"ActionBarSherlock", (String)"[generateLayout]");
        TypedArray a = this.mActivity.getTheme().obtainStyledAttributes(R.styleable.SherlockTheme);
        if (!a.hasValue(59)) {
            throw new IllegalStateException("You must use Theme.Sherlock, Theme.Sherlock.Light, Theme.Sherlock.Light.DarkActionBar, or a derivative.");
        }
        if (a.getBoolean(58, false)) {
            this.requestFeature(1);
        } else if (a.getBoolean(59, false)) {
            this.requestFeature(8);
        }
        if (a.getBoolean(60, false)) {
            this.requestFeature(9);
        }
        if (a.getBoolean(61, false)) {
            this.requestFeature(10);
        }
        a.recycle();
        int layoutResource = !this.hasFeature(1) ? (this.hasFeature(9) ? 2130903055 : 2130903054) : (this.hasFeature(10) && !this.hasFeature(1) ? 2130903057 : 2130903056);
        Log.d((String)"ActionBarSherlock", (String)("[generateLayout] using screen XML " + this.mActivity.getResources().getString(layoutResource)));
        View in = this.mActivity.getLayoutInflater().inflate(layoutResource, null);
        this.mDecor.addView(in, new ViewGroup.LayoutParams(-1, -1));
        ViewGroup contentParent = (ViewGroup)this.mDecor.findViewById(2130968622);
        if (contentParent == null) {
            throw new RuntimeException("Couldn't find content container view");
        }
        this.mDecor.setId(-1);
        contentParent.setId(0x1020002);
        if (this.hasFeature(5) && (progress = this.getCircularProgressBar(false)) != null) {
            progress.setIndeterminate(true);
        }
        return contentParent;
    }

    private boolean isReservingOverflow() {
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = ActionMenuPresenter.reserveOverflow((Context)this.mActivity);
            this.mReserveOverflowSet = true;
        }
        return this.mReserveOverflow;
    }

    private static int loadUiOptionsFromManifest(Activity activity) {
        int uiOptions = 0;
        try {
            String thisPackage = activity.getClass().getName();
            Log.i((String)"ActionBarSherlock", (String)("Parsing AndroidManifest.xml for " + thisPackage));
            String packageName = activity.getApplicationInfo().packageName;
            AssetManager am = activity.createPackageContext(packageName, 0).getAssets();
            XmlResourceParser xml = am.openXmlResourceParser("AndroidManifest.xml");
            int eventType = xml.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String name = xml.getName();
                    if ("application".equals(name)) {
                        Log.d((String)"ActionBarSherlock", (String)"Got <application>");
                        for (int i = xml.getAttributeCount() - 1; i >= 0; --i) {
                            Log.d((String)"ActionBarSherlock", (String)(xml.getAttributeName(i) + ": " + xml.getAttributeValue(i)));
                            if (!"uiOptions".equals(xml.getAttributeName(i))) continue;
                            uiOptions = xml.getAttributeIntValue(i, 0);
                            break;
                        }
                    } else if ("activity".equals(name)) {
                        Log.d((String)"ActionBarSherlock", (String)"Got <activity>");
                        Integer activityUiOptions = null;
                        String activityPackage = null;
                        boolean isOurActivity = false;
                        for (int i = xml.getAttributeCount() - 1; i >= 0; --i) {
                            Log.d((String)"ActionBarSherlock", (String)(xml.getAttributeName(i) + ": " + xml.getAttributeValue(i)));
                            String attrName = xml.getAttributeName(i);
                            if ("uiOptions".equals(attrName)) {
                                activityUiOptions = xml.getAttributeIntValue(i, 0);
                            } else if ("name".equals(attrName)) {
                                activityPackage = ActionBarSherlockCompat.cleanActivityName(packageName, xml.getAttributeValue(i));
                                if (!thisPackage.equals(activityPackage)) break;
                                isOurActivity = true;
                            }
                            if (activityUiOptions == null || activityPackage == null) continue;
                            uiOptions = activityUiOptions;
                        }
                        if (isOurActivity) break;
                    }
                }
                eventType = xml.nextToken();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)"ActionBarSherlock", (String)("Returning " + Integer.toHexString(uiOptions)));
        return uiOptions;
    }

    public static String cleanActivityName(String manifestPackage, String activityName) {
        if (activityName.charAt(0) == '.') {
            return manifestPackage + activityName;
        }
        if (activityName.indexOf(46, 1) == -1) {
            return manifestPackage + "." + activityName;
        }
        return activityName;
    }

    @Override
    public void ensureActionBar() {
        Log.d((String)"ActionBarSherlock", (String)"[ensureActionBar]");
        if (this.mDecor == null) {
            this.initActionBar();
        }
    }

    private class ActionModeCallbackWrapper
    implements ActionMode.Callback {
        private final ActionMode.Callback mWrapped;

        public ActionModeCallbackWrapper(ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, com.actionbarsherlock.view.Menu menu) {
            return this.mWrapped.onCreateActionMode(mode, menu);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, com.actionbarsherlock.view.Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            if (ActionBarSherlockCompat.this.mActionModeView != null) {
                ActionBarSherlockCompat.this.mActionModeView.setVisibility(8);
                ActionBarSherlockCompat.this.mActionModeView.removeAllViews();
            }
            if (ActionBarSherlockCompat.this.mActivity instanceof ActionBarSherlock.OnActionModeFinishedListener) {
                ((ActionBarSherlock.OnActionModeFinishedListener)ActionBarSherlockCompat.this.mActivity).onActionModeFinished(ActionBarSherlockCompat.this.mActionMode);
            }
            ActionBarSherlockCompat.this.mActionMode = null;
        }
    }
}

