package net.siisise.abnf.jprs;

import net.siisise.abnf.ABNF;
import net.siisise.abnf.ABNFReg;
import net.siisise.abnf.parser5234.ABNF5234;

/**
 * Generic JP Domain Name. 汎用jp ドメインのABNF 2010年8月15日版参照
 * https://jprs.jp/doc/rule/saisoku-1-wideusejp-furoku-5.html
 */
public class GenericJPDN {

    public static final ABNFReg REG = new ABNFReg();

    static final ABNF JA_char = REG.rule("JA-char", ABNF.range(0x3041,0x3093).or1(
            ABNF.range(0x30A1, 0x30F6),ABNF.range(0x30FB,0x30FE),REG.elements( 
            "%x3005 / %x3006 / %x3007 / %x309D / %x309E /"
            + "	%x4E00 / %x4E01 / %x4E03 / %x4E07 / %x4E08 / %x4E09 /"
            + "	%x4E0A / %x4E0B / %x4E0D / %x4E0E / %x4E10 / %x4E11 / %x4E14 / %x4E15 /"
            + "	%x4E16 / %x4E17 / %x4E18 / %x4E19 / %x4E1E / %x4E21 / %x4E26 / %x4E2A /"
            + "	%x4E2D / %x4E31 / %x4E32 / %x4E36 / %x4E38 / %x4E39 / %x4E3B / %x4E3C /"
            + "	%x4E3F / %x4E42 / %x4E43 / %x4E45 / %x4E4B / %x4E4D / %x4E4E / %x4E4F /"
            + "	%x4E55 / %x4E56 / %x4E57 / %x4E58 / %x4E59 / %x4E5D / %x4E5E / %x4E5F /"
            + "	%x4E62 / %x4E71 / %x4E73 / %x4E7E / %x4E80 / %x4E82 / %x4E85 / %x4E86 /"
            + "	%x4E88 / %x4E89 / %x4E8A / %x4E8B / %x4E8C / %x4E8E / %x4E91 / %x4E92 /"
            + "	%x4E94 / %x4E95 / %x4E98 / %x4E99 / %x4E9B / %x4E9C / %x4E9E / %x4E9F /"
            + "	%x4EA0 / %x4EA1 / %x4EA2 / %x4EA4 / %x4EA5 / %x4EA6 / %x4EA8 / %x4EAB /"
            + "	%x4EAC / %x4EAD / %x4EAE / %x4EB0 / %x4EB3 / %x4EB6 / %x4EBA / %x4EC0 /"
            + "	%x4EC1 / %x4EC2 / %x4EC4 / %x4EC6 / %x4EC7 / %x4ECA / %x4ECB / %x4ECD /"
            + "	%x4ECE / %x4ECF / %x4ED4 / %x4ED5 / %x4ED6 / %x4ED7 / %x4ED8 / %x4ED9 /"
            + "	%x4EDD / %x4EDE / %x4EDF / %x4EE3 / %x4EE4 / %x4EE5 / %x4EED / %x4EEE /"
            + "	%x4EF0 / %x4EF2 / %x4EF6 / %x4EF7 / %x4EFB / %x4F01 / %x4F09 / %x4F0A /"
            + "	%x4F0D / %x4F0E / %x4F0F / %x4F10 / %x4F11 / %x4F1A / %x4F1C / %x4F1D /"
            + "	%x4F2F / %x4F30 / %x4F34 / %x4F36 / %x4F38 / %x4F3A / %x4F3C / %x4F3D /"
            + "	%x4F43 / %x4F46 / %x4F47 / %x4F4D / %x4F4E / %x4F4F / %x4F50 / %x4F51 /"
            + "	%x4F53 / %x4F55 / %x4F57 / %x4F59 / %x4F5A / %x4F5B / %x4F5C / %x4F5D /"
            + "	%x4F5E / %x4F69 / %x4F6F / %x4F70 / %x4F73 / %x4F75 / %x4F76 / %x4F7B /"
            + "	%x4F7C / %x4F7F / %x4F83 / %x4F86 / %x4F88 / %x4F8B / %x4F8D / %x4F8F /"
            + "	%x4F91 / %x4F96 / %x4F98 / %x4F9B / %x4F9D / %x4FA0 / %x4FA1 / %x4FAB /"
            + "	%x4FAD / %x4FAE / %x4FAF / %x4FB5 / %x4FB6 / %x4FBF / %x4FC2 / %x4FC3 /"
            + "	%x4FC4 / %x4FCA / %x4FCE / %x4FD0 / %x4FD1 / %x4FD4 / %x4FD7 / %x4FD8 /"
            + "	%x4FDA / %x4FDB / %x4FDD / %x4FDF / %x4FE1 / %x4FE3 / %x4FE4 / %x4FE5 /"
            + "	%x4FEE / %x4FEF / %x4FF3 / %x4FF5 / %x4FF6 / %x4FF8 / %x4FFA / %x4FFE /"
            + "	%x5005 / %x5006 / %x5009 / %x500B / %x500D / %x500F / %x5011 / %x5012 /"
            + "	%x5014 / %x5016 / %x5019 / %x501A / %x501F / %x5021 / %x5023 / %x5024 /"
            + "	%x5025 / %x5026 / %x5028 / %x5029 / %x502A / %x502B / %x502C / %x502D /"
            + "	%x5036 / %x5039 / %x5043 / %x5047 / %x5048 / %x5049 / %x504F / %x5050 /"
            + "	%x5055 / %x5056 / %x505A / %x505C / %x5065 / %x506C / %x5072 / %x5074 /"
            + "	%x5075 / %x5076 / %x5078 / %x507D / %x5080 / %x5085 / %x508D / %x5091 /"
            + "	%x5098 / %x5099 / %x509A / %x50AC / %x50AD / %x50B2 / %x50B3 / %x50B4 /"
            + "	%x50B5 / %x50B7 / %x50BE / %x50C2 / %x50C5 / %x50C9 / %x50CA / %x50CD /"
            + "	%x50CF / %x50D1 / %x50D5 / %x50D6 / %x50DA / %x50DE / %x50E3 / %x50E5 /"
            + "	%x50E7 / %x50ED / %x50EE / %x50F5 / %x50F9 / %x50FB / %x5100 / %x5101 /"
            + "	%x5102 / %x5104 / %x5109 / %x5112 / %x5114 / %x5115 / %x5116 / %x5118 /"
            + "	%x511A / %x511F / %x5121 / %x512A / %x5132 / %x5137 / %x513A / %x513B /"
            + "	%x513C / %x513F / %x5140 / %x5141 / %x5143 / %x5144 / %x5145 / %x5146 /"
            + "	%x5147 / %x5148 / %x5149 / %x514B / %x514C / %x514D / %x514E / %x5150 /"
            + "	%x5152 / %x5154 / %x515A / %x515C / %x5162 / %x5165 / %x5168 / %x5169 /"
            + "	%x516A / %x516B / %x516C / %x516D / %x516E / %x5171 / %x5175 / %x5176 /"
            + "	%x5177 / %x5178 / %x517C / %x5180 / %x5182 / %x5185 / %x5186 / %x5189 /"
            + "	%x518A / %x518C / %x518D / %x518F / %x5190 / %x5191 / %x5192 / %x5193 /"
            + "	%x5195 / %x5196 / %x5197 / %x5199 / %x51A0 / %x51A2 / %x51A4 / %x51A5 /"
            + "	%x51A6 / %x51A8 / %x51A9 / %x51AA / %x51AB / %x51AC / %x51B0 / %x51B1 /"
            + "	%x51B2 / %x51B3 / %x51B4 / %x51B5 / %x51B6 / %x51B7 / %x51BD / %x51C4 /"
            + "	%x51C5 / %x51C6 / %x51C9 / %x51CB / %x51CC / %x51CD / %x51D6 / %x51DB /"
            + "	%x51DC / %x51DD / %x51E0 / %x51E1 / %x51E6 / %x51E7 / %x51E9 / %x51EA /"
            + "	%x51ED / %x51F0 / %x51F1 / %x51F5 / %x51F6 / %x51F8 / %x51F9 / %x51FA /"
            + "	%x51FD / %x51FE / %x5200 / %x5203 / %x5204 / %x5206 / %x5207 / %x5208 /"
            + "	%x520A / %x520B / %x520E / %x5211 / %x5214 / %x5217 / %x521D / %x5224 /"
            + "	%x5225 / %x5227 / %x5229 / %x522A / %x522E / %x5230 / %x5233 / %x5236 /"
            + "	%x5237 / %x5238 / %x5239 / %x523A / %x523B / %x5243 / %x5244 / %x5247 /"
            + "	%x524A / %x524B / %x524C / %x524D / %x524F / %x5254 / %x5256 / %x525B /"
            + "	%x525E / %x5263 / %x5264 / %x5265 / %x5269 / %x526A / %x526F / %x5270 /"
            + "	%x5271 / %x5272 / %x5273 / %x5274 / %x5275 / %x527D / %x527F / %x5283 /"
            + "	%x5287 / %x5288 / %x5289 / %x528D / %x5291 / %x5292 / %x5294 / %x529B /"
            + "	%x529F / %x52A0 / %x52A3 / %x52A9 / %x52AA / %x52AB / %x52AC / %x52AD /"
            + "	%x52B1 / %x52B4 / %x52B5 / %x52B9 / %x52BC / %x52BE / %x52C1 / %x52C3 /"
            + "	%x52C5 / %x52C7 / %x52C9 / %x52CD / %x52D2 / %x52D5 / %x52D7 / %x52D8 /"
            + "	%x52D9 / %x52DD / %x52DE / %x52DF / %x52E0 / %x52E2 / %x52E3 / %x52E4 /"
            + "	%x52E6 / %x52E7 / %x52F2 / %x52F3 / %x52F5 / %x52F8 / %x52F9 / %x52FA /"
            + "	%x52FE / %x52FF / %x5301 / %x5302 / %x5305 / %x5306 / %x5308 / %x530D /"
            + "	%x530F / %x5310 / %x5315 / %x5316 / %x5317 / %x5319 / %x531A / %x531D /"
            + "	%x5320 / %x5321 / %x5323 / %x532A / %x532F / %x5331 / %x5333 / %x5338 /"
            + "	%x5339 / %x533A / %x533B / %x533F / %x5340 / %x5341 / %x5343 / %x5345 /"
            + "	%x5346 / %x5347 / %x5348 / %x5349 / %x534A / %x534D / %x5351 / %x5352 /"
            + "	%x5353 / %x5354 / %x5357 / %x5358 / %x535A / %x535C / %x535E / %x5360 /"
            + "	%x5366 / %x5369 / %x536E / %x536F / %x5370 / %x5371 / %x5373 / %x5374 /"
            + "	%x5375 / %x5377 / %x5378 / %x537B / %x537F / %x5382 / %x5384 / %x5396 /"
            + "	%x5398 / %x539A / %x539F / %x53A0 / %x53A5 / %x53A6 / %x53A8 / %x53A9 /"
            + "	%x53AD / %x53AE / %x53B0 / %x53B3 / %x53B6 / %x53BB / %x53C2 / %x53C3 /"
            + "	%x53C8 / %x53C9 / %x53CA / %x53CB / %x53CC / %x53CD / %x53CE / %x53D4 /"
            + "	%x53D6 / %x53D7 / %x53D9 / %x53DB / %x53DF / %x53E1 / %x53E2 / %x53E3 /"
            + "	%x53E4 / %x53E5 / %x53E8 / %x53E9 / %x53EA / %x53EB / %x53EC / %x53ED /"
            + "	%x53EE / %x53EF / %x53F0 / %x53F1 / %x53F2 / %x53F3 / %x53F6 / %x53F7 /"
            + "	%x53F8 / %x53FA / %x5401 / %x5403 / %x5404 / %x5408 / %x5409 / %x540A /"
            + "	%x540B / %x540C / %x540D / %x540E / %x540F / %x5410 / %x5411 / %x541B /"
            + "	%x541D / %x541F / %x5420 / %x5426 / %x5429 / %x542B / %x542C / %x542D /"
            + "	%x542E / %x5436 / %x5438 / %x5439 / %x543B / %x543C / %x543D / %x543E /"
            + "	%x5440 / %x5442 / %x5446 / %x5448 / %x5449 / %x544A / %x544E / %x5451 /"
            + "	%x545F / %x5468 / %x546A / %x5470 / %x5471 / %x5473 / %x5475 / %x5476 /"
            + "	%x5477 / %x547B / %x547C / %x547D / %x5480 / %x5484 / %x5486 / %x548B /"
            + "	%x548C / %x548E / %x548F / %x5490 / %x5492 / %x54A2 / %x54A4 / %x54A5 /"
            + "	%x54A8 / %x54AB / %x54AC / %x54AF / %x54B2 / %x54B3 / %x54B8 / %x54BC /"
            + "	%x54BD / %x54BE / %x54C0 / %x54C1 / %x54C2 / %x54C4 / %x54C7 / %x54C8 /"
            + "	%x54C9 / %x54D8 / %x54E1 / %x54E2 / %x54E5 / %x54E6 / %x54E8 / %x54E9 /"
            + "	%x54ED / %x54EE / %x54F2 / %x54FA / %x54FD / %x5504 / %x5506 / %x5507 /"
            + "	%x550F / %x5510 / %x5514 / %x5516 / %x552E / %x552F / %x5531 / %x5533 /"
            + "	%x5538 / %x5539 / %x553E / %x5540 / %x5544 / %x5545 / %x5546 / %x554C /"
            + "	%x554F / %x5553 / %x5556 / %x5557 / %x555C / %x555D / %x5563 / %x557B /"
            + "	%x557C / %x557E / %x5580 / %x5583 / %x5584 / %x5587 / %x5589 / %x558A /"
            + "	%x558B / %x5598 / %x5599 / %x559A / %x559C / %x559D / %x559E / %x559F /"
            + "	%x55A7 / %x55A8 / %x55A9 / %x55AA / %x55AB / %x55AC / %x55AE / %x55B0 /"
            + "	%x55B6 / %x55C4 / %x55C5 / %x55C7 / %x55D4 / %x55DA / %x55DC / %x55DF /"
            + "	%x55E3 / %x55E4 / %x55F7 / %x55F9 / %x55FD / %x55FE / %x5606 / %x5609 /"
            + "	%x5614 / %x5616 / %x5617 / %x5618 / %x561B / %x5629 / %x562F / %x5631 /"
            + "	%x5632 / %x5634 / %x5636 / %x5638 / %x5642 / %x564C / %x564E / %x5650 /"
            + "	%x565B / %x5664 / %x5668 / %x566A / %x566B / %x566C / %x5674 / %x5678 /"
            + "	%x567A / %x5680 / %x5686 / %x5687 / %x568A / %x568F / %x5694 / %x56A0 /"
            + "	%x56A2 / %x56A5 / %x56AE / %x56B4 / %x56B6 / %x56BC / %x56C0 / %x56C1 /"
            + "	%x56C2 / %x56C3 / %x56C8 / %x56CE / %x56D1 / %x56D3 / %x56D7 / %x56D8 /"
            + "	%x56DA / %x56DB / %x56DE / %x56E0 / %x56E3 / %x56EE / %x56F0 / %x56F2 /"
            + "	%x56F3 / %x56F9 / %x56FA / %x56FD / %x56FF / %x5700 / %x5703 / %x5704 /"
            + "	%x5708 / %x5709 / %x570B / %x570D / %x570F / %x5712 / %x5713 / %x5716 /"
            + "	%x5718 / %x571C / %x571F / %x5726 / %x5727 / %x5728 / %x572D / %x5730 /"
            + "	%x5737 / %x5738 / %x573B / %x5740 / %x5742 / %x5747 / %x574A / %x574E /"
            + "	%x574F / %x5750 / %x5751 / %x5761 / %x5764 / %x5766 / %x5769 / %x576A /"
            + "	%x577F / %x5782 / %x5788 / %x5789 / %x578B / %x5793 / %x57A0 / %x57A2 /"
            + "	%x57A3 / %x57A4 / %x57AA / %x57B0 / %x57B3 / %x57C0 / %x57C3 / %x57C6 /"
            + "	%x57CB / %x57CE / %x57D2 / %x57D3 / %x57D4 / %x57D6 / %x57DC / %x57DF /"
            + "	%x57E0 / %x57E3 / %x57F4 / %x57F7 / %x57F9 / %x57FA / %x57FC / %x5800 /"
            + "	%x5802 / %x5805 / %x5806 / %x580A / %x580B / %x5815 / %x5819 / %x581D /"
            + "	%x5821 / %x5824 / %x582A / %x582F / %x5830 / %x5831 / %x5834 / %x5835 /"
            + "	%x583A / %x583D / %x5840 / %x5841 / %x584A / %x584B / %x5851 / %x5852 /"
            + "	%x5854 / %x5857 / %x5858 / %x5859 / %x585A / %x585E / %x5862 / %x5869 /"
            + "	%x586B / %x5870 / %x5872 / %x5875 / %x5879 / %x587E / %x5883 / %x5885 /"
            + "	%x5893 / %x5897 / %x589C / %x589F / %x58A8 / %x58AB / %x58AE / %x58B3 /"
            + "	%x58B8 / %x58B9 / %x58BA / %x58BB / %x58BE / %x58C1 / %x58C5 / %x58C7 /"
            + "	%x58CA / %x58CC / %x58D1 / %x58D3 / %x58D5 / %x58D7 / %x58D8 / %x58D9 /"
            + "	%x58DC / %x58DE / %x58DF / %x58E4 / %x58E5 / %x58EB / %x58EC / %x58EE /"
            + "	%x58EF / %x58F0 / %x58F1 / %x58F2 / %x58F7 / %x58F9 / %x58FA / %x58FB /"
            + "	%x58FC / %x58FD / %x5902 / %x5909 / %x590A / %x590F / %x5910 / %x5915 /"
            + "	%x5916 / %x5918 / %x5919 / %x591A / %x591B / %x591C / %x5922 / %x5925 /"
            + "	%x5927 / %x5929 / %x592A / %x592B / %x592C / %x592D / %x592E / %x5931 /"
            + "	%x5932 / %x5937 / %x5938 / %x593E / %x5944 / %x5947 / %x5948 / %x5949 /"
            + "	%x594E / %x594F / %x5950 / %x5951 / %x5954 / %x5955 / %x5957 / %x5958 /"
            + "	%x595A / %x5960 / %x5962 / %x5965 / %x5967 / %x5968 / %x5969 / %x596A /"
            + "	%x596C / %x596E / %x5973 / %x5974 / %x5978 / %x597D / %x5981 / %x5982 /"
            + "	%x5983 / %x5984 / %x598A / %x598D / %x5993 / %x5996 / %x5999 / %x599B /"
            + "	%x599D / %x59A3 / %x59A5 / %x59A8 / %x59AC / %x59B2 / %x59B9 / %x59BB /"
            + "	%x59BE / %x59C6 / %x59C9 / %x59CB / %x59D0 / %x59D1 / %x59D3 / %x59D4 /"
            + "	%x59D9 / %x59DA / %x59DC / %x59E5 / %x59E6 / %x59E8 / %x59EA / %x59EB /"
            + "	%x59F6 / %x59FB / %x59FF / %x5A01 / %x5A03 / %x5A09 / %x5A11 / %x5A18 /"
            + "	%x5A1A / %x5A1C / %x5A1F / %x5A20 / %x5A25 / %x5A29 / %x5A2F / %x5A35 /"
            + "	%x5A36 / %x5A3C / %x5A40 / %x5A41 / %x5A46 / %x5A49 / %x5A5A / %x5A62 /"
            + "	%x5A66 / %x5A6A / %x5A6C / %x5A7F / %x5A92 / %x5A9A / %x5A9B / %x5ABC /"
            + "	%x5ABD / %x5ABE / %x5AC1 / %x5AC2 / %x5AC9 / %x5ACB / %x5ACC / %x5AD0 /"
            + "	%x5AD6 / %x5AD7 / %x5AE1 / %x5AE3 / %x5AE6 / %x5AE9 / %x5AFA / %x5AFB /"
            + "	%x5B09 / %x5B0B / %x5B0C / %x5B16 / %x5B22 / %x5B2A / %x5B2C / %x5B30 /"
            + "	%x5B32 / %x5B36 / %x5B3E / %x5B40 / %x5B43 / %x5B45 / %x5B50 / %x5B51 /"
            + "	%x5B54 / %x5B55 / %x5B57 / %x5B58 / %x5B5A / %x5B5B / %x5B5C / %x5B5D /"
            + "	%x5B5F / %x5B63 / %x5B64 / %x5B65 / %x5B66 / %x5B69 / %x5B6B / %x5B70 /"
            + "	%x5B71 / %x5B73 / %x5B75 / %x5B78 / %x5B7A / %x5B80 / %x5B83 / %x5B85 /"
            + "	%x5B87 / %x5B88 / %x5B89 / %x5B8B / %x5B8C / %x5B8D / %x5B8F / %x5B95 /"
            + "	%x5B97 / %x5B98 / %x5B99 / %x5B9A / %x5B9B / %x5B9C / %x5B9D / %x5B9F /"
            + "	%x5BA2 / %x5BA3 / %x5BA4 / %x5BA5 / %x5BA6 / %x5BAE / %x5BB0 / %x5BB3 /"
            + "	%x5BB4 / %x5BB5 / %x5BB6 / %x5BB8 / %x5BB9 / %x5BBF / %x5BC2 / %x5BC3 /"
            + "	%x5BC4 / %x5BC5 / %x5BC6 / %x5BC7 / %x5BC9 / %x5BCC / %x5BD0 / %x5BD2 /"
            + "	%x5BD3 / %x5BD4 / %x5BDB / %x5BDD / %x5BDE / %x5BDF / %x5BE1 / %x5BE2 /"
            + "	%x5BE4 / %x5BE5 / %x5BE6 / %x5BE7 / %x5BE8 / %x5BE9 / %x5BEB / %x5BEE /"
            + "	%x5BF0 / %x5BF3 / %x5BF5 / %x5BF6 / %x5BF8 / %x5BFA / %x5BFE / %x5BFF /"
            + "	%x5C01 / %x5C02 / %x5C04 / %x5C05 / %x5C06 / %x5C07 / %x5C08 / %x5C09 /"
            + "	%x5C0A / %x5C0B / %x5C0D / %x5C0E / %x5C0F / %x5C11 / %x5C13 / %x5C16 /"
            + "	%x5C1A / %x5C20 / %x5C22 / %x5C24 / %x5C28 / %x5C2D / %x5C31 / %x5C38 /"
            + "	%x5C39 / %x5C3A / %x5C3B / %x5C3C / %x5C3D / %x5C3E / %x5C3F / %x5C40 /"
            + "	%x5C41 / %x5C45 / %x5C46 / %x5C48 / %x5C4A / %x5C4B / %x5C4D / %x5C4E /"
            + "	%x5C4F / %x5C50 / %x5C51 / %x5C53 / %x5C55 / %x5C5E / %x5C60 / %x5C61 /"
            + "	%x5C64 / %x5C65 / %x5C6C / %x5C6E / %x5C6F / %x5C71 / %x5C76 / %x5C79 /"
            + "	%x5C8C / %x5C90 / %x5C91 / %x5C94 / %x5CA1 / %x5CA8 / %x5CA9 / %x5CAB /"
            + "	%x5CAC / %x5CB1 / %x5CB3 / %x5CB6 / %x5CB7 / %x5CB8 / %x5CBB / %x5CBC /"
            + "	%x5CBE / %x5CC5 / %x5CC7 / %x5CD9 / %x5CE0 / %x5CE1 / %x5CE8 / %x5CE9 /"
            + "	%x5CEA / %x5CED / %x5CEF / %x5CF0 / %x5CF6 / %x5CFA / %x5CFB / %x5CFD /"
            + "	%x5D07 / %x5D0B / %x5D0E / %x5D11 / %x5D14 / %x5D15 / %x5D16 / %x5D17 /"
            + "	%x5D18 / %x5D19 / %x5D1A / %x5D1B / %x5D1F / %x5D22 / %x5D29 / %x5D4B /"
            + "	%x5D4C / %x5D4E / %x5D50 / %x5D52 / %x5D5C / %x5D69 / %x5D6C / %x5D6F /"
            + "	%x5D73 / %x5D76 / %x5D82 / %x5D84 / %x5D87 / %x5D8B / %x5D8C / %x5D90 /"
            + "	%x5D9D / %x5DA2 / %x5DAC / %x5DAE / %x5DB7 / %x5DBA / %x5DBC / %x5DBD /"
            + "	%x5DC9 / %x5DCC / %x5DCD / %x5DD2 / %x5DD3 / %x5DD6 / %x5DDB / %x5DDD /"
            + "	%x5DDE / %x5DE1 / %x5DE3 / %x5DE5 / %x5DE6 / %x5DE7 / %x5DE8 / %x5DEB /"
            + "	%x5DEE / %x5DF1 / %x5DF2 / %x5DF3 / %x5DF4 / %x5DF5 / %x5DF7 / %x5DFB /"
            + "	%x5DFD / %x5DFE / %x5E02 / %x5E03 / %x5E06 / %x5E0B / %x5E0C / %x5E11 /"
            + "	%x5E16 / %x5E19 / %x5E1A / %x5E1B / %x5E1D / %x5E25 / %x5E2B / %x5E2D /"
            + "	%x5E2F / %x5E30 / %x5E33 / %x5E36 / %x5E37 / %x5E38 / %x5E3D / %x5E40 /"
            + "	%x5E43 / %x5E44 / %x5E45 / %x5E47 / %x5E4C / %x5E4E / %x5E54 / %x5E55 /"
            + "	%x5E57 / %x5E5F / %x5E61 / %x5E62 / %x5E63 / %x5E64 / %x5E72 / %x5E73 /"
            + "	%x5E74 / %x5E75 / %x5E76 / %x5E78 / %x5E79 / %x5E7A / %x5E7B / %x5E7C /"
            + "	%x5E7D / %x5E7E / %x5E7F / %x5E81 / %x5E83 / %x5E84 / %x5E87 / %x5E8A /"
            + "	%x5E8F / %x5E95 / %x5E96 / %x5E97 / %x5E9A / %x5E9C / %x5EA0 / %x5EA6 /"
            + "	%x5EA7 / %x5EAB / %x5EAD / %x5EB5 / %x5EB6 / %x5EB7 / %x5EB8 / %x5EC1 /"
            + "	%x5EC2 / %x5EC3 / %x5EC8 / %x5EC9 / %x5ECA / %x5ECF / %x5ED0 / %x5ED3 /"
            + "	%x5ED6 / %x5EDA / %x5EDB / %x5EDD / %x5EDF / %x5EE0 / %x5EE1 / %x5EE2 /"
            + "	%x5EE3 / %x5EE8 / %x5EE9 / %x5EEC / %x5EF0 / %x5EF1 / %x5EF3 / %x5EF4 /"
            + "	%x5EF6 / %x5EF7 / %x5EF8 / %x5EFA / %x5EFB / %x5EFC / %x5EFE / %x5EFF /"
            + "	%x5F01 / %x5F03 / %x5F04 / %x5F09 / %x5F0A / %x5F0B / %x5F0C / %x5F0D /"
            + "	%x5F0F / %x5F10 / %x5F11 / %x5F13 / %x5F14 / %x5F15 / %x5F16 / %x5F17 /"
            + "	%x5F18 / %x5F1B / %x5F1F / %x5F25 / %x5F26 / %x5F27 / %x5F29 / %x5F2D /"
            + "	%x5F2F / %x5F31 / %x5F35 / %x5F37 / %x5F38 / %x5F3C / %x5F3E / %x5F41 /"
            + "	%x5F48 / %x5F4A / %x5F4C / %x5F4E / %x5F51 / %x5F53 / %x5F56 / %x5F57 /"
            + "	%x5F59 / %x5F5C / %x5F5D / %x5F61 / %x5F62 / %x5F66 / %x5F69 / %x5F6A /"
            + "	%x5F6B / %x5F6C / %x5F6D / %x5F70 / %x5F71 / %x5F73 / %x5F77 / %x5F79 /"
            + "	%x5F7C / %x5F7F / %x5F80 / %x5F81 / %x5F82 / %x5F83 / %x5F84 / %x5F85 /"
            + "	%x5F87 / %x5F88 / %x5F8A / %x5F8B / %x5F8C / %x5F90 / %x5F91 / %x5F92 /"
            + "	%x5F93 / %x5F97 / %x5F98 / %x5F99 / %x5F9E / %x5FA0 / %x5FA1 / %x5FA8 /"
            + "	%x5FA9 / %x5FAA / %x5FAD / %x5FAE / %x5FB3 / %x5FB4 / %x5FB9 / %x5FBC /"
            + "	%x5FBD / %x5FC3 / %x5FC5 / %x5FCC / %x5FCD / %x5FD6 / %x5FD7 / %x5FD8 /"
            + "	%x5FD9 / %x5FDC / %x5FDD / %x5FE0 / %x5FE4 / %x5FEB / %x5FF0 / %x5FF1 /"
            + "	%x5FF5 / %x5FF8 / %x5FFB / %x5FFD / %x5FFF / %x600E / %x600F / %x6010 /"
            + "	%x6012 / %x6015 / %x6016 / %x6019 / %x601B / %x601C / %x601D / %x6020 /"
            + "	%x6021 / %x6025 / %x6026 / %x6027 / %x6028 / %x6029 / %x602A / %x602B /"
            + "	%x602F / %x6031 / %x603A / %x6041 / %x6042 / %x6043 / %x6046 / %x604A /"
            + "	%x604B / %x604D / %x6050 / %x6052 / %x6055 / %x6059 / %x605A / %x605F /"
            + "	%x6060 / %x6062 / %x6063 / %x6064 / %x6065 / %x6068 / %x6069 / %x606A /"
            + "	%x606B / %x606C / %x606D / %x606F / %x6070 / %x6075 / %x6077 / %x6081 /"
            + "	%x6083 / %x6084 / %x6089 / %x608B / %x608C / %x608D / %x6092 / %x6094 /"
            + "	%x6096 / %x6097 / %x609A / %x609B / %x609F / %x60A0 / %x60A3 / %x60A6 /"
            + "	%x60A7 / %x60A9 / %x60AA / %x60B2 / %x60B3 / %x60B4 / %x60B5 / %x60B6 /"
            + "	%x60B8 / %x60BC / %x60BD / %x60C5 / %x60C6 / %x60C7 / %x60D1 / %x60D3 /"
            + "	%x60D8 / %x60DA / %x60DC / %x60DF / %x60E0 / %x60E1 / %x60E3 / %x60E7 /"
            + "	%x60E8 / %x60F0 / %x60F1 / %x60F3 / %x60F4 / %x60F6 / %x60F7 / %x60F9 /"
            + "	%x60FA / %x60FB / %x6100 / %x6101 / %x6103 / %x6106 / %x6108 / %x6109 /"
            + "	%x610D / %x610E / %x610F / %x6115 / %x611A / %x611B / %x611F / %x6121 /"
            + "	%x6127 / %x6128 / %x612C / %x6134 / %x613C / %x613D / %x613E / %x613F /"
            + "	%x6142 / %x6144 / %x6147 / %x6148 / %x614A / %x614B / %x614C / %x614D /"
            + "	%x614E / %x6153 / %x6155 / %x6158 / %x6159 / %x615A / %x615D / %x615F /"
            + "	%x6162 / %x6163 / %x6165 / %x6167 / %x6168 / %x616B / %x616E / %x616F /"
            + "	%x6170 / %x6171 / %x6173 / %x6174 / %x6175 / %x6176 / %x6177 / %x617E /"
            + "	%x6182 / %x6187 / %x618A / %x618E / %x6190 / %x6191 / %x6194 / %x6196 /"
            + "	%x6199 / %x619A / %x61A4 / %x61A7 / %x61A9 / %x61AB / %x61AC / %x61AE /"
            + "	%x61B2 / %x61B6 / %x61BA / %x61BE / %x61C3 / %x61C6 / %x61C7 / %x61C8 /"
            + "	%x61C9 / %x61CA / %x61CB / %x61CC / %x61CD / %x61D0 / %x61E3 / %x61E6 /"
            + "	%x61F2 / %x61F4 / %x61F6 / %x61F7 / %x61F8 / %x61FA / %x61FC / %x61FD /"
            + "	%x61FE / %x61FF / %x6200 / %x6208 / %x6209 / %x620A / %x620C / %x620D /"
            + "	%x620E / %x6210 / %x6211 / %x6212 / %x6214 / %x6216 / %x621A / %x621B /"
            + "	%x621D / %x621E / %x621F / %x6221 / %x6226 / %x622A / %x622E / %x622F /"
            + "	%x6230 / %x6232 / %x6233 / %x6234 / %x6238 / %x623B / %x623F / %x6240 /"
            + "	%x6241 / %x6247 / %x6248 / %x6249 / %x624B / %x624D / %x624E / %x6253 /"
            + "	%x6255 / %x6258 / %x625B / %x625E / %x6260 / %x6263 / %x6268 / %x626E /"
            + "	%x6271 / %x6276 / %x6279 / %x627C / %x627E / %x627F / %x6280 / %x6282 /"
            + "	%x6283 / %x6284 / %x6289 / %x628A / %x6291 / %x6292 / %x6293 / %x6294 /"
            + "	%x6295 / %x6296 / %x6297 / %x6298 / %x629B / %x629C / %x629E / %x62AB /"
            + "	%x62AC / %x62B1 / %x62B5 / %x62B9 / %x62BB / %x62BC / %x62BD / %x62C2 /"
            + "	%x62C5 / %x62C6 / %x62C7 / %x62C8 / %x62C9 / %x62CA / %x62CC / %x62CD /"
            + "	%x62CF / %x62D0 / %x62D1 / %x62D2 / %x62D3 / %x62D4 / %x62D7 / %x62D8 /"
            + "	%x62D9 / %x62DB / %x62DC / %x62DD / %x62E0 / %x62E1 / %x62EC / %x62ED /"
            + "	%x62EE / %x62EF / %x62F1 / %x62F3 / %x62F5 / %x62F6 / %x62F7 / %x62FE /"
            + "	%x62FF / %x6301 / %x6302 / %x6307 / %x6308 / %x6309 / %x630C / %x6311 /"
            + "	%x6319 / %x631F / %x6327 / %x6328 / %x632B / %x632F / %x633A / %x633D /"
            + "	%x633E / %x633F / %x6349 / %x634C / %x634D / %x634F / %x6350 / %x6355 /"
            + "	%x6357 / %x635C / %x6367 / %x6368 / %x6369 / %x636B / %x636E / %x6372 /"
            + "	%x6376 / %x6377 / %x637A / %x637B / %x6380 / %x6383 / %x6388 / %x6389 /"
            + "	%x638C / %x638E / %x638F / %x6392 / %x6396 / %x6398 / %x639B / %x639F /"
            + "	%x63A0 / %x63A1 / %x63A2 / %x63A3 / %x63A5 / %x63A7 / %x63A8 / %x63A9 /"
            + "	%x63AA / %x63AB / %x63AC / %x63B2 / %x63B4 / %x63B5 / %x63BB / %x63BE /"
            + "	%x63C0 / %x63C3 / %x63C4 / %x63C6 / %x63C9 / %x63CF / %x63D0 / %x63D2 /"
            + "	%x63D6 / %x63DA / %x63DB / %x63E1 / %x63E3 / %x63E9 / %x63EE / %x63F4 /"
            + "	%x63F6 / %x63FA / %x6406 / %x640D / %x640F / %x6413 / %x6416 / %x6417 /"
            + "	%x641C / %x6426 / %x6428 / %x642C / %x642D / %x6434 / %x6436 / %x643A /"
            + "	%x643E / %x6442 / %x644E / %x6458 / %x6467 / %x6469 / %x646F / %x6476 /"
            + "	%x6478 / %x647A / %x6483 / %x6488 / %x6492 / %x6493 / %x6495 / %x649A /"
            + "	%x649E / %x64A4 / %x64A5 / %x64A9 / %x64AB / %x64AD / %x64AE / %x64B0 /"
            + "	%x64B2 / %x64B9 / %x64BB / %x64BC / %x64C1 / %x64C2 / %x64C5 / %x64C7 /"
            + "	%x64CD / %x64D2 / %x64D4 / %x64D8 / %x64DA / %x64E0 / %x64E1 / %x64E2 /"
            + "	%x64E3 / %x64E6 / %x64E7 / %x64EC / %x64EF / %x64F1 / %x64F2 / %x64F4 /"
            + "	%x64F6 / %x64FA / %x64FD / %x64FE / %x6500 / %x6505 / %x6518 / %x651C /"
            + "	%x651D / %x6523 / %x6524 / %x652A / %x652B / %x652C / %x652F / %x6534 /"
            + "	%x6535 / %x6536 / %x6537 / %x6538 / %x6539 / %x653B / %x653E / %x653F /"
            + "	%x6545 / %x6548 / %x654D / %x654F / %x6551 / %x6555 / %x6556 / %x6557 /"
            + "	%x6558 / %x6559 / %x655D / %x655E / %x6562 / %x6563 / %x6566 / %x656C /"
            + "	%x6570 / %x6572 / %x6574 / %x6575 / %x6577 / %x6578 / %x6582 / %x6583 /"
            + "	%x6587 / %x6588 / %x6589 / %x658C / %x658E / %x6590 / %x6591 / %x6597 /"
            + "	%x6599 / %x659B / %x659C / %x659F / %x65A1 / %x65A4 / %x65A5 / %x65A7 /"
            + "	%x65AB / %x65AC / %x65AD / %x65AF / %x65B0 / %x65B7 / %x65B9 / %x65BC /"
            + "	%x65BD / %x65C1 / %x65C3 / %x65C4 / %x65C5 / %x65C6 / %x65CB / %x65CC /"
            + "	%x65CF / %x65D2 / %x65D7 / %x65D9 / %x65DB / %x65E0 / %x65E1 / %x65E2 /"
            + "	%x65E5 / %x65E6 / %x65E7 / %x65E8 / %x65E9 / %x65EC / %x65ED / %x65F1 /"
            + "	%x65FA / %x65FB / %x6602 / %x6603 / %x6606 / %x6607 / %x660A / %x660C /"
            + "	%x660E / %x660F / %x6613 / %x6614 / %x661C / %x661F / %x6620 / %x6625 /"
            + "	%x6627 / %x6628 / %x662D / %x662F / %x6634 / %x6635 / %x6636 / %x663C /"
            + "	%x663F / %x6641 / %x6642 / %x6643 / %x6644 / %x6649 / %x664B / %x664F /"
            + "	%x6652 / %x665D / %x665E / %x665F / %x6662 / %x6664 / %x6666 / %x6667 /"
            + "	%x6668 / %x6669 / %x666E / %x666F / %x6670 / %x6674 / %x6676 / %x667A /"
            + "	%x6681 / %x6683 / %x6684 / %x6687 / %x6688 / %x6689 / %x668E / %x6691 /"
            + "	%x6696 / %x6697 / %x6698 / %x669D / %x66A2 / %x66A6 / %x66AB / %x66AE /"
            + "	%x66B4 / %x66B8 / %x66B9 / %x66BC / %x66BE / %x66C1 / %x66C4 / %x66C7 /"
            + "	%x66C9 / %x66D6 / %x66D9 / %x66DA / %x66DC / %x66DD / %x66E0 / %x66E6 /"
            + "	%x66E9 / %x66F0 / %x66F2 / %x66F3 / %x66F4 / %x66F5 / %x66F7 / %x66F8 /"
            + "	%x66F9 / %x66FC / %x66FD / %x66FE / %x66FF / %x6700 / %x6703 / %x6708 /"
            + "	%x6709 / %x670B / %x670D / %x670F / %x6714 / %x6715 / %x6716 / %x6717 /"
            + "	%x671B / %x671D / %x671E / %x671F / %x6726 / %x6727 / %x6728 / %x672A /"
            + "	%x672B / %x672C / %x672D / %x672E / %x6731 / %x6734 / %x6736 / %x6737 /"
            + "	%x6738 / %x673A / %x673D / %x673F / %x6741 / %x6746 / %x6749 / %x674E /"
            + "	%x674F / %x6750 / %x6751 / %x6753 / %x6756 / %x6759 / %x675C / %x675E /"
            + "	%x675F / %x6760 / %x6761 / %x6762 / %x6763 / %x6764 / %x6765 / %x676A /"
            + "	%x676D / %x676F / %x6770 / %x6771 / %x6772 / %x6773 / %x6775 / %x6777 /"
            + "	%x677C / %x677E / %x677F / %x6785 / %x6787 / %x6789 / %x678B / %x678C /"
            + "	%x6790 / %x6795 / %x6797 / %x679A / %x679C / %x679D / %x67A0 / %x67A1 /"
            + "	%x67A2 / %x67A6 / %x67A9 / %x67AF / %x67B3 / %x67B4 / %x67B6 / %x67B7 /"
            + "	%x67B8 / %x67B9 / %x67C1 / %x67C4 / %x67C6 / %x67CA / %x67CE / %x67CF /"
            + "	%x67D0 / %x67D1 / %x67D3 / %x67D4 / %x67D8 / %x67DA / %x67DD / %x67DE /"
            + "	%x67E2 / %x67E4 / %x67E7 / %x67E9 / %x67EC / %x67EE / %x67EF / %x67F1 /"
            + "	%x67F3 / %x67F4 / %x67F5 / %x67FB / %x67FE / %x67FF / %x6802 / %x6803 /"
            + "	%x6804 / %x6813 / %x6816 / %x6817 / %x681E / %x6821 / %x6822 / %x6829 /"
            + "	%x682A / %x682B / %x6832 / %x6834 / %x6838 / %x6839 / %x683C / %x683D /"
            + "	%x6840 / %x6841 / %x6842 / %x6843 / %x6846 / %x6848 / %x684D / %x684E /"
            + "	%x6850 / %x6851 / %x6853 / %x6854 / %x6859 / %x685C / %x685D / %x685F /"
            + "	%x6863 / %x6867 / %x6874 / %x6876 / %x6877 / %x687E / %x687F / %x6881 /"
            + "	%x6883 / %x6885 / %x688D / %x688F / %x6893 / %x6894 / %x6897 / %x689B /"
            + "	%x689D / %x689F / %x68A0 / %x68A2 / %x68A6 / %x68A7 / %x68A8 / %x68AD /"
            + "	%x68AF / %x68B0 / %x68B1 / %x68B3 / %x68B5 / %x68B6 / %x68B9 / %x68BA /"
            + "	%x68BC / %x68C4 / %x68C6 / %x68C9 / %x68CA / %x68CB / %x68CD / %x68D2 /"
            + "	%x68D4 / %x68D5 / %x68D7 / %x68D8 / %x68DA / %x68DF / %x68E0 / %x68E1 /"
            + "	%x68E3 / %x68E7 / %x68EE / %x68EF / %x68F2 / %x68F9 / %x68FA / %x6900 /"
            + "	%x6901 / %x6904 / %x6905 / %x6908 / %x690B / %x690C / %x690D / %x690E /"
            + "	%x690F / %x6912 / %x6919 / %x691A / %x691B / %x691C / %x6921 / %x6922 /"
            + "	%x6923 / %x6925 / %x6926 / %x6928 / %x692A / %x6930 / %x6934 / %x6936 /"
            + "	%x6939 / %x693D / %x693F / %x694A / %x6953 / %x6954 / %x6955 / %x6959 /"
            + "	%x695A / %x695C / %x695D / %x695E / %x6960 / %x6961 / %x6962 / %x696A /"
            + "	%x696B / %x696D / %x696E / %x696F / %x6973 / %x6974 / %x6975 / %x6977 /"
            + "	%x6978 / %x6979 / %x697C / %x697D / %x697E / %x6981 / %x6982 / %x698A /"
            + "	%x698E / %x6991 / %x6994 / %x6995 / %x699B / %x699C / %x69A0 / %x69A7 /"
            + "	%x69AE / %x69B1 / %x69B2 / %x69B4 / %x69BB / %x69BE / %x69BF / %x69C1 /"
            + "	%x69C3 / %x69C7 / %x69CA / %x69CB / %x69CC / %x69CD / %x69CE / %x69D0 /"
            + "	%x69D3 / %x69D8 / %x69D9 / %x69DD / %x69DE / %x69E7 / %x69E8 / %x69EB /"
            + "	%x69ED / %x69F2 / %x69F9 / %x69FB / %x69FD / %x69FF / %x6A02 / %x6A05 /"
            + "	%x6A0A / %x6A0B / %x6A0C / %x6A12 / %x6A13 / %x6A14 / %x6A17 / %x6A19 /"
            + "	%x6A1B / %x6A1E / %x6A1F / %x6A21 / %x6A22 / %x6A23 / %x6A29 / %x6A2A /"
            + "	%x6A2B / %x6A2E / %x6A35 / %x6A36 / %x6A38 / %x6A39 / %x6A3A / %x6A3D /"
            + "	%x6A44 / %x6A47 / %x6A48 / %x6A4B / %x6A58 / %x6A59 / %x6A5F / %x6A61 /"
            + "	%x6A62 / %x6A66 / %x6A72 / %x6A78 / %x6A7F / %x6A80 / %x6A84 / %x6A8D /"
            + "	%x6A8E / %x6A90 / %x6A97 / %x6A9C / %x6AA0 / %x6AA2 / %x6AA3 / %x6AAA /"
            + "	%x6AAC / %x6AAE / %x6AB3 / %x6AB8 / %x6ABB / %x6AC1 / %x6AC2 / %x6AC3 /"
            + "	%x6AD1 / %x6AD3 / %x6ADA / %x6ADB / %x6ADE / %x6ADF / %x6AE8 / %x6AEA /"
            + "	%x6AFA / %x6AFB / %x6B04 / %x6B05 / %x6B0A / %x6B12 / %x6B16 / %x6B1D /"
            + "	%x6B1F / %x6B20 / %x6B21 / %x6B23 / %x6B27 / %x6B32 / %x6B37 / %x6B38 /"
            + "	%x6B39 / %x6B3A / %x6B3D / %x6B3E / %x6B43 / %x6B47 / %x6B49 / %x6B4C /"
            + "	%x6B4E / %x6B50 / %x6B53 / %x6B54 / %x6B59 / %x6B5B / %x6B5F / %x6B61 /"
            + "	%x6B62 / %x6B63 / %x6B64 / %x6B66 / %x6B69 / %x6B6A / %x6B6F / %x6B73 /"
            + "	%x6B74 / %x6B78 / %x6B79 / %x6B7B / %x6B7F / %x6B80 / %x6B83 / %x6B84 /"
            + "	%x6B86 / %x6B89 / %x6B8A / %x6B8B / %x6B8D / %x6B95 / %x6B96 / %x6B98 /"
            + "	%x6B9E / %x6BA4 / %x6BAA / %x6BAB / %x6BAF / %x6BB1 / %x6BB2 / %x6BB3 /"
            + "	%x6BB4 / %x6BB5 / %x6BB7 / %x6BBA / %x6BBB / %x6BBC / %x6BBF / %x6BC0 /"
            + "	%x6BC5 / %x6BC6 / %x6BCB / %x6BCD / %x6BCE / %x6BD2 / %x6BD3 / %x6BD4 /"
            + "	%x6BD8 / %x6BDB / %x6BDF / %x6BEB / %x6BEC / %x6BEF / %x6BF3 / %x6C08 /"
            + "	%x6C0F / %x6C11 / %x6C13 / %x6C14 / %x6C17 / %x6C1B / %x6C23 / %x6C24 /"
            + "	%x6C34 / %x6C37 / %x6C38 / %x6C3E / %x6C40 / %x6C41 / %x6C42 / %x6C4E /"
            + "	%x6C50 / %x6C55 / %x6C57 / %x6C5A / %x6C5D / %x6C5E / %x6C5F / %x6C60 /"
            + "	%x6C62 / %x6C68 / %x6C6A / %x6C70 / %x6C72 / %x6C73 / %x6C7A / %x6C7D /"
            + "	%x6C7E / %x6C81 / %x6C82 / %x6C83 / %x6C88 / %x6C8C / %x6C8D / %x6C90 /"
            + "	%x6C92 / %x6C93 / %x6C96 / %x6C99 / %x6C9A / %x6C9B / %x6CA1 / %x6CA2 /"
            + "	%x6CAB / %x6CAE / %x6CB1 / %x6CB3 / %x6CB8 / %x6CB9 / %x6CBA / %x6CBB /"
            + "	%x6CBC / %x6CBD / %x6CBE / %x6CBF / %x6CC1 / %x6CC4 / %x6CC5 / %x6CC9 /"
            + "	%x6CCA / %x6CCC / %x6CD3 / %x6CD5 / %x6CD7 / %x6CD9 / %x6CDB / %x6CDD /"
            + "	%x6CE1 / %x6CE2 / %x6CE3 / %x6CE5 / %x6CE8 / %x6CEA / %x6CEF / %x6CF0 /"
            + "	%x6CF1 / %x6CF3 / %x6D0B / %x6D0C / %x6D12 / %x6D17 / %x6D19 / %x6D1B /"
            + "	%x6D1E / %x6D1F / %x6D25 / %x6D29 / %x6D2A / %x6D2B / %x6D32 / %x6D33 /"
            + "	%x6D35 / %x6D36 / %x6D38 / %x6D3B / %x6D3D / %x6D3E / %x6D41 / %x6D44 /"
            + "	%x6D45 / %x6D59 / %x6D5A / %x6D5C / %x6D63 / %x6D64 / %x6D66 / %x6D69 /"
            + "	%x6D6A / %x6D6C / %x6D6E / %x6D74 / %x6D77 / %x6D78 / %x6D79 / %x6D85 /"
            + "	%x6D88 / %x6D8C / %x6D8E / %x6D93 / %x6D95 / %x6D99 / %x6D9B / %x6D9C /"
            + "	%x6DAF / %x6DB2 / %x6DB5 / %x6DB8 / %x6DBC / %x6DC0 / %x6DC5 / %x6DC6 /"
            + "	%x6DC7 / %x6DCB / %x6DCC / %x6DD1 / %x6DD2 / %x6DD5 / %x6DD8 / %x6DD9 /"
            + "	%x6DDE / %x6DE1 / %x6DE4 / %x6DE6 / %x6DE8 / %x6DEA / %x6DEB / %x6DEC /"
            + "	%x6DEE / %x6DF1 / %x6DF3 / %x6DF5 / %x6DF7 / %x6DF9 / %x6DFA / %x6DFB /"
            + "	%x6E05 / %x6E07 / %x6E08 / %x6E09 / %x6E0A / %x6E0B / %x6E13 / %x6E15 /"
            + "	%x6E19 / %x6E1A / %x6E1B / %x6E1D / %x6E1F / %x6E20 / %x6E21 / %x6E23 /"
            + "	%x6E24 / %x6E25 / %x6E26 / %x6E29 / %x6E2B / %x6E2C / %x6E2D / %x6E2E /"
            + "	%x6E2F / %x6E38 / %x6E3A / %x6E3E / %x6E43 / %x6E4A / %x6E4D / %x6E4E /"
            + "	%x6E56 / %x6E58 / %x6E5B / %x6E5F / %x6E67 / %x6E6B / %x6E6E / %x6E6F /"
            + "	%x6E72 / %x6E76 / %x6E7E / %x6E7F / %x6E80 / %x6E82 / %x6E8C / %x6E8F /"
            + "	%x6E90 / %x6E96 / %x6E98 / %x6E9C / %x6E9D / %x6E9F / %x6EA2 / %x6EA5 /"
            + "	%x6EAA / %x6EAF / %x6EB2 / %x6EB6 / %x6EB7 / %x6EBA / %x6EBD / %x6EC2 /"
            + "	%x6EC4 / %x6EC5 / %x6EC9 / %x6ECB / %x6ECC / %x6ED1 / %x6ED3 / %x6ED4 /"
            + "	%x6ED5 / %x6EDD / %x6EDE / %x6EEC / %x6EEF / %x6EF2 / %x6EF4 / %x6EF7 /"
            + "	%x6EF8 / %x6EFE / %x6EFF / %x6F01 / %x6F02 / %x6F06 / %x6F09 / %x6F0F /"
            + "	%x6F11 / %x6F13 / %x6F14 / %x6F15 / %x6F20 / %x6F22 / %x6F23 / %x6F2B /"
            + "	%x6F2C / %x6F31 / %x6F32 / %x6F38 / %x6F3E / %x6F3F / %x6F41 / %x6F45 /"
            + "	%x6F54 / %x6F58 / %x6F5B / %x6F5C / %x6F5F / %x6F64 / %x6F66 / %x6F6D /"
            + "	%x6F6E / %x6F6F / %x6F70 / %x6F74 / %x6F78 / %x6F7A / %x6F7C / %x6F80 /"
            + "	%x6F81 / %x6F82 / %x6F84 / %x6F86 / %x6F8E / %x6F91 / %x6F97 / %x6FA1 /"
            + "	%x6FA3 / %x6FA4 / %x6FAA / %x6FB1 / %x6FB3 / %x6FB9 / %x6FC0 / %x6FC1 /"
            + "	%x6FC2 / %x6FC3 / %x6FC6 / %x6FD4 / %x6FD5 / %x6FD8 / %x6FDB / %x6FDF /"
            + "	%x6FE0 / %x6FE1 / %x6FE4 / %x6FEB / %x6FEC / %x6FEE / %x6FEF / %x6FF1 /"
            + "	%x6FF3 / %x6FF6 / %x6FFA / %x6FFE / %x7001 / %x7009 / %x700B / %x700F /"
            + "	%x7011 / %x7015 / %x7018 / %x701A / %x701B / %x701D / %x701E / %x701F /"
            + "	%x7026 / %x7027 / %x702C / %x7030 / %x7032 / %x703E / %x704C / %x7051 /"
            + "	%x7058 / %x7063 / %x706B / %x706F / %x7070 / %x7078 / %x707C / %x707D /"
            + "	%x7089 / %x708A / %x708E / %x7092 / %x7099 / %x70AC / %x70AD / %x70AE /"
            + "	%x70AF / %x70B3 / %x70B8 / %x70B9 / %x70BA / %x70C8 / %x70CB / %x70CF /"
            + "	%x70D9 / %x70DD / %x70DF / %x70F1 / %x70F9 / %x70FD / %x7109 / %x7114 /"
            + "	%x7119 / %x711A / %x711C / %x7121 / %x7126 / %x7136 / %x713C / %x7149 /"
            + "	%x714C / %x714E / %x7155 / %x7156 / %x7159 / %x7162 / %x7164 / %x7165 /"
            + "	%x7166 / %x7167 / %x7169 / %x716C / %x716E / %x717D / %x7184 / %x7188 /"
            + "	%x718A / %x718F / %x7194 / %x7195 / %x7199 / %x719F / %x71A8 / %x71AC /"
            + "	%x71B1 / %x71B9 / %x71BE / %x71C3 / %x71C8 / %x71C9 / %x71CE / %x71D0 /"
            + "	%x71D2 / %x71D4 / %x71D5 / %x71D7 / %x71DF / %x71E0 / %x71E5 / %x71E6 /"
            + "	%x71E7 / %x71EC / %x71ED / %x71EE / %x71F5 / %x71F9 / %x71FB / %x71FC /"
            + "	%x71FF / %x7206 / %x720D / %x7210 / %x721B / %x7228 / %x722A / %x722C /"
            + "	%x722D / %x7230 / %x7232 / %x7235 / %x7236 / %x723A / %x723B / %x723C /"
            + "	%x723D / %x723E / %x723F / %x7240 / %x7246 / %x7247 / %x7248 / %x724B /"
            + "	%x724C / %x7252 / %x7258 / %x7259 / %x725B / %x725D / %x725F / %x7261 /"
            + "	%x7262 / %x7267 / %x7269 / %x7272 / %x7274 / %x7279 / %x727D / %x727E /"
            + "	%x7280 / %x7281 / %x7282 / %x7287 / %x7292 / %x7296 / %x72A0 / %x72A2 /"
            + "	%x72A7 / %x72AC / %x72AF / %x72B2 / %x72B6 / %x72B9 / %x72C2 / %x72C3 /"
            + "	%x72C4 / %x72C6 / %x72CE / %x72D0 / %x72D2 / %x72D7 / %x72D9 / %x72DB /"
            + "	%x72E0 / %x72E1 / %x72E2 / %x72E9 / %x72EC / %x72ED / %x72F7 / %x72F8 /"
            + "	%x72F9 / %x72FC / %x72FD / %x730A / %x7316 / %x7317 / %x731B / %x731C /"
            + "	%x731D / %x731F / %x7325 / %x7329 / %x732A / %x732B / %x732E / %x732F /"
            + "	%x7334 / %x7336 / %x7337 / %x733E / %x733F / %x7344 / %x7345 / %x734E /"
            + "	%x734F / %x7357 / %x7363 / %x7368 / %x736A / %x7370 / %x7372 / %x7375 /"
            + "	%x7378 / %x737A / %x737B / %x7384 / %x7387 / %x7389 / %x738B / %x7396 /"
            + "	%x73A9 / %x73B2 / %x73B3 / %x73BB / %x73C0 / %x73C2 / %x73C8 / %x73CA /"
            + "	%x73CD / %x73CE / %x73DE / %x73E0 / %x73E5 / %x73EA / %x73ED / %x73EE /"
            + "	%x73F1 / %x73F8 / %x73FE / %x7403 / %x7405 / %x7406 / %x7409 / %x7422 /"
            + "	%x7425 / %x7432 / %x7433 / %x7434 / %x7435 / %x7436 / %x743A / %x743F /"
            + "	%x7441 / %x7455 / %x7459 / %x745A / %x745B / %x745C / %x745E / %x745F /"
            + "	%x7460 / %x7463 / %x7464 / %x7469 / %x746A / %x746F / %x7470 / %x7473 /"
            + "	%x7476 / %x747E / %x7483 / %x748B / %x749E / %x74A2 / %x74A7 / %x74B0 /"
            + "	%x74BD / %x74CA / %x74CF / %x74D4 / %x74DC / %x74E0 / %x74E2 / %x74E3 /"
            + "	%x74E6 / %x74E7 / %x74E9 / %x74EE / %x74F0 / %x74F1 / %x74F2 / %x74F6 /"
            + "	%x74F7 / %x74F8 / %x7503 / %x7504 / %x7505 / %x750C / %x750D / %x750E /"
            + "	%x7511 / %x7513 / %x7515 / %x7518 / %x751A / %x751C / %x751E / %x751F /"
            + "	%x7523 / %x7525 / %x7526 / %x7528 / %x752B / %x752C / %x7530 / %x7531 /"
            + "	%x7532 / %x7533 / %x7537 / %x7538 / %x753A / %x753B / %x753C / %x7544 /"
            + "	%x7546 / %x7549 / %x754A / %x754B / %x754C / %x754D / %x754F / %x7551 /"
            + "	%x7554 / %x7559 / %x755A / %x755B / %x755C / %x755D / %x7560 / %x7562 /"
            + "	%x7564 / %x7565 / %x7566 / %x7567 / %x7569 / %x756A / %x756B / %x756D /"
            + "	%x7570 / %x7573 / %x7574 / %x7576 / %x7577 / %x7578 / %x757F / %x7582 /"
            + "	%x7586 / %x7587 / %x7589 / %x758A / %x758B / %x758E / %x758F / %x7591 /"
            + "	%x7594 / %x759A / %x759D / %x75A3 / %x75A5 / %x75AB / %x75B1 / %x75B2 /"
            + "	%x75B3 / %x75B5 / %x75B8 / %x75B9 / %x75BC / %x75BD / %x75BE / %x75C2 /"
            + "	%x75C3 / %x75C5 / %x75C7 / %x75CA / %x75CD / %x75D2 / %x75D4 / %x75D5 /"
            + "	%x75D8 / %x75D9 / %x75DB / %x75DE / %x75E2 / %x75E3 / %x75E9 / %x75F0 /"
            + "	%x75F2 / %x75F3 / %x75F4 / %x75FA / %x75FC / %x75FE / %x75FF / %x7601 /"
            + "	%x7609 / %x760B / %x760D / %x761F / %x7620 / %x7621 / %x7622 / %x7624 /"
            + "	%x7627 / %x7630 / %x7634 / %x763B / %x7642 / %x7646 / %x7647 / %x7648 /"
            + "	%x764C / %x7652 / %x7656 / %x7658 / %x765C / %x7661 / %x7662 / %x7667 /"
            + "	%x7668 / %x7669 / %x766A / %x766C / %x7670 / %x7672 / %x7676 / %x7678 /"
            + "	%x767A / %x767B / %x767C / %x767D / %x767E / %x7680 / %x7683 / %x7684 /"
            + "	%x7686 / %x7687 / %x7688 / %x768B / %x768E / %x7690 / %x7693 / %x7696 /"
            + "	%x7699 / %x769A / %x76AE / %x76B0 / %x76B4 / %x76B7 / %x76B8 / %x76B9 /"
            + "	%x76BA / %x76BF / %x76C2 / %x76C3 / %x76C6 / %x76C8 / %x76CA / %x76CD /"
            + "	%x76D2 / %x76D6 / %x76D7 / %x76DB / %x76DC / %x76DE / %x76DF / %x76E1 /"
            + "	%x76E3 / %x76E4 / %x76E5 / %x76E7 / %x76EA / %x76EE / %x76F2 / %x76F4 /"
            + "	%x76F8 / %x76FB / %x76FE / %x7701 / %x7704 / %x7707 / %x7708 / %x7709 /"
            + "	%x770B / %x770C / %x771B / %x771E / %x771F / %x7720 / %x7724 / %x7725 /"
            + "	%x7726 / %x7729 / %x7737 / %x7738 / %x773A / %x773C / %x7740 / %x7747 /"
            + "	%x775A / %x775B / %x7761 / %x7763 / %x7765 / %x7766 / %x7768 / %x776B /"
            + "	%x7779 / %x777E / %x777F / %x778B / %x778E / %x7791 / %x779E / %x77A0 /"
            + "	%x77A5 / %x77AC / %x77AD / %x77B0 / %x77B3 / %x77B6 / %x77B9 / %x77BB /"
            + "	%x77BC / %x77BD / %x77BF / %x77C7 / %x77CD / %x77D7 / %x77DA / %x77DB /"
            + "	%x77DC / %x77E2 / %x77E3 / %x77E5 / %x77E7 / %x77E9 / %x77ED / %x77EE /"
            + "	%x77EF / %x77F3 / %x77FC / %x7802 / %x780C / %x7812 / %x7814 / %x7815 /"
            + "	%x7820 / %x7825 / %x7826 / %x7827 / %x7832 / %x7834 / %x783A / %x783F /"
            + "	%x7845 / %x785D / %x786B / %x786C / %x786F / %x7872 / %x7874 / %x787C /"
            + "	%x7881 / %x7886 / %x7887 / %x788C / %x788D / %x788E / %x7891 / %x7893 /"
            + "	%x7895 / %x7897 / %x789A / %x78A3 / %x78A7 / %x78A9 / %x78AA / %x78AF /"
            + "	%x78B5 / %x78BA / %x78BC / %x78BE / %x78C1 / %x78C5 / %x78C6 / %x78CA /"
            + "	%x78CB / %x78D0 / %x78D1 / %x78D4 / %x78DA / %x78E7 / %x78E8 / %x78EC /"
            + "	%x78EF / %x78F4 / %x78FD / %x7901 / %x7907 / %x790E / %x7911 / %x7912 /"
            + "	%x7919 / %x7926 / %x792A / %x792B / %x792C / %x793A / %x793C / %x793E /"
            + "	%x7940 / %x7941 / %x7947 / %x7948 / %x7949 / %x7950 / %x7953 / %x7955 /"
            + "	%x7956 / %x7957 / %x795A / %x795D / %x795E / %x795F / %x7960 / %x7962 /"
            + "	%x7965 / %x7968 / %x796D / %x7977 / %x797A / %x797F / %x7980 / %x7981 /"
            + "	%x7984 / %x7985 / %x798A / %x798D / %x798E / %x798F / %x799D / %x79A6 /"
            + "	%x79A7 / %x79AA / %x79AE / %x79B0 / %x79B3 / %x79B9 / %x79BA / %x79BD /"
            + "	%x79BE / %x79BF / %x79C0 / %x79C1 / %x79C9 / %x79CB / %x79D1 / %x79D2 /"
            + "	%x79D5 / %x79D8 / %x79DF / %x79E1 / %x79E3 / %x79E4 / %x79E6 / %x79E7 /"
            + "	%x79E9 / %x79EC / %x79F0 / %x79FB / %x7A00 / %x7A08 / %x7A0B / %x7A0D /"
            + "	%x7A0E / %x7A14 / %x7A17 / %x7A18 / %x7A19 / %x7A1A / %x7A1C / %x7A1F /"
            + "	%x7A20 / %x7A2E / %x7A31 / %x7A32 / %x7A37 / %x7A3B / %x7A3C / %x7A3D /"
            + "	%x7A3E / %x7A3F / %x7A40 / %x7A42 / %x7A43 / %x7A46 / %x7A49 / %x7A4D /"
            + "	%x7A4E / %x7A4F / %x7A50 / %x7A57 / %x7A61 / %x7A62 / %x7A63 / %x7A69 /"
            + "	%x7A6B / %x7A70 / %x7A74 / %x7A76 / %x7A79 / %x7A7A / %x7A7D / %x7A7F /"
            + "	%x7A81 / %x7A83 / %x7A84 / %x7A88 / %x7A92 / %x7A93 / %x7A95 / %x7A96 /"
            + "	%x7A97 / %x7A98 / %x7A9F / %x7AA9 / %x7AAA / %x7AAE / %x7AAF / %x7AB0 /"
            + "	%x7AB6 / %x7ABA / %x7ABF / %x7AC3 / %x7AC4 / %x7AC5 / %x7AC7 / %x7AC8 /"
            + "	%x7ACA / %x7ACB / %x7ACD / %x7ACF / %x7AD2 / %x7AD3 / %x7AD5 / %x7AD9 /"
            + "	%x7ADA / %x7ADC / %x7ADD / %x7ADF / %x7AE0 / %x7AE1 / %x7AE2 / %x7AE3 /"
            + "	%x7AE5 / %x7AE6 / %x7AEA / %x7AED / %x7AEF / %x7AF0 / %x7AF6 / %x7AF8 /"
            + "	%x7AF9 / %x7AFA / %x7AFF / %x7B02 / %x7B04 / %x7B06 / %x7B08 / %x7B0A /"
            + "	%x7B0B / %x7B0F / %x7B11 / %x7B18 / %x7B19 / %x7B1B / %x7B1E / %x7B20 /"
            + "	%x7B25 / %x7B26 / %x7B28 / %x7B2C / %x7B33 / %x7B35 / %x7B36 / %x7B39 /"
            + "	%x7B45 / %x7B46 / %x7B48 / %x7B49 / %x7B4B / %x7B4C / %x7B4D / %x7B4F /"
            + "	%x7B50 / %x7B51 / %x7B52 / %x7B54 / %x7B56 / %x7B5D / %x7B65 / %x7B67 /"
            + "	%x7B6C / %x7B6E / %x7B70 / %x7B71 / %x7B74 / %x7B75 / %x7B7A / %x7B86 /"
            + "	%x7B87 / %x7B8B / %x7B8D / %x7B8F / %x7B92 / %x7B94 / %x7B95 / %x7B97 /"
            + "	%x7B98 / %x7B99 / %x7B9A / %x7B9C / %x7B9D / %x7B9F / %x7BA1 / %x7BAA /"
            + "	%x7BAD / %x7BB1 / %x7BB4 / %x7BB8 / %x7BC0 / %x7BC1 / %x7BC4 / %x7BC6 /"
            + "	%x7BC7 / %x7BC9 / %x7BCB / %x7BCC / %x7BCF / %x7BDD / %x7BE0 / %x7BE4 /"
            + "	%x7BE5 / %x7BE6 / %x7BE9 / %x7BED / %x7BF3 / %x7BF6 / %x7BF7 / %x7C00 /"
            + "	%x7C07 / %x7C0D / %x7C11 / %x7C12 / %x7C13 / %x7C14 / %x7C17 / %x7C1F /"
            + "	%x7C21 / %x7C23 / %x7C27 / %x7C2A / %x7C2B / %x7C37 / %x7C38 / %x7C3D /"
            + "	%x7C3E / %x7C3F / %x7C40 / %x7C43 / %x7C4C / %x7C4D / %x7C4F / %x7C50 /"
            + "	%x7C54 / %x7C56 / %x7C58 / %x7C5F / %x7C60 / %x7C64 / %x7C65 / %x7C6C /"
            + "	%x7C73 / %x7C75 / %x7C7E / %x7C81 / %x7C82 / %x7C83 / %x7C89 / %x7C8B /"
            + "	%x7C8D / %x7C90 / %x7C92 / %x7C95 / %x7C97 / %x7C98 / %x7C9B / %x7C9F /"
            + "	%x7CA1 / %x7CA2 / %x7CA4 / %x7CA5 / %x7CA7 / %x7CA8 / %x7CAB / %x7CAD /"
            + "	%x7CAE / %x7CB1 / %x7CB2 / %x7CB3 / %x7CB9 / %x7CBD / %x7CBE / %x7CC0 /"
            + "	%x7CC2 / %x7CC5 / %x7CCA / %x7CCE / %x7CD2 / %x7CD6 / %x7CD8 / %x7CDC /"
            + "	%x7CDE / %x7CDF / %x7CE0 / %x7CE2 / %x7CE7 / %x7CEF / %x7CF2 / %x7CF4 /"
            + "	%x7CF6 / %x7CF8 / %x7CFA / %x7CFB / %x7CFE / %x7D00 / %x7D02 / %x7D04 /"
            + "	%x7D05 / %x7D06 / %x7D0A / %x7D0B / %x7D0D / %x7D10 / %x7D14 / %x7D15 /"
            + "	%x7D17 / %x7D18 / %x7D19 / %x7D1A / %x7D1B / %x7D1C / %x7D20 / %x7D21 /"
            + "	%x7D22 / %x7D2B / %x7D2C / %x7D2E / %x7D2F / %x7D30 / %x7D32 / %x7D33 /"
            + "	%x7D35 / %x7D39 / %x7D3A / %x7D3F / %x7D42 / %x7D43 / %x7D44 / %x7D45 /"
            + "	%x7D46 / %x7D4B / %x7D4C / %x7D4E / %x7D4F / %x7D50 / %x7D56 / %x7D5B /"
            + "	%x7D5E / %x7D61 / %x7D62 / %x7D63 / %x7D66 / %x7D68 / %x7D6E / %x7D71 /"
            + "	%x7D72 / %x7D73 / %x7D75 / %x7D76 / %x7D79 / %x7D7D / %x7D89 / %x7D8F /"
            + "	%x7D93 / %x7D99 / %x7D9A / %x7D9B / %x7D9C / %x7D9F / %x7DA2 / %x7DA3 /"
            + "	%x7DAB / %x7DAC / %x7DAD / %x7DAE / %x7DAF / %x7DB0 / %x7DB1 / %x7DB2 /"
            + "	%x7DB4 / %x7DB5 / %x7DB8 / %x7DBA / %x7DBB / %x7DBD / %x7DBE / %x7DBF /"
            + "	%x7DC7 / %x7DCA / %x7DCB / %x7DCF / %x7DD1 / %x7DD2 / %x7DD5 / %x7DD8 /"
            + "	%x7DDA / %x7DDC / %x7DDD / %x7DDE / %x7DE0 / %x7DE1 / %x7DE4 / %x7DE8 /"
            + "	%x7DE9 / %x7DEC / %x7DEF / %x7DF2 / %x7DF4 / %x7DFB / %x7E01 / %x7E04 /"
            + "	%x7E05 / %x7E09 / %x7E0A / %x7E0B / %x7E12 / %x7E1B / %x7E1E / %x7E1F /"
            + "	%x7E21 / %x7E22 / %x7E23 / %x7E26 / %x7E2B / %x7E2E / %x7E31 / %x7E32 /"
            + "	%x7E35 / %x7E37 / %x7E39 / %x7E3A / %x7E3B / %x7E3D / %x7E3E / %x7E41 /"
            + "	%x7E43 / %x7E46 / %x7E4A / %x7E4B / %x7E4D / %x7E54 / %x7E55 / %x7E56 /"
            + "	%x7E59 / %x7E5A / %x7E5D / %x7E5E / %x7E66 / %x7E67 / %x7E69 / %x7E6A /"
            + "	%x7E6D / %x7E70 / %x7E79 / %x7E7B / %x7E7C / %x7E7D / %x7E7F / %x7E82 /"
            + "	%x7E83 / %x7E88 / %x7E89 / %x7E8C / %x7E8E / %x7E8F / %x7E90 / %x7E92 /"
            + "	%x7E93 / %x7E94 / %x7E96 / %x7E9B / %x7E9C / %x7F36 / %x7F38 / %x7F3A /"
            + "	%x7F45 / %x7F4C / %x7F4D / %x7F4E / %x7F50 / %x7F51 / %x7F54 / %x7F55 /"
            + "	%x7F58 / %x7F5F / %x7F60 / %x7F67 / %x7F68 / %x7F69 / %x7F6A / %x7F6B /"
            + "	%x7F6E / %x7F70 / %x7F72 / %x7F75 / %x7F77 / %x7F78 / %x7F79 / %x7F82 /"
            + "	%x7F83 / %x7F85 / %x7F86 / %x7F87 / %x7F88 / %x7F8A / %x7F8C / %x7F8E /"
            + "	%x7F94 / %x7F9A / %x7F9D / %x7F9E / %x7FA3 / %x7FA4 / %x7FA8 / %x7FA9 /"
            + "	%x7FAE / %x7FAF / %x7FB2 / %x7FB6 / %x7FB8 / %x7FB9 / %x7FBD / %x7FC1 /"
            + "	%x7FC5 / %x7FC6 / %x7FCA / %x7FCC / %x7FD2 / %x7FD4 / %x7FD5 / %x7FE0 /"
            + "	%x7FE1 / %x7FE6 / %x7FE9 / %x7FEB / %x7FF0 / %x7FF3 / %x7FF9 / %x7FFB /"
            + "	%x7FFC / %x8000 / %x8001 / %x8003 / %x8004 / %x8005 / %x8006 / %x800B /"
            + "	%x800C / %x8010 / %x8012 / %x8015 / %x8017 / %x8018 / %x8019 / %x801C /"
            + "	%x8021 / %x8028 / %x8033 / %x8036 / %x803B / %x803D / %x803F / %x8046 /"
            + "	%x804A / %x8052 / %x8056 / %x8058 / %x805A / %x805E / %x805F / %x8061 /"
            + "	%x8062 / %x8068 / %x806F / %x8070 / %x8072 / %x8073 / %x8074 / %x8076 /"
            + "	%x8077 / %x8079 / %x807D / %x807E / %x807F / %x8084 / %x8085 / %x8086 /"
            + "	%x8087 / %x8089 / %x808B / %x808C / %x8093 / %x8096 / %x8098 / %x809A /"
            + "	%x809B / %x809D / %x80A1 / %x80A2 / %x80A5 / %x80A9 / %x80AA / %x80AC /"
            + "	%x80AD / %x80AF / %x80B1 / %x80B2 / %x80B4 / %x80BA / %x80C3 / %x80C4 /"
            + "	%x80C6 / %x80CC / %x80CE / %x80D6 / %x80D9 / %x80DA / %x80DB / %x80DD /"
            + "	%x80DE / %x80E1 / %x80E4 / %x80E5 / %x80EF / %x80F1 / %x80F4 / %x80F8 /"
            + "	%x80FC / %x80FD / %x8102 / %x8105 / %x8106 / %x8107 / %x8108 / %x8109 /"
            + "	%x810A / %x811A / %x811B / %x8123 / %x8129 / %x812F / %x8131 / %x8133 /"
            + "	%x8139 / %x813E / %x8146 / %x814B / %x814E / %x8150 / %x8151 / %x8153 /"
            + "	%x8154 / %x8155 / %x815F / %x8165 / %x8166 / %x816B / %x816E / %x8170 /"
            + "	%x8171 / %x8174 / %x8178 / %x8179 / %x817A / %x817F / %x8180 / %x8182 /"
            + "	%x8183 / %x8188 / %x818A / %x818F / %x8193 / %x8195 / %x819A / %x819C /"
            + "	%x819D / %x81A0 / %x81A3 / %x81A4 / %x81A8 / %x81A9 / %x81B0 / %x81B3 /"
            + "	%x81B5 / %x81B8 / %x81BA / %x81BD / %x81BE / %x81BF / %x81C0 / %x81C2 /"
            + "	%x81C6 / %x81C8 / %x81C9 / %x81CD / %x81D1 / %x81D3 / %x81D8 / %x81D9 /"
            + "	%x81DA / %x81DF / %x81E0 / %x81E3 / %x81E5 / %x81E7 / %x81E8 / %x81EA /"
            + "	%x81ED / %x81F3 / %x81F4 / %x81FA / %x81FB / %x81FC / %x81FE / %x8201 /"
            + "	%x8202 / %x8205 / %x8207 / %x8208 / %x8209 / %x820A / %x820C / %x820D /"
            + "	%x820E / %x8210 / %x8212 / %x8216 / %x8217 / %x8218 / %x821B / %x821C /"
            + "	%x821E / %x821F / %x8229 / %x822A / %x822B / %x822C / %x822E / %x8233 /"
            + "	%x8235 / %x8236 / %x8237 / %x8238 / %x8239 / %x8240 / %x8247 / %x8258 /"
            + "	%x8259 / %x825A / %x825D / %x825F / %x8262 / %x8264 / %x8266 / %x8268 /"
            + "	%x826A / %x826B / %x826E / %x826F / %x8271 / %x8272 / %x8276 / %x8277 /"
            + "	%x8278 / %x827E / %x828B / %x828D / %x8292 / %x8299 / %x829D / %x829F /"
            + "	%x82A5 / %x82A6 / %x82AB / %x82AC / %x82AD / %x82AF / %x82B1 / %x82B3 /"
            + "	%x82B8 / %x82B9 / %x82BB / %x82BD / %x82C5 / %x82D1 / %x82D2 / %x82D3 /"
            + "	%x82D4 / %x82D7 / %x82D9 / %x82DB / %x82DC / %x82DE / %x82DF / %x82E1 /"
            + "	%x82E3 / %x82E5 / %x82E6 / %x82E7 / %x82EB / %x82F1 / %x82F3 / %x82F4 /"
            + "	%x82F9 / %x82FA / %x82FB / %x8302 / %x8303 / %x8304 / %x8305 / %x8306 /"
            + "	%x8309 / %x830E / %x8316 / %x8317 / %x8318 / %x831C / %x8323 / %x8328 /"
            + "	%x832B / %x832F / %x8331 / %x8332 / %x8334 / %x8335 / %x8336 / %x8338 /"
            + "	%x8339 / %x8340 / %x8345 / %x8349 / %x834A / %x834F / %x8350 / %x8352 /"
            + "	%x8358 / %x8373 / %x8375 / %x8377 / %x837B / %x837C / %x8385 / %x8387 /"
            + "	%x8389 / %x838A / %x838E / %x8393 / %x8396 / %x839A / %x839E / %x839F /"
            + "	%x83A0 / %x83A2 / %x83A8 / %x83AA / %x83AB / %x83B1 / %x83B5 / %x83BD /"
            + "	%x83C1 / %x83C5 / %x83CA / %x83CC / %x83CE / %x83D3 / %x83D6 / %x83D8 /"
            + "	%x83DC / %x83DF / %x83E0 / %x83E9 / %x83EB / %x83EF / %x83F0 / %x83F1 /"
            + "	%x83F2 / %x83F4 / %x83F7 / %x83FB / %x83FD / %x8403 / %x8404 / %x8407 /"
            + "	%x840B / %x840C / %x840D / %x840E / %x8413 / %x8420 / %x8422 / %x8429 /"
            + "	%x842A / %x842C / %x8431 / %x8435 / %x8438 / %x843C / %x843D / %x8446 /"
            + "	%x8449 / %x844E / %x8457 / %x845B / %x8461 / %x8462 / %x8463 / %x8466 /"
            + "	%x8469 / %x846B / %x846C / %x846D / %x846E / %x846F / %x8471 / %x8475 /"
            + "	%x8477 / %x8479 / %x847A / %x8482 / %x8484 / %x848B / %x8490 / %x8494 /"
            + "	%x8499 / %x849C / %x849F / %x84A1 / %x84AD / %x84B2 / %x84B8 / %x84B9 /"
            + "	%x84BB / %x84BC / %x84BF / %x84C1 / %x84C4 / %x84C6 / %x84C9 / %x84CA /"
            + "	%x84CB / %x84CD / %x84D0 / %x84D1 / %x84D6 / %x84D9 / %x84DA / %x84EC /"
            + "	%x84EE / %x84F4 / %x84FC / %x84FF / %x8500 / %x8506 / %x8511 / %x8513 /"
            + "	%x8514 / %x8515 / %x8517 / %x8518 / %x851A / %x851F / %x8521 / %x8526 /"
            + "	%x852C / %x852D / %x8535 / %x853D / %x8540 / %x8541 / %x8543 / %x8548 /"
            + "	%x8549 / %x854A / %x854B / %x854E / %x8555 / %x8557 / %x8558 / %x855A /"
            + "	%x8563 / %x8568 / %x8569 / %x856A / %x856D / %x8577 / %x857E / %x8580 /"
            + "	%x8584 / %x8587 / %x8588 / %x858A / %x8590 / %x8591 / %x8594 / %x8597 /"
            + "	%x8599 / %x859B / %x859C / %x85A4 / %x85A6 / %x85A8 / %x85A9 / %x85AA /"
            + "	%x85AB / %x85AC / %x85AE / %x85AF / %x85B9 / %x85BA / %x85C1 / %x85C9 /"
            + "	%x85CD / %x85CF / %x85D0 / %x85D5 / %x85DC / %x85DD / %x85E4 / %x85E5 /"
            + "	%x85E9 / %x85EA / %x85F7 / %x85F9 / %x85FA / %x85FB / %x85FE / %x8602 /"
            + "	%x8606 / %x8607 / %x860A / %x860B / %x8613 / %x8616 / %x8617 / %x861A /"
            + "	%x8622 / %x862D / %x862F / %x8630 / %x863F / %x864D / %x864E / %x8650 /"
            + "	%x8654 / %x8655 / %x865A / %x865C / %x865E / %x865F / %x8667 / %x866B /"
            + "	%x8671 / %x8679 / %x867B / %x868A / %x868B / %x868C / %x8693 / %x8695 /"
            + "	%x86A3 / %x86A4 / %x86A9 / %x86AA / %x86AB / %x86AF / %x86B0 / %x86B6 /"
            + "	%x86C4 / %x86C6 / %x86C7 / %x86C9 / %x86CB / %x86CD / %x86CE / %x86D4 /"
            + "	%x86D9 / %x86DB / %x86DE / %x86DF / %x86E4 / %x86E9 / %x86EC / %x86ED /"
            + "	%x86EE / %x86EF / %x86F8 / %x86F9 / %x86FB / %x86FE / %x8700 / %x8702 /"
            + "	%x8703 / %x8706 / %x8708 / %x8709 / %x870A / %x870D / %x8711 / %x8712 /"
            + "	%x8718 / %x871A / %x871C / %x8725 / %x8729 / %x8734 / %x8737 / %x873B /"
            + "	%x873F / %x8749 / %x874B / %x874C / %x874E / %x8753 / %x8755 / %x8757 /"
            + "	%x8759 / %x875F / %x8760 / %x8763 / %x8766 / %x8768 / %x876A / %x876E /"
            + "	%x8774 / %x8776 / %x8778 / %x877F / %x8782 / %x878D / %x879F / %x87A2 /"
            + "	%x87AB / %x87AF / %x87B3 / %x87BA / %x87BB / %x87BD / %x87C0 / %x87C4 /"
            + "	%x87C6 / %x87C7 / %x87CB / %x87D0 / %x87D2 / %x87E0 / %x87EF / %x87F2 /"
            + "	%x87F6 / %x87F7 / %x87F9 / %x87FB / %x87FE / %x8805 / %x880D / %x880E /"
            + "	%x880F / %x8811 / %x8815 / %x8816 / %x8821 / %x8822 / %x8823 / %x8827 /"
            + "	%x8831 / %x8836 / %x8839 / %x883B / %x8840 / %x8842 / %x8844 / %x8846 /"
            + "	%x884C / %x884D / %x8852 / %x8853 / %x8857 / %x8859 / %x885B / %x885D /"
            + "	%x885E / %x8861 / %x8862 / %x8863 / %x8868 / %x886B / %x8870 / %x8872 /"
            + "	%x8875 / %x8877 / %x887D / %x887E / %x887F / %x8881 / %x8882 / %x8888 /"
            + "	%x888B / %x888D / %x8892 / %x8896 / %x8897 / %x8899 / %x889E / %x88A2 /"
            + "	%x88A4 / %x88AB / %x88AE / %x88B0 / %x88B1 / %x88B4 / %x88B5 / %x88B7 /"
            + "	%x88BF / %x88C1 / %x88C2 / %x88C3 / %x88C4 / %x88C5 / %x88CF / %x88D4 /"
            + "	%x88D5 / %x88D8 / %x88D9 / %x88DC / %x88DD / %x88DF / %x88E1 / %x88E8 /"
            + "	%x88F2 / %x88F3 / %x88F4 / %x88F8 / %x88F9 / %x88FC / %x88FD / %x88FE /"
            + "	%x8902 / %x8904 / %x8907 / %x890A / %x890C / %x8910 / %x8912 / %x8913 /"
            + "	%x891D / %x891E / %x8925 / %x892A / %x892B / %x8936 / %x8938 / %x893B /"
            + "	%x8941 / %x8943 / %x8944 / %x894C / %x894D / %x8956 / %x895E / %x895F /"
            + "	%x8960 / %x8964 / %x8966 / %x896A / %x896D / %x896F / %x8972 / %x8974 /"
            + "	%x8977 / %x897E / %x897F / %x8981 / %x8983 / %x8986 / %x8987 / %x8988 /"
            + "	%x898A / %x898B / %x898F / %x8993 / %x8996 / %x8997 / %x8998 / %x899A /"
            + "	%x89A1 / %x89A6 / %x89A7 / %x89A9 / %x89AA / %x89AC / %x89AF / %x89B2 /"
            + "	%x89B3 / %x89BA / %x89BD / %x89BF / %x89C0 / %x89D2 / %x89DA / %x89DC /"
            + "	%x89DD / %x89E3 / %x89E6 / %x89E7 / %x89F4 / %x89F8 / %x8A00 / %x8A02 /"
            + "	%x8A03 / %x8A08 / %x8A0A / %x8A0C / %x8A0E / %x8A10 / %x8A13 / %x8A16 /"
            + "	%x8A17 / %x8A18 / %x8A1B / %x8A1D / %x8A1F / %x8A23 / %x8A25 / %x8A2A /"
            + "	%x8A2D / %x8A31 / %x8A33 / %x8A34 / %x8A36 / %x8A3A / %x8A3B / %x8A3C /"
            + "	%x8A41 / %x8A46 / %x8A48 / %x8A50 / %x8A51 / %x8A52 / %x8A54 / %x8A55 /"
            + "	%x8A5B / %x8A5E / %x8A60 / %x8A62 / %x8A63 / %x8A66 / %x8A69 / %x8A6B /"
            + "	%x8A6C / %x8A6D / %x8A6E / %x8A70 / %x8A71 / %x8A72 / %x8A73 / %x8A7C /"
            + "	%x8A82 / %x8A84 / %x8A85 / %x8A87 / %x8A89 / %x8A8C / %x8A8D / %x8A91 /"
            + "	%x8A93 / %x8A95 / %x8A98 / %x8A9A / %x8A9E / %x8AA0 / %x8AA1 / %x8AA3 /"
            + "	%x8AA4 / %x8AA5 / %x8AA6 / %x8AA8 / %x8AAC / %x8AAD / %x8AB0 / %x8AB2 /"
            + "	%x8AB9 / %x8ABC / %x8ABF / %x8AC2 / %x8AC4 / %x8AC7 / %x8ACB / %x8ACC /"
            + "	%x8ACD / %x8ACF / %x8AD2 / %x8AD6 / %x8ADA / %x8ADB / %x8ADC / %x8ADE /"
            + "	%x8AE0 / %x8AE1 / %x8AE2 / %x8AE4 / %x8AE6 / %x8AE7 / %x8AEB / %x8AED /"
            + "	%x8AEE / %x8AF1 / %x8AF3 / %x8AF7 / %x8AF8 / %x8AFA / %x8AFE / %x8B00 /"
            + "	%x8B01 / %x8B02 / %x8B04 / %x8B07 / %x8B0C / %x8B0E / %x8B10 / %x8B14 /"
            + "	%x8B16 / %x8B17 / %x8B19 / %x8B1A / %x8B1B / %x8B1D / %x8B20 / %x8B21 /"
            + "	%x8B26 / %x8B28 / %x8B2B / %x8B2C / %x8B33 / %x8B39 / %x8B3E / %x8B41 /"
            + "	%x8B49 / %x8B4C / %x8B4E / %x8B4F / %x8B56 / %x8B58 / %x8B5A / %x8B5B /"
            + "	%x8B5C / %x8B5F / %x8B66 / %x8B6B / %x8B6C / %x8B6F / %x8B70 / %x8B71 /"
            + "	%x8B72 / %x8B74 / %x8B77 / %x8B7D / %x8B80 / %x8B83 / %x8B8A / %x8B8C /"
            + "	%x8B8E / %x8B90 / %x8B92 / %x8B93 / %x8B96 / %x8B99 / %x8B9A / %x8C37 /"
            + "	%x8C3A / %x8C3F / %x8C41 / %x8C46 / %x8C48 / %x8C4A / %x8C4C / %x8C4E /"
            + "	%x8C50 / %x8C55 / %x8C5A / %x8C61 / %x8C62 / %x8C6A / %x8C6B / %x8C6C /"
            + "	%x8C78 / %x8C79 / %x8C7A / %x8C7C / %x8C82 / %x8C85 / %x8C89 / %x8C8A /"
            + "	%x8C8C / %x8C8D / %x8C8E / %x8C94 / %x8C98 / %x8C9D / %x8C9E / %x8CA0 /"
            + "	%x8CA1 / %x8CA2 / %x8CA7 / %x8CA8 / %x8CA9 / %x8CAA / %x8CAB / %x8CAC /"
            + "	%x8CAD / %x8CAE / %x8CAF / %x8CB0 / %x8CB2 / %x8CB3 / %x8CB4 / %x8CB6 /"
            + "	%x8CB7 / %x8CB8 / %x8CBB / %x8CBC / %x8CBD / %x8CBF / %x8CC0 / %x8CC1 /"
            + "	%x8CC2 / %x8CC3 / %x8CC4 / %x8CC7 / %x8CC8 / %x8CCA / %x8CCD / %x8CCE /"
            + "	%x8CD1 / %x8CD3 / %x8CDA / %x8CDB / %x8CDC / %x8CDE / %x8CE0 / %x8CE2 /"
            + "	%x8CE3 / %x8CE4 / %x8CE6 / %x8CEA / %x8CED / %x8CFA / %x8CFB / %x8CFC /"
            + "	%x8CFD / %x8D04 / %x8D05 / %x8D07 / %x8D08 / %x8D0A / %x8D0B / %x8D0D /"
            + "	%x8D0F / %x8D10 / %x8D13 / %x8D14 / %x8D16 / %x8D64 / %x8D66 / %x8D67 /"
            + "	%x8D6B / %x8D6D / %x8D70 / %x8D71 / %x8D73 / %x8D74 / %x8D77 / %x8D81 /"
            + "	%x8D85 / %x8D8A / %x8D99 / %x8DA3 / %x8DA8 / %x8DB3 / %x8DBA / %x8DBE /"
            + "	%x8DC2 / %x8DCB / %x8DCC / %x8DCF / %x8DD6 / %x8DDA / %x8DDB / %x8DDD /"
            + "	%x8DDF / %x8DE1 / %x8DE3 / %x8DE8 / %x8DEA / %x8DEB / %x8DEF / %x8DF3 /"
            + "	%x8DF5 / %x8DFC / %x8DFF / %x8E08 / %x8E09 / %x8E0A / %x8E0F / %x8E10 /"
            + "	%x8E1D / %x8E1E / %x8E1F / %x8E2A / %x8E30 / %x8E34 / %x8E35 / %x8E42 /"
            + "	%x8E44 / %x8E47 / %x8E48 / %x8E49 / %x8E4A / %x8E4C / %x8E50 / %x8E55 /"
            + "	%x8E59 / %x8E5F / %x8E60 / %x8E63 / %x8E64 / %x8E72 / %x8E74 / %x8E76 /"
            + "	%x8E7C / %x8E81 / %x8E84 / %x8E85 / %x8E87 / %x8E8A / %x8E8B / %x8E8D /"
            + "	%x8E91 / %x8E93 / %x8E94 / %x8E99 / %x8EA1 / %x8EAA / %x8EAB / %x8EAC /"
            + "	%x8EAF / %x8EB0 / %x8EB1 / %x8EBE / %x8EC5 / %x8EC6 / %x8EC8 / %x8ECA /"
            + "	%x8ECB / %x8ECC / %x8ECD / %x8ED2 / %x8EDB / %x8EDF / %x8EE2 / %x8EE3 /"
            + "	%x8EEB / %x8EF8 / %x8EFB / %x8EFC / %x8EFD / %x8EFE / %x8F03 / %x8F05 /"
            + "	%x8F09 / %x8F0A / %x8F0C / %x8F12 / %x8F13 / %x8F14 / %x8F15 / %x8F19 /"
            + "	%x8F1B / %x8F1C / %x8F1D / %x8F1F / %x8F26 / %x8F29 / %x8F2A / %x8F2F /"
            + "	%x8F33 / %x8F38 / %x8F39 / %x8F3B / %x8F3E / %x8F3F / %x8F42 / %x8F44 /"
            + "	%x8F45 / %x8F46 / %x8F49 / %x8F4C / %x8F4D / %x8F4E / %x8F57 / %x8F5C /"
            + "	%x8F5F / %x8F61 / %x8F62 / %x8F63 / %x8F64 / %x8F9B / %x8F9C / %x8F9E /"
            + "	%x8F9F / %x8FA3 / %x8FA7 / %x8FA8 / %x8FAD / %x8FAE / %x8FAF / %x8FB0 /"
            + "	%x8FB1 / %x8FB2 / %x8FB7 / %x8FBA / %x8FBB / %x8FBC / %x8FBF / %x8FC2 /"
            + "	%x8FC4 / %x8FC5 / %x8FCE / %x8FD1 / %x8FD4 / %x8FDA / %x8FE2 / %x8FE5 /"
            + "	%x8FE6 / %x8FE9 / %x8FEA / %x8FEB / %x8FED / %x8FEF / %x8FF0 / %x8FF4 /"
            + "	%x8FF7 / %x8FF8 / %x8FF9 / %x8FFA / %x8FFD / %x9000 / %x9001 / %x9003 /"
            + "	%x9005 / %x9006 / %x900B / %x900D / %x900E / %x900F / %x9010 / %x9011 /"
            + "	%x9013 / %x9014 / %x9015 / %x9016 / %x9017 / %x9019 / %x901A / %x901D /"
            + "	%x901E / %x901F / %x9020 / %x9021 / %x9022 / %x9023 / %x9027 / %x902E /"
            + "	%x9031 / %x9032 / %x9035 / %x9036 / %x9038 / %x9039 / %x903C / %x903E /"
            + "	%x9041 / %x9042 / %x9045 / %x9047 / %x9049 / %x904A / %x904B / %x904D /"
            + "	%x904E / %x904F / %x9050 / %x9051 / %x9052 / %x9053 / %x9054 / %x9055 /"
            + "	%x9056 / %x9058 / %x9059 / %x905C / %x905E / %x9060 / %x9061 / %x9063 /"
            + "	%x9065 / %x9068 / %x9069 / %x906D / %x906E / %x906F / %x9072 / %x9075 /"
            + "	%x9076 / %x9077 / %x9078 / %x907A / %x907C / %x907D / %x907F / %x9080 /"
            + "	%x9081 / %x9082 / %x9083 / %x9084 / %x9087 / %x9089 / %x908A / %x908F /"
            + "	%x9091 / %x90A3 / %x90A6 / %x90A8 / %x90AA / %x90AF / %x90B1 / %x90B5 /"
            + "	%x90B8 / %x90C1 / %x90CA / %x90CE / %x90DB / %x90E1 / %x90E2 / %x90E4 /"
            + "	%x90E8 / %x90ED / %x90F5 / %x90F7 / %x90FD / %x9102 / %x9112 / %x9119 /"
            + "	%x912D / %x9130 / %x9132 / %x9149 / %x914A / %x914B / %x914C / %x914D /"
            + "	%x914E / %x9152 / %x9154 / %x9156 / %x9158 / %x9162 / %x9163 / %x9165 /"
            + "	%x9169 / %x916A / %x916C / %x9172 / %x9173 / %x9175 / %x9177 / %x9178 /"
            + "	%x9182 / %x9187 / %x9189 / %x918B / %x918D / %x9190 / %x9192 / %x9197 /"
            + "	%x919C / %x91A2 / %x91A4 / %x91AA / %x91AB / %x91AF / %x91B4 / %x91B5 /"
            + "	%x91B8 / %x91BA / %x91C0 / %x91C1 / %x91C6 / %x91C7 / %x91C8 / %x91C9 /"
            + "	%x91CB / %x91CC / %x91CD / %x91CE / %x91CF / %x91D0 / %x91D1 / %x91D6 /"
            + "	%x91D8 / %x91DB / %x91DC / %x91DD / %x91DF / %x91E1 / %x91E3 / %x91E6 /"
            + "	%x91E7 / %x91F5 / %x91F6 / %x91FC / %x91FF / %x920D / %x920E / %x9211 /"
            + "	%x9214 / %x9215 / %x921E / %x9229 / %x922C / %x9234 / %x9237 / %x923F /"
            + "	%x9244 / %x9245 / %x9248 / %x9249 / %x924B / %x9250 / %x9257 / %x925A /"
            + "	%x925B / %x925E / %x9262 / %x9264 / %x9266 / %x9271 / %x927E / %x9280 /"
            + "	%x9283 / %x9285 / %x9291 / %x9293 / %x9295 / %x9296 / %x9298 / %x929A /"
            + "	%x929B / %x929C / %x92AD / %x92B7 / %x92B9 / %x92CF / %x92D2 / %x92E4 /"
            + "	%x92E9 / %x92EA / %x92ED / %x92F2 / %x92F3 / %x92F8 / %x92FA / %x92FC /"
            + "	%x9306 / %x930F / %x9310 / %x9318 / %x9319 / %x931A / %x9320 / %x9322 /"
            + "	%x9323 / %x9326 / %x9328 / %x932B / %x932C / %x932E / %x932F / %x9332 /"
            + "	%x9335 / %x933A / %x933B / %x9344 / %x934B / %x934D / %x9354 / %x9356 /"
            + "	%x935B / %x935C / %x9360 / %x936C / %x936E / %x9375 / %x937C / %x937E /"
            + "	%x938C / %x9394 / %x9396 / %x9397 / %x939A / %x93A7 / %x93AC / %x93AD /"
            + "	%x93AE / %x93B0 / %x93B9 / %x93C3 / %x93C8 / %x93D0 / %x93D1 / %x93D6 /"
            + "	%x93D7 / %x93D8 / %x93DD / %x93E1 / %x93E4 / %x93E5 / %x93E8 / %x9403 /"
            + "	%x9407 / %x9410 / %x9413 / %x9414 / %x9418 / %x9419 / %x941A / %x9421 /"
            + "	%x942B / %x9435 / %x9436 / %x9438 / %x943A / %x9441 / %x9444 / %x9451 /"
            + "	%x9452 / %x9453 / %x945A / %x945B / %x945E / %x9460 / %x9462 / %x946A /"
            + "	%x9470 / %x9475 / %x9477 / %x947C / %x947D / %x947E / %x947F / %x9481 /"
            + "	%x9577 / %x9580 / %x9582 / %x9583 / %x9587 / %x9589 / %x958A / %x958B /"
            + "	%x958F / %x9591 / %x9593 / %x9594 / %x9596 / %x9598 / %x9599 / %x95A0 /"
            + "	%x95A2 / %x95A3 / %x95A4 / %x95A5 / %x95A7 / %x95A8 / %x95AD / %x95B2 /"
            + "	%x95B9 / %x95BB / %x95BC / %x95BE / %x95C3 / %x95C7 / %x95CA / %x95CC /"
            + "	%x95CD / %x95D4 / %x95D5 / %x95D6 / %x95D8 / %x95DC / %x95E1 / %x95E2 /"
            + "	%x95E5 / %x961C / %x9621 / %x9628 / %x962A / %x962E / %x962F / %x9632 /"
            + "	%x963B / %x963F / %x9640 / %x9642 / %x9644 / %x964B / %x964C / %x964D /"
            + "	%x964F / %x9650 / %x965B / %x965C / %x965D / %x965E / %x965F / %x9662 /"
            + "	%x9663 / %x9664 / %x9665 / %x9666 / %x966A / %x966C / %x9670 / %x9672 /"
            + "	%x9673 / %x9675 / %x9676 / %x9677 / %x9678 / %x967A / %x967D / %x9685 /"
            + "	%x9686 / %x9688 / %x968A / %x968B / %x968D / %x968E / %x968F / %x9694 /"
            + "	%x9695 / %x9697 / %x9698 / %x9699 / %x969B / %x969C / %x96A0 / %x96A3 /"
            + "	%x96A7 / %x96A8 / %x96AA / %x96B0 / %x96B1 / %x96B2 / %x96B4 / %x96B6 /"
            + "	%x96B7 / %x96B8 / %x96B9 / %x96BB / %x96BC / %x96C0 / %x96C1 / %x96C4 /"
            + "	%x96C5 / %x96C6 / %x96C7 / %x96C9 / %x96CB / %x96CC / %x96CD / %x96CE /"
            + "	%x96D1 / %x96D5 / %x96D6 / %x96D9 / %x96DB / %x96DC / %x96E2 / %x96E3 /"
            + "	%x96E8 / %x96EA / %x96EB / %x96F0 / %x96F2 / %x96F6 / %x96F7 / %x96F9 /"
            + "	%x96FB / %x9700 / %x9704 / %x9706 / %x9707 / %x9708 / %x970A / %x970D /"
            + "	%x970E / %x970F / %x9711 / %x9713 / %x9716 / %x9719 / %x971C / %x971E /"
            + "	%x9724 / %x9727 / %x972A / %x9730 / %x9732 / %x9738 / %x9739 / %x973D /"
            + "	%x973E / %x9742 / %x9744 / %x9746 / %x9748 / %x9749 / %x9752 / %x9756 /"
            + "	%x9759 / %x975C / %x975E / %x9760 / %x9761 / %x9762 / %x9764 / %x9766 /"
            + "	%x9768 / %x9769 / %x976B / %x976D / %x9771 / %x9774 / %x9779 / %x977A /"
            + "	%x977C / %x9781 / %x9784 / %x9785 / %x9786 / %x978B / %x978D / %x978F /"
            + "	%x9790 / %x9798 / %x979C / %x97A0 / %x97A3 / %x97A6 / %x97A8 / %x97AB /"
            + "	%x97AD / %x97B3 / %x97B4 / %x97C3 / %x97C6 / %x97C8 / %x97CB / %x97D3 /"
            + "	%x97DC / %x97ED / %x97EE / %x97F2 / %x97F3 / %x97F5 / %x97F6 / %x97FB /"
            + "	%x97FF / %x9801 / %x9802 / %x9803 / %x9805 / %x9806 / %x9808 / %x980C /"
            + "	%x980F / %x9810 / %x9811 / %x9812 / %x9813 / %x9817 / %x9818 / %x981A /"
            + "	%x9821 / %x9824 / %x982C / %x982D / %x9834 / %x9837 / %x9838 / %x983B /"
            + "	%x983C / %x983D / %x9846 / %x984B / %x984C / %x984D / %x984E / %x984F /"
            + "	%x9854 / %x9855 / %x9858 / %x985B / %x985E / %x9867 / %x986B / %x986F /"
            + "	%x9870 / %x9871 / %x9873 / %x9874 / %x98A8 / %x98AA / %x98AF / %x98B1 /"
            + "	%x98B6 / %x98C3 / %x98C4 / %x98C6 / %x98DB / %x98DC / %x98DF / %x98E2 /"
            + "	%x98E9 / %x98EB / %x98ED / %x98EE / %x98EF / %x98F2 / %x98F4 / %x98FC /"
            + "	%x98FD / %x98FE / %x9903 / %x9905 / %x9909 / %x990A / %x990C / %x9910 /"
            + "	%x9912 / %x9913 / %x9914 / %x9918 / %x991D / %x991E / %x9920 / %x9921 /"
            + "	%x9924 / %x9928 / %x992C / %x992E / %x993D / %x993E / %x9942 / %x9945 /"
            + "	%x9949 / %x994B / %x994C / %x9950 / %x9951 / %x9952 / %x9955 / %x9957 /"
            + "	%x9996 / %x9997 / %x9998 / %x9999 / %x99A5 / %x99A8 / %x99AC / %x99AD /"
            + "	%x99AE / %x99B3 / %x99B4 / %x99BC / %x99C1 / %x99C4 / %x99C5 / %x99C6 /"
            + "	%x99C8 / %x99D0 / %x99D1 / %x99D2 / %x99D5 / %x99D8 / %x99DB / %x99DD /"
            + "	%x99DF / %x99E2 / %x99ED / %x99EE / %x99F1 / %x99F2 / %x99F8 / %x99FB /"
            + "	%x99FF / %x9A01 / %x9A05 / %x9A0E / %x9A0F / %x9A12 / %x9A13 / %x9A19 /"
            + "	%x9A28 / %x9A2B / %x9A30 / %x9A37 / %x9A3E / %x9A40 / %x9A42 / %x9A43 /"
            + "	%x9A45 / %x9A4D / %x9A55 / %x9A57 / %x9A5A / %x9A5B / %x9A5F / %x9A62 /"
            + "	%x9A64 / %x9A65 / %x9A69 / %x9A6A / %x9A6B / %x9AA8 / %x9AAD / %x9AB0 /"
            + "	%x9AB8 / %x9ABC / %x9AC0 / %x9AC4 / %x9ACF / %x9AD1 / %x9AD3 / %x9AD4 /"
            + "	%x9AD8 / %x9ADE / %x9ADF / %x9AE2 / %x9AE3 / %x9AE6 / %x9AEA / %x9AEB /"
            + "	%x9AED / %x9AEE / %x9AEF / %x9AF1 / %x9AF4 / %x9AF7 / %x9AFB / %x9B06 /"
            + "	%x9B18 / %x9B1A / %x9B1F / %x9B22 / %x9B23 / %x9B25 / %x9B27 / %x9B28 /"
            + "	%x9B29 / %x9B2A / %x9B2E / %x9B2F / %x9B31 / %x9B32 / %x9B3B / %x9B3C /"
            + "	%x9B41 / %x9B42 / %x9B43 / %x9B44 / %x9B45 / %x9B4D / %x9B4E / %x9B4F /"
            + "	%x9B51 / %x9B54 / %x9B58 / %x9B5A / %x9B6F / %x9B74 / %x9B83 / %x9B8E /"
            + "	%x9B91 / %x9B92 / %x9B93 / %x9B96 / %x9B97 / %x9B9F / %x9BA0 / %x9BA8 /"
            + "	%x9BAA / %x9BAB / %x9BAD / %x9BAE / %x9BB4 / %x9BB9 / %x9BC0 / %x9BC6 /"
            + "	%x9BC9 / %x9BCA / %x9BCF / %x9BD1 / %x9BD2 / %x9BD4 / %x9BD6 / %x9BDB /"
            + "	%x9BE1 / %x9BE2 / %x9BE3 / %x9BE4 / %x9BE8 / %x9BF0 / %x9BF1 / %x9BF2 /"
            + "	%x9BF5 / %x9C04 / %x9C06 / %x9C08 / %x9C09 / %x9C0A / %x9C0C / %x9C0D /"
            + "	%x9C10 / %x9C12 / %x9C13 / %x9C14 / %x9C15 / %x9C1B / %x9C21 / %x9C24 /"
            + "	%x9C25 / %x9C2D / %x9C2E / %x9C2F / %x9C30 / %x9C32 / %x9C39 / %x9C3A /"
            + "	%x9C3B / %x9C3E / %x9C46 / %x9C47 / %x9C48 / %x9C52 / %x9C57 / %x9C5A /"
            + "	%x9C60 / %x9C67 / %x9C76 / %x9C78 / %x9CE5 / %x9CE7 / %x9CE9 / %x9CEB /"
            + "	%x9CEC / %x9CF0 / %x9CF3 / %x9CF4 / %x9CF6 / %x9D03 / %x9D06 / %x9D07 /"
            + "	%x9D08 / %x9D09 / %x9D0E / %x9D12 / %x9D15 / %x9D1B / %x9D1F / %x9D23 /"
            + "	%x9D26 / %x9D28 / %x9D2A / %x9D2B / %x9D2C / %x9D3B / %x9D3E / %x9D3F /"
            + "	%x9D41 / %x9D44 / %x9D46 / %x9D48 / %x9D50 / %x9D51 / %x9D59 / %x9D5C /"
            + "	%x9D5D / %x9D5E / %x9D60 / %x9D61 / %x9D64 / %x9D6C / %x9D6F / %x9D72 /"
            + "	%x9D7A / %x9D87 / %x9D89 / %x9D8F / %x9D9A / %x9DA4 / %x9DA9 / %x9DAB /"
            + "	%x9DAF / %x9DB2 / %x9DB4 / %x9DB8 / %x9DBA / %x9DBB / %x9DC1 / %x9DC2 /"
            + "	%x9DC4 / %x9DC6 / %x9DCF / %x9DD3 / %x9DD9 / %x9DE6 / %x9DED / %x9DEF /"
            + "	%x9DF2 / %x9DF8 / %x9DF9 / %x9DFA / %x9DFD / %x9E1A / %x9E1B / %x9E1E /"
            + "	%x9E75 / %x9E78 / %x9E79 / %x9E7D / %x9E7F / %x9E81 / %x9E88 / %x9E8B /"
            + "	%x9E8C / %x9E91 / %x9E92 / %x9E93 / %x9E95 / %x9E97 / %x9E9D / %x9E9F /"
            + "	%x9EA5 / %x9EA6 / %x9EA9 / %x9EAA / %x9EAD / %x9EB8 / %x9EB9 / %x9EBA /"
            + "	%x9EBB / %x9EBC / %x9EBE / %x9EBF / %x9EC4 / %x9ECC / %x9ECD / %x9ECE /"
            + "	%x9ECF / %x9ED0 / %x9ED2 / %x9ED4 / %x9ED8 / %x9ED9 / %x9EDB / %x9EDC /"
            + "	%x9EDD / %x9EDE / %x9EE0 / %x9EE5 / %x9EE8 / %x9EEF / %x9EF4 / %x9EF6 /"
            + "	%x9EF7 / %x9EF9 / %x9EFB / %x9EFC / %x9EFD / %x9F07 / %x9F08 / %x9F0E /"
            + "	%x9F13 / %x9F15 / %x9F20 / %x9F21 / %x9F2C / %x9F3B / %x9F3E / %x9F4A /"
            + "	%x9F4B / %x9F4E / %x9F4F / %x9F52 / %x9F54 / %x9F5F / %x9F60 / %x9F61 /"
            + "	%x9F62 / %x9F63 / %x9F66 / %x9F67 / %x9F6A / %x9F6C / %x9F72 / %x9F76 /"
            + "	%x9F77 / %x9F8D / %x9F95 / %x9F9C / %x9F9D / %x9FA0")));
    static ABNF ALNUM = REG.rule("ALNUM", ABNF5234.ALPHA.or1(ABNF5234.DIGIT));
    static ABNF ALNUM_HYPHEN = REG.rule("ALNUM-HYPHEN", ALNUM.or1(ABNF.bin('-')));
//    static ABNF JAlabel = REG.rule("JA-label",
//            "JA-char"
//            + " / JA-char *( JA-char / ALNUM-HYPHEN ) (JA-char / ALNUM)"
//            + " / ALNUM *( JA-char / ALNUM-HYPHEN ) JA-char *( JA-char / ALNUM-HYPHEN ) ALNUM"
//            + " / ALNUM *( JA-char / ALNUM-HYPHEN ) JA-char"
//    );
    static final ABNF JAlabel = REG.rule("JA-label",
            JA_char.pl(JA_char.or1(ALNUM_HYPHEN).x().plm(JA_char.or1(ALNUM)).c()).or(
                    ALNUM.plu(JA_char.or1(ALNUM_HYPHEN).x(), JA_char, JA_char.or(ALNUM_HYPHEN).x().plm(ALNUM).c()))
    );
    static final ABNF MIDDLE_DOT = REG.rule("MIDDLE-DOT", ABNF.bin(0x30fb));
    static final ABNF EXCEPTION_char = REG.rule("EXCEPTION-char", ABNF.bin(0x3006).or1(ABNF.bin(0x30fc), MIDDLE_DOT));
    static final ABNF EXCEPTING_STRING = REG.rule("EXCEPTION-STRING", EXCEPTION_char.or1(ALNUM_HYPHEN).x().pl(MIDDLE_DOT, EXCEPTION_char.or1(ALNUM_HYPHEN).x()));
    static final ABNF ASCIIlabel = REG.rule("ASCII-label", ALNUM.pl(ALNUM_HYPHEN.x(1, 61), ALNUM));
    static final ABNF label = REG.rule("label", ASCIIlabel.or(JAlabel));
    public static final ABNF genericJPDN = REG.rule("generic-JPDN", label.pl(ABNF.text(".JP")));
}
