/*
 * Decompiled with CFR 0.152.
 */
package org.grumblesmurf;

import com.thaiopensource.relaxng.translate.Driver;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class TrangMojo
extends AbstractMojo {
    private File[] inputFiles;
    private File outputDirectory;
    private String outputFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        long outputModified = outputFile.lastModified();
        boolean stale = false;
        Object[] args = new String[this.inputFiles.length + 1];
        for (int i = 0; i < this.inputFiles.length; ++i) {
            File inputFile = this.inputFiles[i];
            if (!inputFile.isFile()) {
                throw new MojoExecutionException("Input file " + inputFile.getAbsolutePath() + " does not exist as a file");
            }
            if (inputFile.lastModified() > outputModified) {
                stale = true;
            }
            args[i] = this.inputFiles[i].getAbsolutePath();
        }
        args[i] = outputFile.getAbsolutePath();
        if (!stale) {
            this.getLog().info((CharSequence)"Output is current, skipping trang invocation");
            return;
        }
        this.getLog().debug((CharSequence)("Executing trang with parameters " + Arrays.toString(args)));
        String driverClassName = Driver.class.getName();
        try {
            Driver d = new Driver();
            Method run = Driver.class.getDeclaredMethod("run", String[].class);
            run.setAccessible(true);
            Integer returnValue = (Integer)run.invoke((Object)d, new Object[]{args});
            if (returnValue != 0) {
                throw new MojoFailureException("Trang execution failed");
            }
        }
        catch (SecurityException e) {
            throw new MojoExecutionException("Failed to set accessibility of " + driverClassName + ".run()", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Invocation of " + driverClassName + ".run() threw " + e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not access " + driverClassName + ".run()", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Class " + driverClassName + " has no method run(String[])");
        }
    }
}

