/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.io.InputStream;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.cryptacular.util.KeyPairUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class PublicKeyFactoryBean
implements FactoryBean<PublicKey> {
    private Resource resource;
    private PublicKey key;

    public void setResource(@Nonnull Resource res) {
        this.resource = (Resource)Constraint.isNotNull((Object)res, (String)"Public key resource can not be null");
    }

    public PublicKey getObject() throws Exception {
        if (this.key == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Public key resource must be provided in order to use this factory.");
            }
            try (InputStream is = this.resource.getInputStream();){
                this.key = KeyPairUtil.readPublicKey((InputStream)is);
            }
        }
        return this.key;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return PublicKey.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

