/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.ext.spring.resource.FileBackedHTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileBackedHTTPResourceTest {
    private final String existsURL = "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD";
    private final String nonExistsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co";
    private String existsFile;
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
        File file = File.createTempFile("FileBackedHTTPResourceTest1", ".xml");
        this.existsFile = file.getAbsolutePath();
    }

    @AfterClass
    public void deleteFile() {
        File f = new File(this.existsFile);
        if (f.exists()) {
            f.delete();
        }
    }

    @Test
    public void existsTest() throws IOException {
        FileBackedHTTPResource existsResource = new FileBackedHTTPResource(this.existsFile, this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        FileBackedHTTPResource notExistsResource = new FileBackedHTTPResource(this.existsFile + "ZZZ", this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co");
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.existsFile, this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD"), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.existsFile, this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co"), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
    }

    public GenericApplicationContext getContext(String location) {
        MockPropertySource mockEnvVars = new MockPropertySource();
        mockEnvVars.setProperty("file.name", (Object)this.existsFile);
        mockEnvVars.setProperty("the.url", (Object)"https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext();
        context.setDisplayName("ApplicationContext");
        MutablePropertySources propertySources = context.getEnvironment().getPropertySources();
        propertySources.replace("systemProperties", (PropertySource)mockEnvVars);
        PropertySourcesPlaceholderConfigurer placeholderConfig = new PropertySourcesPlaceholderConfigurer();
        placeholderConfig.setPlaceholderPrefix("%{");
        placeholderConfig.setPlaceholderSuffix("}");
        placeholderConfig.setPropertySources((PropertySources)propertySources);
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfig);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions(location);
        beanDefinitionReader.setValidating(true);
        context.refresh();
        return context;
    }

    @Test
    public void testParsingNew() throws IOException {
        try (GenericApplicationContext context = this.getContext("net/shibboleth/ext/spring/resource/newStyle.xml");){
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("namedString", FileBackedHTTPResource.class), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("namedURL", FileBackedHTTPResource.class), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("numberedString", FileBackedHTTPResource.class), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("numberedURL", FileBackedHTTPResource.class), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
        }
    }
}

