/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractServiceableComponent<T>
extends AbstractIdentifiedInitializableComponent
implements ServiceableComponent<T>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractServiceableComponent.class);
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private final ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock(false);

    public void setApplicationContext(ApplicationContext context) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.applicationContext = context;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Nonnull
    public abstract T getComponent();

    public void pinComponent() {
        this.serviceLock.readLock().lock();
    }

    public void unpinComponent() {
        this.serviceLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadComponent() {
        if (null == this.applicationContext) {
            this.log.debug("Component '{}': Component already unloaded", (Object)this.getId());
            return;
        }
        ConfigurableApplicationContext oldContext = null;
        this.log.debug("Component '{}': Component unload called", (Object)this.getId());
        try {
            this.log.trace("Component '{}': Queueing for write lock", (Object)this.getId());
            this.serviceLock.writeLock().lock();
            this.log.trace("Component '{}': Got write lock", (Object)this.getId());
            oldContext = (ConfigurableApplicationContext)this.applicationContext;
            this.applicationContext = null;
        }
        finally {
            this.serviceLock.writeLock().unlock();
        }
        if (null != oldContext) {
            this.log.debug("Component '{}': Closing the appcontext", (Object)this.getId());
            oldContext.close();
        }
        this.destroy();
    }

    protected void doDestroy() {
        this.unloadComponent();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.applicationContext != null && !(this.applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ComponentInitializationException(this.getId() + ": Application context did not implement ConfigurableApplicationContext");
        }
    }
}

