/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;

public class DurationToLongConverter
implements Converter<String, Long>,
ConditionalConverter {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DurationToLongConverter.class);

    public Long convert(String source) {
        if (source.startsWith("P") || source.startsWith("-P")) {
            return DOMTypeSupport.durationToLong((String)source.trim());
        }
        long duration = Long.valueOf(source);
        this.log.info("Deprecated duration of {} was specified. Use XML duration of {}", (Object)source, (Object)DOMTypeSupport.longToDuration((long)duration));
        return duration;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(Duration.class);
    }
}

