/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import net.shibboleth.ext.spring.service.ReloadableSpringService;
import net.shibboleth.ext.spring.service.TestServiceableComponent;
import net.shibboleth.ext.spring.util.ApplicationContextBuilder;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class ReloadableSpringServiceTest {
    private static final long RELOAD_DELAY = 100L;
    private File testFile;

    private void createPopulatedFile(String dataPath) throws IOException {
        this.testFile = File.createTempFile("ReloadableSpringServiceTest", ".xml");
        this.overwriteFileWith(dataPath);
        this.testFile.setLastModified(1471228928L);
    }

    @AfterMethod
    public void deleteFile() {
        if (null != this.testFile && this.testFile.exists()) {
            this.testFile.delete();
        }
    }

    private Resource testFileResource() {
        return new FileSystemResource(this.testFile);
    }

    private void overwriteFileWith(String newDataPath) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.testFile);
        ByteStreams.copy((InputStream)new ClassPathResource(newDataPath).getInputStream(), (OutputStream)stream);
        ((OutputStream)stream).close();
    }

    @Test(enabled=true)
    public void reloadableService() throws IOException, InterruptedException {
        ReloadableSpringService service = new ReloadableSpringService(TestServiceableComponent.class);
        this.createPopulatedFile("net/shibboleth/ext/spring/service/ServiceableBean1.xml");
        service.setFailFast(true);
        service.setId("reloadableService");
        service.setReloadCheckDelay(100L);
        service.setServiceConfigurations(Collections.singletonList(this.testFileResource()));
        service.start();
        ServiceableComponent serviceableComponent = service.getServiceableComponent();
        TestServiceableComponent component = (TestServiceableComponent)((Object)serviceableComponent.getComponent());
        Assert.assertEquals((String)"One", (String)component.getTheValue());
        Assert.assertFalse((boolean)component.getComponent().isDestroyed());
        serviceableComponent.unpinComponent();
        this.overwriteFileWith("net/shibboleth/ext/spring/service/ServiceableBean2.xml");
        for (long count = 70L; count > 0L && !component.isDestroyed(); --count) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)component.isDestroyed(), (String)"After 7 second initial component has still not be destroyed");
        Assert.assertTrue((boolean)((TestServiceableComponent)((Object)serviceableComponent.getComponent())).isDestroyed());
        serviceableComponent = service.getServiceableComponent();
        Assert.assertEquals((String)((TestServiceableComponent)((Object)serviceableComponent.getComponent())).getTheValue(), (String)"Two");
        serviceableComponent.unpinComponent();
        service.stop();
        this.testFile.delete();
    }

    @Test(enabled=true)
    public void deferedReload() throws IOException, InterruptedException {
        long count;
        ReloadableSpringService service = new ReloadableSpringService(TestServiceableComponent.class);
        this.createPopulatedFile("net/shibboleth/ext/spring/service/ServiceableBean1.xml");
        service.setFailFast(true);
        service.setId("deferedReload");
        service.setReloadCheckDelay(100L);
        service.setServiceConfigurations(Collections.singletonList(this.testFileResource()));
        service.start();
        ServiceableComponent serviceableComponent = service.getServiceableComponent();
        TestServiceableComponent component = (TestServiceableComponent)((Object)serviceableComponent.getComponent());
        DateTime x = service.getLastReloadAttemptInstant();
        Assert.assertEquals((Object)x, (Object)service.getLastSuccessfulReloadInstant());
        Assert.assertEquals((String)component.getTheValue(), (String)"One");
        Assert.assertFalse((boolean)component.isDestroyed());
        Thread.sleep(300L);
        Assert.assertEquals((Object)x, (Object)service.getLastReloadAttemptInstant());
        this.overwriteFileWith("net/shibboleth/ext/spring/service/ServiceableBean2.xml");
        Assert.assertFalse((boolean)component.isDestroyed());
        TestServiceableComponent component2 = null;
        for (count = 70L; count > 0L; --count) {
            serviceableComponent = service.getServiceableComponent();
            component2 = (TestServiceableComponent)((Object)serviceableComponent.getComponent());
            if ("Two".equals(component2.getTheValue())) {
                component2.unpinComponent();
                break;
            }
            component2.unpinComponent();
            component2 = null;
            Thread.sleep(100L);
        }
        Assert.assertNotNull(component2, (String)"After 7 second initial component has still not got new value");
        component.unpinComponent();
        for (count = 70L; count > 0L && !component.isDestroyed(); --count) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)component.isDestroyed(), (String)"After 7 second initial component has still not be destroyed");
        service.stop();
        this.testFile.delete();
    }

    @Test
    public void testFailFast() throws IOException, InterruptedException {
        ReloadableSpringService service = new ReloadableSpringService(TestServiceableComponent.class);
        this.createPopulatedFile("net/shibboleth/ext/spring/service/BrokenBean1.xml");
        service.setFailFast(true);
        service.setId("testFailFast");
        service.setReloadCheckDelay(0L);
        service.setServiceConfigurations(Collections.singletonList(this.testFileResource()));
        try {
            service.start();
            Assert.fail((String)"Expected to fail");
        }
        catch (BeanInitializationException beanInitializationException) {
            // empty catch block
        }
        Assert.assertNull((Object)service.getServiceableComponent());
        this.overwriteFileWith("net/shibboleth/ext/spring/service/ServiceableBean2.xml");
        Thread.sleep(200L);
        Assert.assertNull((Object)service.getServiceableComponent());
        service.stop();
        this.testFile.delete();
    }

    @Test
    public void testNotFailFast() throws IOException, InterruptedException {
        long count;
        ReloadableSpringService service = new ReloadableSpringService(TestServiceableComponent.class);
        this.createPopulatedFile("net/shibboleth/ext/spring/service/BrokenBean1.xml");
        service.setFailFast(false);
        service.setId("testNotFailFast");
        service.setReloadCheckDelay(100L);
        service.setServiceConfigurations(Collections.singletonList(this.testFileResource()));
        service.start();
        Assert.assertNull((Object)service.getServiceableComponent());
        this.overwriteFileWith("net/shibboleth/ext/spring/service/ServiceableBean2.xml");
        ServiceableComponent serviceableComponent = service.getServiceableComponent();
        for (count = 700L; count > 0L && null == serviceableComponent; --count) {
            Thread.sleep(100L);
            serviceableComponent = service.getServiceableComponent();
        }
        Assert.assertNotNull((Object)serviceableComponent, (String)"After 7 second component has still no initialized");
        TestServiceableComponent component = (TestServiceableComponent)((Object)serviceableComponent.getComponent());
        Assert.assertEquals((String)component.getTheValue(), (String)"Two");
        Assert.assertFalse((boolean)component.isDestroyed());
        component.unpinComponent();
        service.stop();
        for (count = 70L; count > 0L && !component.isDestroyed(); --count) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)component.isDestroyed(), (String)"After 7 seconds component has still not be destroyed");
        this.testFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplicationContextAware() {
        ClassPathResource parentResource = new ClassPathResource("net/shibboleth/ext/spring/service/ReloadableSpringService.xml");
        try (GenericApplicationContext appCtx = new ApplicationContextBuilder().setName("appCtx").setServiceConfigurations(Collections.singletonList(parentResource)).build();){
            ReloadableSpringService service = (ReloadableSpringService)appCtx.getBean("testReloadableSpringService", ReloadableSpringService.class);
            Assert.assertNotNull((Object)service.getParentContext(), (String)"Parent context should not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanNameAware() {
        ClassPathResource parentResource = new ClassPathResource("net/shibboleth/ext/spring/service/ReloadableSpringService.xml");
        try (GenericApplicationContext appCtx = new ApplicationContextBuilder().setName("appCtx").setServiceConfigurations(Collections.singletonList(parentResource)).build();){
            ReloadableSpringService service1 = (ReloadableSpringService)appCtx.getBean("testReloadableSpringService", ReloadableSpringService.class);
            Assert.assertEquals((String)service1.getId(), (String)"testReloadableSpringService");
            ReloadableSpringService service2 = (ReloadableSpringService)appCtx.getBean("testReloadableSpringServiceWithCustomID", ReloadableSpringService.class);
            Assert.assertEquals((String)service2.getId(), (String)"CustomID");
        }
    }
}

