/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.HashSet;
import net.shibboleth.ext.spring.resource.HTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.resource.TestHTTPResource;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.InMemoryCachingHttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.joda.time.DateTime;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HTTPResourceTest {
    private final String existsURL = "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD";
    private final String nonExistsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co";
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @Test
    public void existsTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        HTTPResource notExistsResource = new HTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co");
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void contextHandlerNoopTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
            }
        });
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailBeforeTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
                throw new IOException("Fail");
            }

            public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
            }
        });
        Assert.assertFalse((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailAfterTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
                throw new IOException("Fail");
            }
        });
        Assert.assertFalse((boolean)existsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new HTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD"), (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
    }

    @Test
    public void testRelated() throws IOException {
        HTTPResource parent = new HTTPResource(this.client, "http://test.shibboleth.net/downloads/identity-provider/archive/2.0.0/");
        HTTPResource child = parent.createRelative("shibboleth-idp-2.0.0-bin.zip");
        long when = child.lastModified();
        long size = child.contentLength();
        String whenAsString = new DateTime(when).toString();
        Assert.assertEquals((long)when, (long)1588006169000L, (String)("Expected date of " + whenAsString + " did not match)"));
        Assert.assertEquals((long)size, (long)20784226L, (String)"Size mismatch");
    }

    @Test
    public void testCachedNoCache() throws IOException, InterruptedException {
        TestHTTPResource what = new TestHTTPResource(this.client, "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNull((Object)what.getLastCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
        Assert.assertNull((Object)what.getLastCacheResponseStatus());
    }

    @Test
    public void testCachedCache() throws Exception {
        InMemoryCachingHttpClientBuilder builder = new InMemoryCachingHttpClientBuilder();
        builder.setMaxCacheEntries(3);
        TestHTTPResource what = new TestHTTPResource(builder.buildClient(), "https://git.shibboleth.net/view/?p=spring-extensions.git;a=blob_plain;f=src/test/resources/data/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
        Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
    }

    private GenericApplicationContext getContext(String fileName, File theDir) {
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        parentContext.getBeanFactory().registerSingleton("theDir", (Object)theDir);
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(fileName);
        context.refresh();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void springLoadMemCache() throws IOException {
        GenericApplicationContext context = this.getContext("classpath:net/shibboleth/ext/spring/resource/MemBackedHTTPBean.xml", null);
        try {
            Collection beans = context.getBeansOfType(TestHTTPResource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            TestHTTPResource what = (TestHTTPResource)((Object)beans.iterator().next());
            Assert.assertTrue((boolean)what.exists());
            Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
            Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
        }
        finally {
            ((GenericApplicationContext)context.getParent()).close();
            context.close();
        }
    }

    private void emptyDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.emptyDir(f);
            }
            Assert.assertTrue((boolean)f.delete());
        }
        Assert.assertTrue((boolean)dir.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(enabled=false)
    public void springLoadFileCache() throws IOException {
        File theDir = null;
        GenericApplicationContext context = null;
        try {
            HashSet prot = Sets.newHashSet((Object[])PosixFilePermission.values());
            Path p = Files.createTempDirectory("HTTPResourceTest", PosixFilePermissions.asFileAttribute(prot));
            theDir = p.toFile();
            context = this.getContext("classpath:net/shibboleth/ext/spring/resource/MemBackedHTTPBean.xml", null);
            Collection beans = context.getBeansOfType(TestHTTPResource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            TestHTTPResource what = (TestHTTPResource)((Object)beans.iterator().next());
            Assert.assertTrue((boolean)what.exists());
            Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
            Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
            if (null != theDir) {
                this.emptyDir(theDir);
            }
            if (null == context) return;
        }
        catch (Throwable throwable) {
            if (null != theDir) {
                this.emptyDir(theDir);
            }
            if (null == context) throw throwable;
            ((GenericApplicationContext)context.getParent()).close();
            context.close();
            throw throwable;
        }
        ((GenericApplicationContext)context.getParent()).close();
        context.close();
    }

    @Test(timeOut=2000L)
    public void testCloseResponse() {
        try (PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();){
            HTTPResource notExistsResource = new HTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co");
            int count = 0;
            while (count <= connMgr.getDefaultMaxPerRoute()) {
                ++count;
                try {
                    notExistsResource.getInputStream();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Bad URL", (Throwable)e);
        }
    }
}

