/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.script.ScriptException;
import net.shibboleth.ext.spring.resource.RunnableFileSystemResource;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.scripting.ScriptedRunnable;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RunnableResourceTest {
    private String fileName;
    private CustomObject object;

    @BeforeClass
    public void setupClient() throws Exception {
        File file = File.createTempFile("RunnableResourceTest", ".xml");
        this.fileName = file.getAbsolutePath();
        this.object = new CustomObject();
    }

    @AfterClass
    public void deleteFile() {
        File f = new File(this.fileName);
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getValue(Resource resource) throws IOException {
        InputStream io = null;
        try {
            io = resource.getInputStream();
            byte by = (byte)io.read();
            return by;
        }
        finally {
            if (null != io) {
                io.close();
            }
        }
    }

    @BeforeMethod
    public void reset() {
        this.object.reset();
    }

    @Test
    public void testCustomObject() throws IOException {
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)0));
        Assert.assertFalse((boolean)this.object.isValid((byte)1));
        this.object.update();
        Assert.assertTrue((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)0));
        Assert.assertTrue((boolean)this.object.isValid((byte)1));
        Assert.assertFalse((boolean)this.object.isValid((byte)0));
    }

    @Test
    public void testRunnable() throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript("custom.update();");
        ScriptedRunnable runnable = new ScriptedRunnable();
        runnable.setCustomObject((Object)this.object);
        runnable.setScript(script);
        runnable.setId("Runnable");
        runnable.initialize();
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)0));
        Assert.assertFalse((boolean)this.object.isValid((byte)1));
        runnable.run();
        Assert.assertTrue((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)0));
        Assert.assertTrue((boolean)this.object.isValid((byte)1));
        Assert.assertFalse((boolean)this.object.isValid((byte)0));
    }

    @Test
    public void testResource() throws ScriptException, ComponentInitializationException, IOException, InterruptedException {
        long now = new File(this.fileName).lastModified();
        EvaluableScript script = new EvaluableScript("custom.update();");
        ScriptedRunnable runnable = new ScriptedRunnable();
        runnable.setCustomObject((Object)this.object);
        runnable.setScript(script);
        runnable.setId("Runnable");
        runnable.initialize();
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertFalse((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)0));
        RunnableFileSystemResource resource = new RunnableFileSystemResource(this.fileName, (Runnable)runnable);
        Assert.assertTrue((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid((byte)1));
        Assert.assertTrue((boolean)this.object.isValid(this.getValue((Resource)resource)));
        Assert.assertTrue((boolean)this.object.isValid((byte)2));
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid(this.getValue((Resource)resource)));
        Assert.assertTrue((boolean)this.object.isValid((byte)4));
        Thread.sleep(20L);
        long modified = resource.lastModified();
        Assert.assertTrue((boolean)this.object.wasUppdated());
        Assert.assertTrue((boolean)this.object.isValid(this.getValue((Resource)resource)));
        Assert.assertTrue((boolean)this.object.isValid((byte)6));
        Assert.assertTrue((modified >= now ? 1 : 0) != 0);
        Thread.sleep(20L);
        Assert.assertTrue((modified <= new File(this.fileName).lastModified() ? 1 : 0) != 0);
    }

    @Test(enabled=true)
    public void testSpringLoad() {
        GenericApplicationContext context = new GenericApplicationContext();
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions("classpath:net/shibboleth/ext/spring/resource/RunnableResource.xml");
        context.refresh();
        Collection beans = context.getBeansOfType(Resource.class).values();
        Assert.assertEquals((int)beans.size(), (int)1);
    }

    public class CustomObject {
        private final File theFile;
        private byte count;
        private byte lastCheck;
        private boolean updated;

        public CustomObject() {
            this.theFile = new File(RunnableResourceTest.this.fileName);
        }

        public void update() throws IOException {
            FileOutputStream io = null;
            try {
                io = new FileOutputStream(this.theFile);
                io.write(this.count);
                if (this.count == 127) {
                    throw new IOException("Count wrapped");
                }
                this.count = (byte)(this.count + 1);
                this.updated = true;
            }
            finally {
                if (null != io) {
                    io.close();
                }
            }
        }

        public boolean isValid(byte what) {
            if (what >= this.lastCheck && what <= this.count) {
                this.lastCheck = what;
                return true;
            }
            return false;
        }

        public boolean wasUppdated() {
            boolean result = this.updated;
            this.updated = false;
            return result;
        }

        public void reset() {
            this.updated = false;
            this.count = 0;
            this.lastCheck = 0;
        }
    }
}

