/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.Collection;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.resource.SVNResource;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class SVNResourceTest {
    private static final String ORIGINAL_TEXT = "This is a Test Resource which will be superseded by other Data";
    private static final int ORIGINAL_VERSION = 492;
    private static final String PATH = "net/shibboleth/ext/spring/resource/";
    private static final String SVN_PATH = "/utilities/spring-extensions/trunk/src/test/resources/net/shibboleth/ext/spring/resource/";
    private static final String FILENAME = "TestResource.txt";
    private static final String CLASSPATH_PATH = "net/shibboleth/ext/spring/resource/TestResource.txt";
    private SVNClientManager clientManager;
    private Resource comparer = new ClassPathResource("net/shibboleth/ext/spring/resource/TestResource.txt");
    private SVNURL url;
    private File theDir;

    @BeforeClass
    public void setup() throws SVNException, IOException {
        BasicAuthenticationManager authnManager = new BasicAuthenticationManager(null);
        this.clientManager = SVNClientManager.newInstance();
        this.clientManager.setAuthenticationManager((ISVNAuthenticationManager)authnManager);
        this.url = SVNURL.create((String)"https", null, (String)"svn.shibboleth.net", (int)-1, (String)SVN_PATH, (boolean)false);
    }

    @BeforeMethod
    public void makeDir() throws IOException {
        Path p = Files.createTempDirectory("SVNResourceTest", new FileAttribute[0]);
        this.theDir = p.toFile();
    }

    private void emptyDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.emptyDir(f);
            }
            f.delete();
        }
    }

    @AfterMethod
    public void emptyDir() {
        this.emptyDir(this.theDir);
        this.theDir.delete();
        this.theDir = null;
    }

    @Test(enabled=false)
    public void testRevision() throws IOException, ParseException {
        SVNResource resource = new SVNResource(this.clientManager, this.url, this.theDir, 492L, FILENAME);
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertEquals((long)resource.lastModified(), (long)new DateTime(2013, 12, 31, 16, 54, 40, 927, DateTimeZone.UTC).getMillis());
        ByteArrayResource other = new ByteArrayResource(ORIGINAL_TEXT.getBytes());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)other, (Resource)resource));
        Assert.assertFalse((boolean)ResourceTestHelper.compare(this.comparer, (Resource)resource));
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)other, (Resource)resource));
    }

    @Test(enabled=false)
    public void testNotExist() {
        SVNResource resource = new SVNResource(this.clientManager, this.url, this.theDir, 442L, FILENAME);
        Assert.assertFalse((boolean)resource.exists());
    }

    @Test(enabled=false)
    public void testMain() throws IOException {
        SVNResource resource = new SVNResource(this.clientManager, this.url, this.theDir, -1L, FILENAME);
        Assert.assertTrue((boolean)resource.exists());
        long delta = resource.lastModified() - new DateTime(2013, 12, 31, 16, 59, 6, 500, DateTimeZone.UTC).getMillis();
        Assert.assertTrue((delta < 501L && delta > -501L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ResourceTestHelper.compare(this.comparer, (Resource)resource));
    }

    private GenericApplicationContext getContext(String fileName) {
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        parentContext.getBeanFactory().registerSingleton("theDir", (Object)this.theDir);
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(fileName);
        context.refresh();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false)
    public void testSpringLoad() {
        GenericApplicationContext context = this.getContext("classpath:net/shibboleth/ext/spring/resource/SVNBean.xml");
        try {
            Collection beans = context.getBeansOfType(Resource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            Resource r = (Resource)beans.iterator().next();
            Assert.assertTrue((boolean)r.exists());
        }
        finally {
            ((GenericApplicationContext)context.getParent()).close();
            context.close();
        }
    }
}

