/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import net.shibboleth.ext.spring.resource.HTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.resource.TestHTTPResource;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.InMemoryCachingHttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.CacheResponseStatus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HTTPResourceTest {
    private final String existsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co";
    private final String nonExistsURL = "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co";
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @Test
    public void existsTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co");
        HTTPResource notExistsResource = new HTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/documxent.xml?view=co");
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new HTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co"), (Resource)new ClassPathResource("data/document.xml")));
    }

    @Test
    public void testRelated() throws IOException {
        HTTPResource parent = new HTTPResource(this.client, "http://shibboleth.net/downloads/identity-provider/2.0.0/");
        HTTPResource child = parent.createRelative("shibboleth-idp-2.0.0-bin.zip");
        long when = child.lastModified();
        long size = child.contentLength();
        String whenAsString = new DateTime(when).toString();
        Assert.assertEquals((long)when, (long)1205848652000L, (String)("Expected date of " + whenAsString + " did not match)"));
        Assert.assertEquals((long)size, (long)20784226L, (String)"Size mismatch");
    }

    @Test
    public void testCachedNoCache() throws IOException, InterruptedException {
        TestHTTPResource what = new TestHTTPResource(this.client, "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNull((Object)what.getLasteCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("data/document.xml")));
        Assert.assertNull((Object)what.getLasteCacheResponseStatus());
    }

    @Test
    public void testCachedCache() throws Exception {
        InMemoryCachingHttpClientBuilder builder = new InMemoryCachingHttpClientBuilder();
        builder.setMaxCacheEntries(3);
        TestHTTPResource what = new TestHTTPResource(builder.buildClient(), "http://svn.shibboleth.net/view/utilities/spring-extensions/trunk/src/test/resources/data/document.xml?view=co");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNotNull((Object)what.getLasteCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("data/document.xml")));
        Assert.assertEquals((Object)what.getLasteCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
    }

    private TestHTTPResource getBean(String fileName, File theDir) {
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        parentContext.getBeanFactory().registerSingleton("theDir", (Object)theDir);
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(fileName);
        context.refresh();
        Collection beans = context.getBeansOfType(TestHTTPResource.class).values();
        Assert.assertEquals((int)beans.size(), (int)1);
        return (TestHTTPResource)((Object)beans.iterator().next());
    }

    @Test
    public void springLoadMemCache() throws IOException {
        TestHTTPResource what = this.getBean("classpath:data/MemBackedHTTPBean.xml", null);
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNotNull((Object)what.getLasteCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("data/document.xml")));
        Assert.assertEquals((Object)what.getLasteCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
    }

    private void emptyDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.emptyDir(f);
            }
            f.delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void springLoadFileCache() throws IOException {
        File theDir = null;
        Path p = Files.createTempDirectory("HTTPResourceTest", new FileAttribute[0]);
        try {
            theDir = p.toFile();
            TestHTTPResource what = this.getBean("classpath:data/FileBackedHTTPBean.xml", theDir);
            Assert.assertTrue((boolean)what.exists());
            Assert.assertNotNull((Object)what.getLasteCacheResponseStatus());
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("data/document.xml")));
            Assert.assertEquals((Object)what.getLasteCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
        }
        finally {
            if (null != theDir) {
                this.emptyDir(theDir);
            }
        }
    }
}

