/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(value={"X509CertificateFactoryBean-config.xml"})
public class X509CertificateFactoryBeanTest
extends AbstractTestNGSpringContextTests {
    @Test
    public void testFactory() {
        Object bean = this.applicationContext.getBean("certificate");
        Assert.notNull((Object)bean);
        Assert.isInstanceOf(X509Certificate.class, (Object)bean);
        X509Certificate cert = (X509Certificate)bean;
        PublicKey pubkey = cert.getPublicKey();
        Assert.notNull((Object)pubkey);
        Assert.isInstanceOf(RSAPublicKey.class, (Object)pubkey);
        RSAPublicKey rsaKey = (RSAPublicKey)pubkey;
        Assert.isTrue((rsaKey.getModulus().bitLength() == 2048 ? 1 : 0) != 0);
    }
}

